/*
 * Decompiled with CFR 0.152.
 */
package standalone.ycsb;

import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.Consistency;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.Key;
import oracle.kv.RequestLimitConfig;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.stats.KVStats;
import oracle.kv.stats.NodeMetrics;

public class KVClient
extends DB {
    static final int SUCCESS = 0;
    static final int FAIL = 1;
    static Object initKVStoreLock = new Object();
    static KVStore kvStore;
    static Timer statsTimer;
    static StatsTask statsTask;
    static AtomicInteger activeClients;
    private static final int MAX_VERSION_RETRIES = 10;
    private ByteBuffer outputBuffer;
    private boolean USE_RMW = false;
    private Consistency useConsistency = Consistency.ABSOLUTE;
    private Consistency useRMWConsistency = Consistency.ABSOLUTE;
    private int keyCount;
    private long totalKeyBytes;
    private int valueCount;
    private long totalValueBytes;
    private static volatile int stackTraceCount;
    private int stackTraceLimit;
    private static volatile int versionMismatches;
    private static volatile int versionRetryLimitExceeded;
    private static volatile int totalUpdates;

    public int delete(String table, String key) {
        assert ("usertable".equals(table));
        Key kvKey = this.createKVKey(key);
        try {
            return kvStore.delete(kvKey) ? 0 : 1;
        }
        catch (FaultException e) {
            System.err.println("Exception during delete: " + e.getMessage());
            return 1;
        }
    }

    public int insert(String table, String key, HashMap<String, String> values) {
        return this.putInternal(table, key, values, null);
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, String> result) {
        ValueVersion ret = this.readInternal(table, key, fields, result, this.useConsistency);
        if (ret == null) {
            return 1;
        }
        return 0;
    }

    private ValueVersion readInternal(String table, String key, Set<String> fields, HashMap<String, String> result, Consistency consistency) {
        ValueVersion kvValue;
        assert ("usertable".equals(table));
        Key kvKey = this.createKVKey(key);
        try {
            kvValue = consistency == null ? kvStore.get(kvKey) : kvStore.get(kvKey, consistency, 0L, null);
            if (kvValue == null) {
                return null;
            }
        }
        catch (FaultException e) {
            System.err.println("Exception during read: " + e.getMessage());
            if (stackTraceCount++ < this.stackTraceLimit) {
                e.printStackTrace(System.err);
            }
            return null;
        }
        this.setResult(kvValue.getValue(), fields, result);
        return kvValue;
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, String>> result) {
        return 1;
    }

    public int update(String table, String key, HashMap<String, String> updateValues) {
        ++totalUpdates;
        if (this.USE_RMW) {
            return this.updateRMW(table, key, updateValues);
        }
        return this.updateNoRMW(table, key, updateValues);
    }

    private int updateNoRMW(String table, String key, HashMap<String, String> updateValues) {
        assert ("usertable".equals(table));
        HashMap<String, String> values = new HashMap<String, String>();
        ValueVersion result = this.readInternal(table, key, null, values, this.useConsistency);
        if (result == null) {
            return 1;
        }
        for (Map.Entry<String, String> entry : updateValues.entrySet()) {
            values.put(entry.getKey(), entry.getValue());
        }
        return this.putInternal(table, key, values, null);
    }

    private int updateRMW(String table, String key, HashMap<String, String> updateValues) {
        assert ("usertable".equals(table));
        HashMap<String, String> values = new HashMap<String, String>();
        Consistency consistency = this.useRMWConsistency;
        for (int i = 0; i < 10; ++i) {
            ValueVersion result = this.readInternal(table, key, null, values, consistency);
            if (result == null) {
                return 1;
            }
            for (Map.Entry<String, String> entry : updateValues.entrySet()) {
                values.put(entry.getKey(), entry.getValue());
            }
            int ret = this.putInternal(table, key, values, result);
            if (ret == 1) {
                System.err.println("Version mismatch:" + result.getVersion());
                ++versionMismatches;
            } else {
                return ret;
            }
            consistency = Consistency.ABSOLUTE;
        }
        System.err.println("Version retry limit:10 exceeded.");
        ++versionRetryLimitExceeded;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws DBException {
        String rmwConsistencyName;
        activeClients.incrementAndGet();
        String topoHost = this.getProperties().getProperty("topoHost");
        this.USE_RMW = Boolean.parseBoolean(this.getProperties().getProperty("useRMW"));
        String consistencyName = this.getProperties().getProperty("useConsistency");
        if (consistencyName != null && "NONE_REQUIRED".equals(consistencyName)) {
            this.useConsistency = Consistency.NONE_REQUIRED;
        }
        if ((rmwConsistencyName = this.getProperties().getProperty("useRMWConsistency")) != null && "NONE_REQUIRED".equals(rmwConsistencyName)) {
            this.useRMWConsistency = Consistency.NONE_REQUIRED;
        }
        int fieldLength = Integer.parseInt(this.getProperties().getProperty("fieldlength", "100"));
        int fieldCount = Integer.parseInt(this.getProperties().getProperty("fieldcount", "10"));
        int fieldKeySize = "field".length() + 3;
        int outputBufferSize = fieldCount * (fieldLength + fieldKeySize) * 2;
        this.outputBuffer = ByteBuffer.allocate(outputBufferSize);
        String reggiePortString = this.getProperties().getProperty("reggiePort");
        int reggiePort = reggiePortString != null ? Integer.parseInt(reggiePortString) : 1099;
        String instance = System.getenv("KVINSTANCE");
        if (instance == null || instance.length() == 0) {
            instance = "default";
        }
        this.stackTraceLimit = System.getenv("stackTraceLimit") != null ? Integer.parseInt(System.getenv("stackTraceLimit")) : 0;
        Object object = initKVStoreLock;
        synchronized (object) {
            if (kvStore == null) {
                int threadCount = Integer.parseInt(this.getProperties().getProperty("threadcount", "1"));
                KVStoreConfig kvConfig = new KVStoreConfig(instance, topoHost + ':' + reggiePort);
                RequestLimitConfig requestLimitConfig = new RequestLimitConfig(Integer.MAX_VALUE, 99, 99);
                kvConfig.setRequestLimit(requestLimitConfig);
                kvStore = KVStoreFactory.getStore(kvConfig);
                statsTimer = new Timer(true);
                statsTask = new StatsTask();
                int statsIntervalMs = Integer.parseInt(this.getProperties().getProperty("statsIntervalMs", "10000"));
                statsTimer.schedule((TimerTask)statsTask, statsIntervalMs, (long)statsIntervalMs);
            }
        }
    }

    public void cleanup() throws DBException {
        super.cleanup();
        if (activeClients.decrementAndGet() != 0) {
            return;
        }
        if (this.keyCount > 0) {
            System.err.print("Average key size: " + this.totalKeyBytes / (long)this.keyCount);
        }
        if (this.valueCount > 0) {
            System.err.print(" Average value size: " + this.totalValueBytes / (long)this.valueCount);
        }
        KVStats stats = kvStore.getStats(false);
        System.err.println("\nKV client stats:\n" + stats.toString());
        System.err.println();
        statsTimer.cancel();
        kvStore.close();
    }

    private int putInternal(String table, String key, HashMap<String, String> values, ValueVersion version) {
        assert ("usertable".equals(table));
        Key kvKey = this.createKVKey(key);
        Value kvValue = this.createKVValue(values);
        try {
            if (version == null) {
                kvStore.put(kvKey, kvValue);
            } else {
                Version ret = kvStore.putIfVersion(kvKey, kvValue, version.getVersion());
                if (ret == null) {
                    return 1;
                }
            }
            return 0;
        }
        catch (FaultException e) {
            System.err.println("Exception during put:" + e.getMessage());
            if (stackTraceCount++ < this.stackTraceLimit) {
                e.printStackTrace(System.err);
            }
            return 1;
        }
    }

    private void setResult(Value kvValue, Set<String> fields, HashMap<String, String> result) {
        ByteBuffer valueBytes = ByteBuffer.wrap(kvValue.getValue());
        int size = valueBytes.getShort();
        for (int i = 0; i < size; ++i) {
            String name = this.getString(valueBytes);
            String value = this.getString(valueBytes);
            if (fields != null && !fields.contains(name)) continue;
            result.put(name, value);
        }
    }

    private Key createKVKey(String key) {
        ++this.keyCount;
        this.totalKeyBytes += (long)key.length();
        return Key.createKey(key);
    }

    private Value createKVValue(HashMap<String, String> values) {
        this.outputBuffer.clear();
        this.outputBuffer.putShort((short)values.size());
        for (Map.Entry<String, String> e : values.entrySet()) {
            this.putString(this.outputBuffer, e.getKey());
            this.putString(this.outputBuffer, e.getValue());
        }
        byte[] valueBytes = new byte[this.outputBuffer.position()];
        System.arraycopy(this.outputBuffer.array(), 0, valueBytes, 0, this.outputBuffer.position());
        ++this.valueCount;
        this.totalValueBytes += (long)valueBytes.length;
        Value kvValue = Value.createValue(valueBytes);
        return kvValue;
    }

    private void putString(ByteBuffer tbb, String s) {
        tbb.putShort((short)s.length());
        s.getBytes(0, s.length(), tbb.array(), tbb.position());
        tbb.position(tbb.position() + s.length());
    }

    private String getString(ByteBuffer tbb) {
        short slength = tbb.getShort();
        String s = new String(tbb.array(), 0, tbb.position(), (int)slength);
        tbb.position(tbb.position() + slength);
        return s;
    }

    static {
        activeClients = new AtomicInteger();
        stackTraceCount = 0;
    }

    public static class StatsTask
    extends TimerTask {
        @Override
        public void run() {
            KVStats stats = kvStore.getStats(true);
            if (versionMismatches > 0) {
                System.err.println("Version Mismatch retries: " + versionMismatches + " retry limit exceeded:" + versionRetryLimitExceeded + " Total Puts: " + totalUpdates + " (" + versionMismatches * 100 / totalUpdates + "%)");
            }
            int maxActive = 0;
            for (NodeMetrics s : stats.getNodeMetrics()) {
                maxActive = Math.max(maxActive, s.getMaxActiveRequestCount());
            }
            System.err.printf("%1tT %s\n", System.currentTimeMillis(), stats.toString());
            System.err.println("Max active requests:" + maxActive);
        }
    }
}

