/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import oracle.kv.impl.admin.CommandService;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.RequestHandler;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.monitor.MonitorAgent;
import oracle.kv.impl.monitor.MonitorAgentAPI;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeAgentInterface;
import oracle.kv.impl.test.RemoteTestAPI;
import oracle.kv.impl.test.RemoteTestInterface;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RegistryUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Topology topology;
    private static final String BINDING_NAME_SEPARATOR = ":";

    public RegistryUtils(Topology topology) {
        this.topology = topology;
    }

    private RegistryUtils() {
    }

    public RequestHandlerAPI getRequestHandler(RepNodeId repNodeId) throws RemoteException, NotBoundException {
        RepNode repNode = this.topology.get(repNodeId);
        return RequestHandlerAPI.wrap((RequestHandler)this.lookup(repNodeId.getFullName(), InterfaceType.MAIN, repNode.getStorageNodeId()));
    }

    public RepNodeAdminAPI getRepNodeAdmin(RepNodeId repNodeId) throws RemoteException, NotBoundException {
        RepNode repNode = this.topology.get(repNodeId);
        return RepNodeAdminAPI.wrap((RepNodeAdmin)this.lookup(repNodeId.getFullName(), InterfaceType.ADMIN, repNode.getStorageNodeId()));
    }

    public static boolean isRepNodeAdmin(String serviceName) {
        if (serviceName.toLowerCase().indexOf("rg") > 0) {
            return serviceName.endsWith(InterfaceType.ADMIN.toString());
        }
        return false;
    }

    public RemoteTestAPI getRepNodeTest(RepNodeId repNodeId) throws RemoteException, NotBoundException {
        RepNode repNode = this.topology.get(repNodeId);
        return RemoteTestAPI.wrap((RemoteTestInterface)((RemoteTestInterface)this.lookup(repNodeId.getFullName(), InterfaceType.TEST, repNode.getStorageNodeId())));
    }

    public static MonitorAgentAPI getMonitor(String storeName, String snHostname, int snRegistryPort, ResourceId resourceId) throws RemoteException, NotBoundException {
        return MonitorAgentAPI.wrap((MonitorAgent)((MonitorAgent)RegistryUtils.getInterface(storeName, snHostname, snRegistryPort, resourceId.getFullName(), InterfaceType.MONITOR)));
    }

    public static CommandServiceAPI getAdmin(String hostname, int registryPort) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(hostname, registryPort);
        return CommandServiceAPI.wrap((CommandService)((CommandService)registry.lookup("commandService")));
    }

    public static RepNodeAdminAPI getRepNodeAdmin(String storeName, String snHostname, int snRegistryPort, RepNodeId rnId) throws RemoteException, NotBoundException {
        return RepNodeAdminAPI.wrap((RepNodeAdmin)RegistryUtils.getInterface(storeName, snHostname, snRegistryPort, rnId.getFullName(), InterfaceType.ADMIN));
    }

    private static Remote getInterface(String storeName, String snHostname, int snRegistryPort, String rnName, InterfaceType interfaceType) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(snHostname, snRegistryPort);
        return registry.lookup(RegistryUtils.bindingName(storeName, rnName, interfaceType));
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(String hostname, int registryPort, String serviceName) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(hostname, registryPort);
        return StorageNodeAgentAPI.wrap((StorageNodeAgentInterface)((StorageNodeAgentInterface)registry.lookup(serviceName)));
    }

    public StorageNodeAgentAPI getStorageNodeAgent(StorageNodeId storageNodeId) throws RemoteException, NotBoundException {
        return StorageNodeAgentAPI.wrap((StorageNodeAgentInterface)((StorageNodeAgentInterface)this.lookup(storageNodeId.getFullName(), InterfaceType.MAIN, storageNodeId)));
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(String storeName, String snHostname, int snRegistryPort, StorageNodeId snId) throws RemoteException, NotBoundException {
        return StorageNodeAgentAPI.wrap((StorageNodeAgentInterface)((StorageNodeAgentInterface)RegistryUtils.getInterface(storeName, snHostname, snRegistryPort, snId.getFullName(), InterfaceType.MAIN)));
    }

    public static StorageNodeAgentAPI getStorageNodeAgent(Parameters parameters, StorageNodeId snId) throws RemoteException, NotBoundException {
        StorageNodeParams snp = parameters.get(snId);
        String hostname = snp.getHostname();
        int port = snp.getRegistryPort();
        String storename = parameters.getGlobalParams().getKVStoreName();
        return RegistryUtils.getStorageNodeAgent(storename, hostname, port, snId);
    }

    public void rebind(RepNodeId repNodeId, RequestHandler requestHandler) throws RemoteException {
        RepNode repNode = this.topology.get(repNodeId);
        this.rebind(repNodeId.getFullName(), InterfaceType.MAIN, repNode.getStorageNodeId(), requestHandler);
    }

    public void rebind(RepNodeId repNodeId, MonitorAgent monitorAgent) throws RemoteException {
        RepNode repNode = this.topology.get(repNodeId);
        this.rebind(repNodeId.getFullName(), InterfaceType.MONITOR, repNode.getStorageNodeId(), (Remote)monitorAgent);
    }

    public void rebind(RepNodeId repNodeId, RepNodeAdmin repNodeAdmin) throws RemoteException {
        RepNode repNode = this.topology.get(repNodeId);
        this.rebind(repNodeId.getFullName(), InterfaceType.ADMIN, repNode.getStorageNodeId(), repNodeAdmin);
    }

    private void rebind(String baseName, InterfaceType interfaceType, StorageNodeId storageNodeId, Remote object) throws RemoteException {
        Registry registry = this.getRegistry(storageNodeId);
        Remote stub = UnicastRemoteObject.exportObject(object, 0);
        try {
            registry.rebind(this.bindingName(baseName, interfaceType), stub);
        }
        catch (RemoteException re) {
            UnicastRemoteObject.unexportObject(object, true);
            throw re;
        }
    }

    public static void rebind(String hostname, int registryPort, String storeName, String baseName, InterfaceType interfaceType, Remote object) throws RemoteException {
        RegistryUtils.rebind(hostname, registryPort, RegistryUtils.bindingName(storeName, baseName, interfaceType), object);
    }

    public static void rebind(String hostname, int registryPort, String serviceName, Remote object) throws RemoteException {
        Registry registry = LocateRegistry.getRegistry(hostname, registryPort);
        Remote stub = UnicastRemoteObject.exportObject(object, 0);
        try {
            registry.rebind(serviceName, stub);
        }
        catch (RemoteException re) {
            UnicastRemoteObject.unexportObject(object, true);
            throw re;
        }
    }

    public static boolean unbind(String hostname, int registryPort, String storeName, String baseName, InterfaceType interfaceType, Remote object) throws RemoteException {
        return RegistryUtils.unbind(hostname, registryPort, RegistryUtils.bindingName(storeName, baseName, interfaceType), object);
    }

    public static boolean unbind(String hostname, int registryPort, String serviceName, Remote object) throws RemoteException {
        Registry registry = LocateRegistry.getRegistry(hostname, registryPort);
        try {
            registry.unbind(serviceName);
            UnicastRemoteObject.unexportObject(object, true);
            return true;
        }
        catch (NotBoundException e) {
            return false;
        }
    }

    public static String bindingName(String storeName, String baseName, InterfaceType interfaceType) {
        return storeName + BINDING_NAME_SEPARATOR + baseName + BINDING_NAME_SEPARATOR + (Object)((Object)interfaceType);
    }

    private String bindingName(String baseName, InterfaceType interfaceType) {
        return RegistryUtils.bindingName(this.topology.getKVStoreName(), baseName, interfaceType);
    }

    private Registry getRegistry(StorageNodeId storageNodeId) throws RemoteException {
        StorageNode storageNode = this.topology.get(storageNodeId);
        return LocateRegistry.getRegistry(storageNode.getHostname(), storageNode.getRegistryPort());
    }

    private Remote lookup(String baseName, InterfaceType interfaceType, StorageNodeId storageNodeId) throws RemoteException, NotBoundException {
        Registry registry = this.getRegistry(storageNodeId);
        return registry.lookup(this.bindingName(baseName, interfaceType));
    }

    public static enum InterfaceType {
        MAIN,
        MONITOR,
        ADMIN,
        TEST;


        public String interfaceName() {
            return this.name().toLowerCase();
        }
    }
}

