/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import oracle.kv.FaultException;
import oracle.kv.KVStoreException;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

public class TopologyLocator {
    public static final String HOST_PORT_SEPARATOR = ":";

    public static Topology get(String[] registryHostPorts, int maxRNs) throws KVStoreException {
        Topology initialTopology = TopologyLocator.getInitialTopology(registryHostPorts);
        int maxTopoSeqNum = 0;
        RepNodeAdminAPI currentAdmin = null;
        Exception exception = null;
        RegistryUtils registryUtils = new RegistryUtils(initialTopology);
        block5: for (RepGroup rg : initialTopology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                try {
                    RepNodeAdminAPI admin = registryUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                    int seqNum = admin.getTopoSeqNum();
                    if (seqNum > maxTopoSeqNum) {
                        maxTopoSeqNum = seqNum;
                        currentAdmin = admin;
                    }
                    if (--maxRNs >= 0) continue;
                    break block5;
                }
                catch (RemoteException e) {
                    exception = e;
                }
                catch (NotBoundException e) {
                    exception = e;
                }
            }
        }
        if (currentAdmin != null) {
            try {
                return currentAdmin.getTopology();
            }
            catch (RemoteException e) {
                exception = e;
            }
        }
        throw new KVStoreException("Could not establish an initial Topology from: " + Arrays.toString(registryHostPorts), exception);
    }

    private static Topology getInitialTopology(String[] registryHostPorts) throws KVStoreException {
        Exception cause = null;
        int maxTopoSeqNum = 0;
        RepNodeAdminAPI currentAdmin = null;
        for (String hostPort : registryHostPorts) {
            int registryPort;
            if (hostPort == null || hostPort.length() == 0) {
                throw new IllegalArgumentException("Null or empty host and port pair: " + Arrays.toString(registryHostPorts));
            }
            int portStartIndex = hostPort.indexOf(HOST_PORT_SEPARATOR);
            if (portStartIndex <= 0 || portStartIndex == hostPort.length() - 1) {
                throw new IllegalArgumentException("Missing or illegal port separator char: " + hostPort);
            }
            String registryHostname = hostPort.substring(0, portStartIndex);
            try {
                registryPort = Integer.parseInt(hostPort.substring(portStartIndex + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal number format for port: " + hostPort + " " + e);
            }
            try {
                Registry snRegistry = LocateRegistry.getRegistry(registryHostname, registryPort);
                for (String serviceName : snRegistry.list()) {
                    try {
                        RepNodeAdminAPI admin;
                        int seqNum;
                        Remote stub;
                        if (!RegistryUtils.isRepNodeAdmin(serviceName) || !((stub = snRegistry.lookup(serviceName)) instanceof RepNodeAdmin) || (seqNum = (admin = RepNodeAdminAPI.wrap((RepNodeAdmin)stub)).getTopoSeqNum()) <= maxTopoSeqNum) continue;
                        maxTopoSeqNum = seqNum;
                        currentAdmin = admin;
                    }
                    catch (AccessException e) {
                        cause = e;
                    }
                    catch (NotBoundException e) {
                        cause = e;
                    }
                    catch (InternalFaultException e) {
                        if (cause != null) continue;
                        cause = e;
                    }
                }
            }
            catch (RemoteException e) {
                cause = e;
            }
        }
        if (currentAdmin == null) {
            throw new KVStoreException("Could not contact any RepNode at: " + Arrays.toString(registryHostPorts), cause);
        }
        try {
            return currentAdmin.getTopology();
        }
        catch (RemoteException e) {
            throw new KVStoreException("Could not establish an initial Topology from: " + Arrays.toString(registryHostPorts), cause);
        }
        catch (InternalFaultException e) {
            throw new FaultException(e, false);
        }
    }
}

