/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.change;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;

@Persistent
public class Update
extends TopologyChange {
    private static final long serialVersionUID = 1L;
    Topology.Component<?> component;

    public Update(int sequenceNumber, Topology.Component<?> component) {
        super(sequenceNumber);
        assert (component.getResourceId() != null);
        this.component = component;
    }

    private Update() {
    }

    @Override
    public TopologyChange.Type getType() {
        return TopologyChange.Type.UPDATE;
    }

    @Override
    public Topology.Component<?> getComponent() {
        return this.component;
    }

    @Override
    public ResourceId getResourceId() {
        return this.component.getResourceId();
    }

    @Override
    public Update clone() {
        Object comp = this.component.clone();
        assert (((ResourceId)((Topology.Component)comp).getResourceId()).getType() != ResourceId.ResourceType.REP_GROUP);
        ((Topology.Component)comp).setTopology(null);
        return new Update(this.sequenceNumber, (Topology.Component<?>)comp);
    }

    public String toString() {
        return "Update " + this.component.getResourceId() + " seq=" + this.sequenceNumber;
    }
}

