/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Persistent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.kv.impl.topo.ComponentMap;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterMap;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.PartitionMap;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepGroupMap;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.StorageNodeMap;
import oracle.kv.impl.topo.TopologyHolder;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.topo.change.TopologyChangeTracker;

@Persistent
public class Topology
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String kvStoreName;
    private PartitionMap partitionMap;
    private RepGroupMap repGroupMap;
    private StorageNodeMap storageNodeMap;
    private DatacenterMap datacenterMap;
    private Map<ResourceId.ResourceType, ComponentMap<? extends ResourceId, ? extends Component<?>>> typeToComponentMaps;
    private TopologyChangeTracker changeTracker;
    public static int EMPTY_SEQUENCE_NUMBER = 0;

    public Topology(String kvStoreName) {
        this.kvStoreName = kvStoreName;
        this.partitionMap = new PartitionMap(this);
        this.repGroupMap = new RepGroupMap(this);
        this.storageNodeMap = new StorageNodeMap(this);
        this.datacenterMap = new DatacenterMap(this);
        this.changeTracker = new TopologyChangeTracker(this);
        this.typeToComponentMaps = new HashMap();
        for (ComponentMap<?, ?> m : this.getAllComponentMaps()) {
            this.typeToComponentMaps.put(m.getResourceType(), m);
        }
    }

    private Topology() {
    }

    ComponentMap<?, ?>[] getAllComponentMaps() {
        return new ComponentMap[]{this.partitionMap, this.repGroupMap, this.storageNodeMap, this.datacenterMap};
    }

    public String getKVStoreName() {
        return this.kvStoreName;
    }

    public Component<?> get(ResourceId resourceId) {
        return resourceId.getComponent(this);
    }

    public Datacenter get(DatacenterId datacenterId) {
        return (Datacenter)this.datacenterMap.get(datacenterId);
    }

    public StorageNode get(StorageNodeId storageNodeId) {
        return (StorageNode)this.storageNodeMap.get(storageNodeId);
    }

    public RepGroup get(RepGroupId repGroupId) {
        return (RepGroup)this.repGroupMap.get(repGroupId);
    }

    public Partition get(PartitionId partitionMapId) {
        return (Partition)this.partitionMap.get(partitionMapId);
    }

    public RepNode get(RepNodeId repNodeId) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(repNodeId.getGroupId()));
        return rg == null ? null : rg.get(repNodeId);
    }

    public Datacenter getDatacenter(StorageNodeId storageNodeId) {
        return this.get(this.get(storageNodeId).getDatacenterId());
    }

    public Datacenter getDatacenter(RepNodeId repNodeId) {
        return this.getDatacenter(this.get(repNodeId).getStorageNodeId());
    }

    public PartitionId getPartitionId(byte[] keyBytes) {
        return this.partitionMap.getPartitionId(keyBytes);
    }

    public RepGroupId getRepGroupId(PartitionId partitionId) {
        return this.partitionMap.getRepGroupId(partitionId);
    }

    public PartitionMap getPartitionMap() {
        return this.partitionMap;
    }

    public RepGroupMap getRepGroupMap() {
        return this.repGroupMap;
    }

    public StorageNodeMap getStorageNodeMap() {
        return this.storageNodeMap;
    }

    public List<RepNode> getSortedRepNodes() {
        ArrayList<RepNode> srn = new ArrayList<RepNode>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                srn.add(rn);
            }
        }
        Collections.sort(srn, new Comparator<RepNode>(){

            @Override
            public int compare(RepNode o1, RepNode o2) {
                RepNodeId id1 = (RepNodeId)o1.getResourceId();
                RepNodeId id2 = (RepNodeId)o2.getResourceId();
                int grp = id1.getGroupId() - id2.getGroupId();
                if (grp != 0) {
                    return grp;
                }
                return id1.getNodeNum() - id2.getNodeNum();
            }
        });
        return srn;
    }

    public List<StorageNode> getSortedStorageNodes() {
        ArrayList<StorageNode> sns = new ArrayList<StorageNode>(this.storageNodeMap.getAll());
        Collections.sort(sns, new Comparator<StorageNode>(){

            @Override
            public int compare(StorageNode o1, StorageNode o2) {
                return o1.getStorageNodeId().getStorageNodeId() - o2.getStorageNodeId().getStorageNodeId();
            }
        });
        return sns;
    }

    public Set<RepNodeId> getRepNodeIds() {
        HashSet<RepNodeId> allRNIds = new HashSet<RepNodeId>();
        for (RepGroup rg : this.repGroupMap.getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                allRNIds.add((RepNodeId)rn.getResourceId());
            }
        }
        return allRNIds;
    }

    public DatacenterMap getDatacenterMap() {
        return this.datacenterMap;
    }

    public List<Datacenter> getSortedDatacenters() {
        ArrayList<Datacenter> sdc = new ArrayList<Datacenter>(this.datacenterMap.getAll());
        Collections.sort(sdc, new Comparator<Datacenter>(){

            @Override
            public int compare(Datacenter o1, Datacenter o2) {
                DatacenterId id1 = (DatacenterId)o1.getResourceId();
                DatacenterId id2 = (DatacenterId)o2.getResourceId();
                return id1.getDatacenterId() - id2.getDatacenterId();
            }
        });
        return sdc;
    }

    public TopologyChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    public int getSequenceNumber() {
        return this.changeTracker.getSeqNum();
    }

    public Topology getCopy() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Topology)ois.readObject();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected exception", ioe);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    public boolean apply(List<TopologyChange> changes) {
        if (changes == null) {
            return false;
        }
        if (changes.size() == 0) {
            return false;
        }
        if (changes.get(0).getSequenceNumber() > this.getSequenceNumber() + 1) {
            throw new IllegalStateException("Unexpected gap in topology sequence. Current sequence=" + this.getSequenceNumber() + ", first change =" + changes.get(0).getSequenceNumber());
        }
        int changeCount = 0;
        for (TopologyChange change : changes) {
            if (change.getSequenceNumber() <= this.getSequenceNumber()) continue;
            ++changeCount;
            ResourceId.ResourceType rtype = change.getResourceId().getType();
            if (rtype == ResourceId.ResourceType.REP_NODE) {
                RepNodeId rnId = (RepNodeId)change.getResourceId();
                RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(rnId.getGroupId()));
                rg.apply(change);
                continue;
            }
            this.typeToComponentMaps.get((Object)rtype).apply(change);
        }
        return changeCount > 0;
    }

    public List<TopologyChange> getChanges(int startSeqNum) {
        return this.changeTracker.getChanges(startSeqNum);
    }

    public void discardChanges(int startSeqNum) {
        this.changeTracker.discardChanges(startSeqNum);
    }

    public void persist(EntityStore estore, Transaction txn) {
        PrimaryIndex<String, TopologyHolder> ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        ti.put(txn, (Object)new TopologyHolder(this));
    }

    public static Topology fetch(EntityStore estore, Transaction txn) {
        PrimaryIndex<String, TopologyHolder> ti = estore.getPrimaryIndex(String.class, TopologyHolder.class);
        TopologyHolder holder = (TopologyHolder)ti.get(txn, (Object)TopologyHolder.getKey(), LockMode.READ_UNCOMMITTED);
        return holder == null ? null : holder.getTopology();
    }

    public Datacenter add(Datacenter datacenter) {
        return this.datacenterMap.add(datacenter);
    }

    public StorageNode add(StorageNode storageNode) {
        return this.storageNodeMap.add(storageNode);
    }

    public RepGroup add(RepGroup repGroup) {
        return this.repGroupMap.add(repGroup);
    }

    public Partition add(Partition partition) {
        return this.partitionMap.add(partition);
    }

    public Datacenter update(DatacenterId datacenterId, Datacenter datacenter) {
        return this.datacenterMap.update(datacenterId, datacenter);
    }

    public StorageNode update(StorageNodeId storageNodeId, StorageNode storageNode) {
        return this.storageNodeMap.update(storageNodeId, storageNode);
    }

    public RepGroup update(RepGroupId repGroupId, RepGroup repGroup) {
        return this.repGroupMap.update(repGroupId, repGroup);
    }

    public Partition update(PartitionId partitionId, Partition partition) {
        return this.partitionMap.update(partitionId, partition);
    }

    public Datacenter remove(DatacenterId datacenterId) {
        return (Datacenter)this.datacenterMap.remove(datacenterId);
    }

    public StorageNode remove(StorageNodeId storageNodeId) {
        return (StorageNode)this.storageNodeMap.remove(storageNodeId);
    }

    public RepGroup remove(RepGroupId repGroupId) {
        return (RepGroup)this.repGroupMap.remove(repGroupId);
    }

    public Partition remove(PartitionId partitionId) {
        return (Partition)this.partitionMap.remove(partitionId);
    }

    public RepNode remove(RepNodeId repNodeId) {
        RepGroup rg = (RepGroup)this.repGroupMap.get(new RepGroupId(repNodeId.getGroupId()));
        if (rg == null) {
            throw new IllegalArgumentException("Rep Group: " + repNodeId.getGroupId() + " is not in the topology");
        }
        return rg.remove(repNodeId);
    }

    public void removePartitionsAndRepGroups() {
        this.partitionMap.reset();
        this.repGroupMap.reset();
    }

    @Persistent
    public static abstract class Component<T extends ResourceId>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private Topology topology;
        private ResourceId resourceId;
        private int sequenceNumber;

        public Component() {
        }

        public abstract Component<?> clone();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
            result = 31 * result + this.sequenceNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Component other = (Component)obj;
            if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
                return false;
            }
            return this.sequenceNumber == other.sequenceNumber;
        }

        public Component<?> cloneForLog() {
            Object clone = this.clone();
            ((Component)clone).topology = null;
            return clone;
        }

        protected Component(Component<?> other) {
            this.topology = other.topology;
            this.resourceId = other.resourceId;
            this.sequenceNumber = other.sequenceNumber;
        }

        public Topology getTopology() {
            return this.topology;
        }

        public void setTopology(Topology topology) {
            assert (this.topology == null || topology == null);
            this.topology = topology;
        }

        public void setResourceId(T resourceId) {
            assert (this.resourceId == null);
            this.resourceId = resourceId;
        }

        public T getResourceId() {
            return (T)this.resourceId;
        }

        abstract ResourceId.ResourceType getResourceType();

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public StorageNodeId getStorageNodeId() {
            throw new UnsupportedOperationException("Not supported for component " + this.resourceId);
        }

        public boolean isMonitorEnabled() {
            return false;
        }
    }
}

