/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Iterator;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.FastExternalizable;

@Persistent
public abstract class ResourceId
implements Serializable,
FastExternalizable {
    private static final long serialVersionUID = 1L;
    private static final ResourceType[] TYPES_BY_ORDINAL;

    private static ResourceType getResourceType(int ordinal) {
        if (ordinal < 0 || ordinal >= TYPES_BY_ORDINAL.length) {
            throw new IllegalArgumentException("unknown resource type: " + ordinal);
        }
        return TYPES_BY_ORDINAL[ordinal];
    }

    protected ResourceId() {
    }

    public ResourceId(ObjectInput in, short serialVersion) {
    }

    public static ResourceId readFastExternal(ObjectInput in, short serialVersion) throws IOException {
        ResourceType type = ResourceId.getResourceType(in.readUnsignedByte());
        return type.readResourceId(in, serialVersion);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeByte(this.getType().ordinal());
    }

    public abstract ResourceType getType();

    public abstract Topology.Component<?> getComponent(Topology var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String getFullName() {
        throw new UnsupportedOperationException("Not supported for " + (Object)((Object)this.getType()));
    }

    static {
        EnumSet<ResourceType> set = EnumSet.allOf(ResourceType.class);
        TYPES_BY_ORDINAL = new ResourceType[set.size()];
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            ResourceType op;
            ResourceId.TYPES_BY_ORDINAL[op.ordinal()] = op = (ResourceType)((Object)i$.next());
        }
    }

    public static enum ResourceType {
        DATACENTER{

            @Override
            ResourceId readResourceId(ObjectInput in, short serialVersion) throws IOException {
                return new DatacenterId(in, serialVersion);
            }

            @Override
            public boolean isDatacenter() {
                return true;
            }
        }
        ,
        STORAGE_NODE{

            @Override
            ResourceId readResourceId(ObjectInput in, short serialVersion) throws IOException {
                return new StorageNodeId(in, serialVersion);
            }

            @Override
            public boolean isStorageNode() {
                return true;
            }
        }
        ,
        REP_GROUP{

            @Override
            ResourceId readResourceId(ObjectInput in, short serialVersion) throws IOException {
                return new RepGroupId(in, serialVersion);
            }

            @Override
            public boolean isRepGroup() {
                return true;
            }
        }
        ,
        REP_NODE{

            @Override
            ResourceId readResourceId(ObjectInput in, short serialVersion) throws IOException {
                return new RepNodeId(in, serialVersion);
            }

            @Override
            public boolean isRepNode() {
                return true;
            }
        }
        ,
        PARTITION{

            @Override
            ResourceId readResourceId(ObjectInput in, short serialVersion) throws IOException {
                return new PartitionId(in, serialVersion);
            }

            @Override
            public boolean isPartition() {
                return true;
            }
        }
        ,
        ADMIN{

            @Override
            ResourceId readResourceId(ObjectInput in, short serialVersion) throws IOException {
                return new AdminId(in, serialVersion);
            }

            @Override
            public boolean isAdmin() {
                return true;
            }
        }
        ,
        CLIENT{

            @Override
            ResourceId readResourceId(ObjectInput in, short serialVersion) throws IOException {
                return new ClientId(in, serialVersion);
            }

            @Override
            public boolean isClient() {
                return true;
            }
        };


        abstract ResourceId readResourceId(ObjectInput var1, short var2) throws IOException;

        public boolean isDatacenter() {
            return false;
        }

        public boolean isStorageNode() {
            return false;
        }

        public boolean isRepGroup() {
            return false;
        }

        public boolean isRepNode() {
            return false;
        }

        public boolean isPartition() {
            return false;
        }

        public boolean isAdmin() {
            return false;
        }

        public boolean isClient() {
            return false;
        }
    }
}

