/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class RepNodeId
extends ResourceId {
    private static final long serialVersionUID = 1L;
    private static final String NODE_NAME_PREFIX = "rn";
    private int groupId;
    private int nodeNum;

    public RepNodeId(int groupId, int nodeNum) {
        this.groupId = groupId;
        this.nodeNum = nodeNum;
    }

    private RepNodeId() {
    }

    public RepNodeId(ObjectInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.groupId = in.readInt();
        this.nodeNum = in.readInt();
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.groupId);
        out.writeInt(this.nodeNum);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.REP_NODE;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    @Override
    public String getFullName() {
        return new RepGroupId(this.getGroupId()).getGroupName() + "-" + NODE_NAME_PREFIX + this.getNodeNum();
    }

    public static RepNodeId parse(String fullName) {
        int sepIndex = fullName.indexOf(45);
        RepGroupId rgId = RepGroupId.parse(fullName.substring(0, sepIndex));
        int nodeNum = Integer.parseInt(fullName.substring(sepIndex + 1 + NODE_NAME_PREFIX.length()));
        return new RepNodeId(rgId.getGroupId(), nodeNum);
    }

    public String getGroupName() {
        return new RepGroupId(this.getGroupId()).getGroupName();
    }

    public String toString() {
        return this.getFullName();
    }

    public RepNode getComponent(Topology topology) {
        return topology.get(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepNodeId other = (RepNodeId)obj;
        if (this.groupId != other.groupId) {
            return false;
        }
        return this.nodeNum == other.nodeNum;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId;
        result = 31 * result + this.nodeNum;
        return result;
    }
}

