/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class DatacenterId
extends ResourceId {
    private static final long serialVersionUID = 1L;
    private static final String DATA_CENTER_PREFIX = "dc";
    private int datacenterId;

    public DatacenterId(int datacenterId) {
        this.datacenterId = datacenterId;
    }

    private DatacenterId() {
    }

    public DatacenterId(ObjectInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.datacenterId = in.readInt();
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.datacenterId);
    }

    @Override
    public ResourceId.ResourceType getType() {
        return ResourceId.ResourceType.DATACENTER;
    }

    public int getDatacenterId() {
        return this.datacenterId;
    }

    public String toString() {
        return DATA_CENTER_PREFIX + this.datacenterId;
    }

    public Datacenter getComponent(Topology topology) {
        return topology.get(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatacenterId other = (DatacenterId)obj;
        return this.datacenterId == other.datacenterId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.datacenterId;
        return result;
    }
}

