/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.fault;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.kv.KVVersion;

public abstract class InternalFaultException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String faultClassName;
    private final String originalStackTrace;

    public InternalFaultException(Throwable cause) {
        super("Oracle NoSQL DB " + KVVersion.CURRENT_VERSION + " " + cause.getClass().getName() + ": " + cause.getMessage());
        StringWriter sw = new StringWriter(500);
        cause.printStackTrace(new PrintWriter(sw));
        this.originalStackTrace = sw.toString();
        this.faultClassName = cause.getClass().getName();
    }

    public String getFaultClassName() {
        return this.faultClassName;
    }

    @Override
    public String toString() {
        return this.getMessage() + " " + this.originalStackTrace;
    }
}

