/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepGroupStateTable;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RepNodeStateUpdateThread
extends Thread {
    private final RequestDispatcher requestDispatcher;
    private final ThreadPoolExecutor threadPool;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private static final int MIN_POOL_SIZE = 6;
    private final int periodMs;
    private final int resolutionTimeoutMs = 10000;
    private final int nopTimeoutMs = 1000;
    private volatile int poolRejectCount;
    private volatile int resolveCount;
    public int resolveFailCount;
    public int resolveExceptionCount;
    private volatile int refreshCount;
    private volatile int refreshExceptionCount;
    private static boolean updateState = true;
    private final Logger logger;

    public RepNodeStateUpdateThread(RequestDispatcher requestDispatcher, int periodMs, Thread.UncaughtExceptionHandler handler, Logger logger) {
        this.requestDispatcher = requestDispatcher;
        this.periodMs = periodMs;
        this.logger = logger;
        ResourceId resourceId = requestDispatcher.getDispatcherId();
        int keepAliveTimeMs = periodMs * 5;
        this.threadPool = new ThreadPoolExecutor(0, 6, keepAliveTimeMs, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), new RepNodeUpdateThreadFactory(logger, resourceId), new CountDiscardsPolicy());
        this.setName("KV_" + resourceId + "_RepNodeStateUpdateThread");
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(handler);
    }

    public int getResolveCount() {
        return this.resolveCount;
    }

    public int getResolveFailCount() {
        return this.resolveFailCount;
    }

    public int getResolveExceptionCount() {
        return this.resolveExceptionCount;
    }

    public int getRefreshCount() {
        return this.refreshCount;
    }

    public int getRefreshExceptionCount() {
        return this.refreshExceptionCount;
    }

    public static void setUpdateState(boolean updateState) {
        RepNodeStateUpdateThread.updateState = updateState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.info("RepNodeStateUpdateThread started");
        try {
            this.runUpdateLoop();
        }
        catch (Throwable t) {
            this.requestDispatcher.shutdown(t);
        }
        finally {
            this.shutdown();
        }
    }

    private void runUpdateLoop() throws IllegalStateException {
        while (!this.shutdown.get()) {
            Topology topology = this.requestDispatcher.getTopologyManager().getTopology();
            Collection<RepNodeState> rns = this.getRNs();
            this.threadPool.setMaximumPoolSize(Math.max(6, rns.size() / 10));
            for (RepNodeState rnState : rns) {
                if (this.shutdown.get()) {
                    return;
                }
                if (rnState.reqHandlerNeedsResolution()) {
                    this.threadPool.execute(new ResolveHandler(rnState));
                    continue;
                }
                if (!updateState) continue;
                if (rnState.isObsoleteVLSNState()) {
                    this.threadPool.execute(new RefreshRepNodeState(rnState));
                }
                int rnTopoSeqNum = rnState.getTopoSeqNum();
                if (topology == null || rnTopoSeqNum < 0 || rnTopoSeqNum >= topology.getSequenceNumber()) continue;
                List<TopologyChange> changes = topology.getChanges(rnTopoSeqNum + 1);
                rnState.updateTopoSeqNum(topology.getSequenceNumber());
                this.threadPool.execute(new PushTopologyChanges(rnState, changes));
            }
            try {
                Thread.sleep(this.periodMs);
            }
            catch (InterruptedException e) {
                this.logger.warning("RepNodeStateThread interrupted");
                throw new IllegalStateException(e);
            }
        }
    }

    private Collection<RepNodeState> getRNs() {
        RepGroupStateTable rgst = this.requestDispatcher.getRepGroupStateTable();
        ResourceId dispatcherId = this.requestDispatcher.getDispatcherId();
        if (dispatcherId.getType() == ResourceId.ResourceType.CLIENT) {
            return rgst.getRepNodeStates();
        }
        if (dispatcherId.getType() == ResourceId.ResourceType.REP_NODE) {
            RepNodeId rnId = (RepNodeId)dispatcherId;
            RepGroupState rgs = rgst.getGroupState(new RepGroupId(rnId.getGroupId()));
            return rgs.getRepNodeStates();
        }
        throw new IllegalStateException("Unexpected dispatcher:" + dispatcherId);
    }

    public void shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.logger.info("RepNodeStateUpdateThread shutdown");
        this.threadPool.shutdownNow();
    }

    private class RepNodeUpdateThreadFactory
    extends KVThreadFactory {
        private final ResourceId resourceId;

        RepNodeUpdateThreadFactory(Logger logger, ResourceId resourceId) {
            super(logger);
            this.resourceId = resourceId;
        }

        @Override
        public String getName() {
            return this.resourceId + "_RepNodeStateUpdater";
        }
    }

    private class PushTopologyChanges
    implements Runnable {
        private final RepNodeState rnState;
        private final List<TopologyChange> changes;

        PushTopologyChanges(RepNodeState rns, List<TopologyChange> changes) {
            this.rnState = rns;
            this.changes = changes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int startSeqNum = this.changes.get(0).getSequenceNumber();
            int endSeqNum = this.changes.get(this.changes.size() - 1).getSequenceNumber();
            boolean success = false;
            try {
                RegistryUtils regUtils = RepNodeStateUpdateThread.this.requestDispatcher.getRegUtils();
                RepNodeAdminAPI rnAdmin = regUtils.getRepNodeAdmin(this.rnState.getRepNodeId());
                rnAdmin.updateTopology(this.changes);
                success = true;
                RepNodeStateUpdateThread.this.logger.log(Level.INFO, "Pushed topology changes [" + startSeqNum + " .. " + endSeqNum + "]" + " to node:" + this.rnState.getRepNodeId());
            }
            catch (Exception e) {
                RepNodeStateUpdateThread.this.logger.log(Level.INFO, "Exception in PushTopologyChanges Pushing changes [" + startSeqNum + " .. " + endSeqNum + "]" + " to node:" + this.rnState.getRepNodeId() + " Message:" + e.getMessage());
            }
            finally {
                if (!success) {
                    this.rnState.resetTopoSeqNum(startSeqNum - 1);
                }
            }
        }
    }

    private class RefreshRepNodeState
    implements Runnable {
        final RepNodeState rns;

        RefreshRepNodeState(RepNodeState rns) {
            this.rns = rns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception exception = null;
            Level level = Level.SEVERE;
            try {
                RepNodeStateUpdateThread.this.requestDispatcher.executeNOP(this.rns, 1000);
                RepNodeStateUpdateThread.this.refreshCount++;
            }
            catch (ConnectException e) {
                exception = e;
                level = Level.FINE;
            }
            catch (RemoteException e) {
                exception = e;
                level = Level.INFO;
            }
            catch (Exception e) {
                exception = e;
                level = Level.WARNING;
            }
            finally {
                if (exception != null) {
                    RepNodeStateUpdateThread.this.refreshExceptionCount++;
                    String msg = "Exception in RefreshRepNodeStateThread when contacting:" + this.rns.getRepNodeId() + " Exception " + exception.getClass().getName();
                    if (level.intValue() >= Level.WARNING.intValue()) {
                        RepNodeStateUpdateThread.this.logger.log(Level.WARNING, msg, exception);
                    } else {
                        RepNodeStateUpdateThread.this.logger.log(level, msg + " Message:" + exception.getMessage());
                    }
                }
            }
        }
    }

    private class ResolveHandler
    implements Runnable {
        final RepNodeState rns;

        ResolveHandler(RepNodeState rns) {
            this.rns = rns;
        }

        @Override
        public void run() {
            try {
                RequestHandlerAPI ref = this.rns.resolveReqHandlerRef(RepNodeStateUpdateThread.this.requestDispatcher.getRegUtils(), 10000L);
                if (ref == null) {
                    ++RepNodeStateUpdateThread.this.resolveFailCount;
                } else {
                    RepNodeStateUpdateThread.this.resolveCount++;
                }
            }
            catch (Exception e) {
                RepNodeStateUpdateThread.this.logger.log(Level.WARNING, "Exception in ResolveHandlerThread when contacting:" + this.rns.getRepNodeId(), e);
                ++RepNodeStateUpdateThread.this.resolveExceptionCount;
            }
        }
    }

    class CountDiscardsPolicy
    extends ThreadPoolExecutor.DiscardPolicy {
        CountDiscardsPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            RepNodeStateUpdateThread.this.logger.log(Level.INFO, "RN Thread pool rejected execution. Pool size:" + RepNodeStateUpdateThread.this.threadPool.getPoolSize() + " Max pool size:" + RepNodeStateUpdateThread.this.threadPool.getMaximumPoolSize());
            RepNodeStateUpdateThread.this.poolRejectCount++;
        }
    }
}

