/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.utilint.VLSN;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.Consistency;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RepNodeState {
    private final RepNodeId rnId;
    private final ReqHandlerRef reqHandlerRef;
    private volatile ReplicatedEnvironment.State repState = null;
    private final VLSNState vlsnState;
    private volatile int topoSeqNum = -1;
    public static final int UNKNOWN_TOPO_SEQ_NUM = -1;
    public static final int SAMPLE_SIZE = 8;
    private final ResponseTimeAccumulator readAccumulator;
    private final AtomicLong accumRespTimeMs = new AtomicLong(0L);
    private final AtomicInteger activeRequestCount = new AtomicInteger(0);
    private volatile int maxActiveRequestCount = 0;
    private volatile long totalRequestCount;
    private volatile int errorCount;
    public static int RATE_INTERVAL_MS = 10000;

    public RepNodeState(RepNodeId rnId) {
        this(rnId, RATE_INTERVAL_MS);
    }

    public RepNodeState(RepNodeId rnId, int rateIntervalMs) {
        this.rnId = rnId;
        this.readAccumulator = new ResponseTimeAccumulator();
        this.reqHandlerRef = new ReqHandlerRef();
        this.vlsnState = new VLSNState(rateIntervalMs);
        this.repState = ReplicatedEnvironment.State.REPLICA;
    }

    public RepNodeId getRepNodeId() {
        return this.rnId;
    }

    public RequestHandlerAPI getReqHandlerRef(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
        return this.reqHandlerRef.get(registryUtils, timeoutMs);
    }

    public boolean reqHandlerNeedsResolution() {
        return this.reqHandlerRef.needsResolution();
    }

    public boolean reqHandlerNeedsRepair() {
        return this.reqHandlerRef.needsRepair();
    }

    public RequestHandlerAPI resolveReqHandlerRef(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
        return this.reqHandlerRef.resolve(registryUtils, timeoutMs);
    }

    public void resetReqHandlerRef() throws InterruptedException {
        this.reqHandlerRef.reset();
    }

    public void noteReqHandlerException(Exception e) throws InterruptedException {
        this.reqHandlerRef.noteException(e);
    }

    public short getRequestHandlerSerialVersion() {
        return this.reqHandlerRef.getSerialVersion();
    }

    public ReplicatedEnvironment.State getRepState() {
        return this.repState;
    }

    public void updateRepState(ReplicatedEnvironment.State state) {
        this.repState = state;
    }

    public VLSN getVLSN() {
        return this.vlsnState.getVLSN();
    }

    public boolean isObsoleteVLSNState() {
        return this.vlsnState.isObsolete();
    }

    public void updateVLSN(VLSN newVLSN) {
        this.vlsnState.updateVLSN(newVLSN);
    }

    public int getTopoSeqNum() {
        return this.topoSeqNum;
    }

    public void updateTopoSeqNum(int topoSeqNum) {
        if (this.topoSeqNum < topoSeqNum) {
            this.topoSeqNum = topoSeqNum;
        }
    }

    public void resetTopoSeqNum(int endSeqNum) {
        this.topoSeqNum = endSeqNum;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int incErrorCount() {
        return ++this.errorCount;
    }

    public int getAvReadRespTimeMs() {
        return this.readAccumulator.getAverage();
    }

    public void accumRespTime(boolean forWrite, int responseTimeMs) {
        if (!forWrite) {
            this.readAccumulator.update(responseTimeMs);
        }
        this.accumRespTimeMs.getAndAdd(responseTimeMs);
    }

    public int getActiveRequestCount() {
        return this.activeRequestCount.get();
    }

    public int getMaxActiveRequestCount() {
        return this.maxActiveRequestCount;
    }

    public long getTotalRequestCount() {
        return this.totalRequestCount;
    }

    public long getAccumRespTimeMs() {
        return this.accumRespTimeMs.get();
    }

    public void resetStatsCounts() {
        this.totalRequestCount = 0L;
        this.maxActiveRequestCount = 0;
        this.accumRespTimeMs.set(0L);
    }

    public int requestStart() {
        ++this.totalRequestCount;
        int count = this.activeRequestCount.incrementAndGet();
        this.maxActiveRequestCount = Math.max(this.maxActiveRequestCount, count);
        return count;
    }

    public void requestEnd() {
        this.activeRequestCount.decrementAndGet();
    }

    public String printString() {
        return String.format("node:%s state:%s errors:%,dav resp time %,d ms total requests: %,d", this.getRepNodeId().toString(), this.getRepState().toString(), this.getErrorCount(), this.getAvReadRespTimeMs(), this.getTotalRequestCount());
    }

    public boolean inConsistencyRange(long timeMs, Consistency.Version consistency) {
        assert (consistency != null);
        VLSN consistencyVLSN = new VLSN(consistency.getVersion().getVLSN());
        return this.vlsnState.vlsnAt(timeMs).compareTo(consistencyVLSN) >= 0;
    }

    public boolean inConsistencyRange(long timeMs, Consistency.Time consistency, RepNodeState master) {
        assert (consistency != null);
        if (master == null) {
            return true;
        }
        long lagMs = consistency.getPermissibleLag(TimeUnit.MILLISECONDS);
        VLSN consistencyVLSN = master.vlsnState.vlsnAt(timeMs - lagMs);
        return this.vlsnState.vlsnAt(timeMs).compareTo(consistencyVLSN) >= 0;
    }

    private static class VLSNState {
        private volatile VLSN vlsn = VLSN.NULL_VLSN;
        private long lastUpdateMs;
        private VLSN intervalStart = VLSN.NULL_VLSN;
        private long intervalStartMs = 0L;
        private long vlsnsPerSec = 0L;
        private final int rateIntervalMs;

        VLSNState(int rateIntervalMs) {
            this.rateIntervalMs = rateIntervalMs;
        }

        public VLSN getVLSN() {
            return this.vlsn;
        }

        public synchronized boolean isObsolete() {
            return this.lastUpdateMs + (long)this.rateIntervalMs < System.currentTimeMillis();
        }

        synchronized void updateVLSN(VLSN newVLSN) {
            long intervalMs;
            if (newVLSN == null || newVLSN.isNull()) {
                return;
            }
            this.lastUpdateMs = System.currentTimeMillis();
            if (newVLSN.compareTo(this.vlsn) > 0) {
                this.vlsn = newVLSN;
            }
            if ((intervalMs = this.lastUpdateMs - this.intervalStartMs) <= (long)this.rateIntervalMs) {
                return;
            }
            if (this.intervalStartMs == 0L) {
                this.resetRate(this.lastUpdateMs);
                return;
            }
            long vlsnDelta = this.vlsn.getSequence() - this.intervalStart.getSequence();
            if (vlsnDelta < 0L) {
                this.resetRate(this.lastUpdateMs);
            } else {
                this.intervalStart = this.vlsn;
                this.intervalStartMs = this.lastUpdateMs;
                this.vlsnsPerSec = vlsnDelta * 1000L / intervalMs;
            }
        }

        private synchronized VLSN vlsnAt(long timeMs) {
            if (this.vlsn.isNull()) {
                return VLSN.NULL_VLSN;
            }
            long deltaMs = timeMs - this.lastUpdateMs;
            long vlsnAt = this.vlsn.getSequence() + deltaMs * this.vlsnsPerSec / 1000L;
            return vlsnAt < 0L ? new VLSN(0L) : new VLSN(vlsnAt);
        }

        private void resetRate(long now) {
            this.intervalStart = this.vlsn;
            this.intervalStartMs = now;
            this.vlsnsPerSec = 0L;
        }
    }

    public static class ExceptionSummary {
        private int errorCount = 0;
        private Exception exception = null;
        private long exceptionTimeMs = 0L;

        private void noteException(Exception e) {
            this.exception = e;
            ++this.errorCount;
            this.exceptionTimeMs = System.currentTimeMillis();
        }

        public Exception getException() {
            return this.exception;
        }

        public long getExceptionTimeMs() {
            return this.exceptionTimeMs;
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }

    public class ReqHandlerRef {
        private final Semaphore semaphore = new Semaphore(1, true);
        private RequestHandlerAPI requestHandler = null;
        private volatile ExceptionSummary exceptionSummary = null;
        private short serialVersion = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws InterruptedException {
            this.semaphore.acquire();
            try {
                this.requestHandler = null;
                this.serialVersion = 1;
                this.exceptionSummary = null;
            }
            finally {
                this.semaphore.release();
            }
        }

        public short getSerialVersion() {
            return this.serialVersion;
        }

        public boolean needsResolution() {
            return this.requestHandler == null;
        }

        public boolean needsRepair() {
            return this.exceptionSummary != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestHandlerAPI resolve(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
            RequestHandlerAPI refNonVloatile = this.requestHandler;
            if (refNonVloatile != null) {
                return refNonVloatile;
            }
            boolean acquired = this.semaphore.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS);
            if (!acquired) {
                return null;
            }
            try {
                if (this.requestHandler != null) {
                    RequestHandlerAPI requestHandlerAPI = this.requestHandler;
                    return requestHandlerAPI;
                }
                this.requestHandler = registryUtils.getRequestHandler(RepNodeState.this.rnId);
                this.serialVersion = this.requestHandler.getSerialVersion();
                this.exceptionSummary = null;
                RequestHandlerAPI requestHandlerAPI = this.requestHandler;
                return requestHandlerAPI;
            }
            finally {
                this.semaphore.release();
            }
        }

        public RequestHandlerAPI get(RegistryUtils registryUtils, long timeoutMs) throws InterruptedException {
            RequestHandlerAPI refNonVolatile = this.requestHandler;
            if (refNonVolatile != null) {
                return refNonVolatile;
            }
            if (this.exceptionSummary == null) {
                return this.resolve(registryUtils, timeoutMs);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noteException(Exception e) throws InterruptedException {
            this.semaphore.acquire();
            try {
                this.noteExceptionInternal(e);
            }
            finally {
                this.semaphore.release();
            }
        }

        public void noteExceptionInternal(Exception e) {
            assert (this.semaphore.availablePermits() == 0);
            this.requestHandler = null;
            if (this.exceptionSummary == null) {
                this.exceptionSummary = new ExceptionSummary();
            }
            this.exceptionSummary.noteException(e);
        }
    }

    private static class ResponseTimeAccumulator {
        final short[] samples = new short[8];
        int sumMs = 0;
        int index = 0;

        ResponseTimeAccumulator() {
        }

        synchronized void update(int sampleMs) {
            if (sampleMs > Short.MAX_VALUE) {
                sampleMs = Short.MAX_VALUE;
            }
            this.index = ++this.index >= 8 ? 0 : this.index;
            this.sumMs += sampleMs - this.samples[this.index];
            this.samples[this.index] = (short)sampleMs;
        }

        int getAverage() {
            return this.sumMs / 8;
        }
    }

    public static class AttributeValue<V> {
        final V value;
        final long sequence;

        AttributeValue(V value, long sequence) {
            this.value = value;
            this.sequence = sequence;
        }

        public V getValue() {
            return this.value;
        }

        public long getSequence() {
            return this.sequence;
        }
    }
}

