/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.utilint.VLSN;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.api.ops.ReturnResultValueVersion;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.server.LoggerUtils;

public class OperationHandler {
    private static final int ENV_TIMEOUT_MS = 5000;
    private static final byte[] MIN_KEY = new byte[0];
    private static final DatabaseEntry NO_DATA = new DatabaseEntry();
    static final Comparator<byte[]> KEY_BYTES_COMPARATOR;
    private final RepNode repNode;
    private UUID repNodeUUID;
    private final Logger logger;

    public OperationHandler(RepNode repNode, RepNodeService.Params params) {
        this.repNode = repNode;
        this.logger = LoggerUtils.getLogger(this.getClass(), (RepNodeService.Params)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultValueVersion get(Transaction txn, PartitionId partitionId, byte[] keyBytes) {
        assert (keyBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry dataEntry = new DatabaseEntry();
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            OperationStatus status = cursor.getSearchKey(keyEntry, dataEntry, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                ResultValueVersion resultValueVersion = null;
                return resultValueVersion;
            }
            ResultValueVersion resultValueVersion = this.makeValueVersion(cursor, dataEntry);
            return resultValueVersion;
        }
        finally {
            cursor.close();
        }
    }

    public boolean iterate(Transaction txn, PartitionId partitionId, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey, CursorConfig cursorConfig, final List<ResultKeyValueVersion> results) {
        boolean moreElements = this.scan(txn, partitionId, parentKey, majorPathComplete, subRange, depth, false, resumeKey, batchSize, cursorConfig, LockMode.DEFAULT, direction, new ScanVisitor(){

            @Override
            public void visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                ResultValueVersion valVers = OperationHandler.this.makeValueVersion(cursor, dataEntry);
                results.add(new ResultKeyValueVersion(keyEntry.getData(), valVers.getValueBytes(), valVers.getVersion()));
            }
        });
        return moreElements;
    }

    public boolean iterateKeys(Transaction txn, PartitionId partitionId, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, Depth depth, Direction direction, int batchSize, byte[] resumeKey, CursorConfig cursorConfig, final List<byte[]> results) {
        boolean moreElements = this.scan(txn, partitionId, parentKey, majorPathComplete, subRange, depth, true, resumeKey, batchSize, cursorConfig, LockMode.DEFAULT, direction, new ScanVisitor(){

            @Override
            public void visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                results.add(keyEntry.getData());
            }
        });
        return moreElements;
    }

    public int multiDelete(Transaction txn, PartitionId partitionId, byte[] parentKey, KeyRange subRange, Depth depth) {
        final int[] nDeletions = new int[1];
        boolean moreElements = this.scan(txn, partitionId, parentKey, true, subRange, depth, true, null, 0, CursorConfig.DEFAULT, LockMode.RMW, Direction.FORWARD, new ScanVisitor(){

            @Override
            public void visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                OperationStatus status = cursor.delete();
                assert (status == OperationStatus.SUCCESS);
                nDeletions[0] = nDeletions[0] + 1;
            }
        });
        assert (!moreElements);
        return nDeletions[0];
    }

    private boolean scan(Transaction txn, PartitionId partitionId, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, Depth depth, boolean noData, byte[] resumeKey, int batchSize, CursorConfig cursorConfig, LockMode lockMode, Direction direction, ScanVisitor visitor) {
        boolean allDescendants;
        assert (depth != null);
        if (subRange != null && subRange.isPrefix() && subRange.getStart().length() == 0) {
            subRange = null;
        }
        boolean includeParent = resumeKey == null && (depth == Depth.PARENT_AND_CHILDREN || depth == Depth.PARENT_AND_DESCENDANTS);
        boolean bl = allDescendants = depth == Depth.DESCENDANTS_ONLY || depth == Depth.PARENT_AND_DESCENDANTS;
        assert (direction == Direction.FORWARD || direction == Direction.REVERSE);
        Database db = this.repNode.getPartitionDB(partitionId);
        if (direction == Direction.FORWARD) {
            return this.forwardScan(txn, db, parentKey, majorPathComplete, subRange, includeParent, allDescendants, noData, resumeKey, batchSize, cursorConfig, lockMode, visitor);
        }
        return this.reverseScan(txn, db, parentKey, majorPathComplete, subRange, includeParent, allDescendants, noData, resumeKey, batchSize, cursorConfig, lockMode, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forwardScan(Transaction txn, Database db, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, boolean includeParent, boolean allDescendants, boolean noData, byte[] resumeKey, int batchSize, CursorConfig cursorConfig, LockMode lockMode, ScanVisitor visitor) {
        Object rangeConstraint;
        byte[] searchInitKey;
        if (subRange == null) {
            if (parentKey != null) {
                searchInitKey = Key.addComponent(parentKey, majorPathComplete, "");
                rangeConstraint = this.getPrefixConstraint(searchInitKey);
            } else {
                searchInitKey = MIN_KEY;
                rangeConstraint = null;
            }
        } else if (subRange.isPrefix()) {
            searchInitKey = Key.addComponent(parentKey, majorPathComplete, subRange.getStart());
            rangeConstraint = this.getPrefixConstraint(searchInitKey);
        } else {
            if (subRange.getStart() != null) {
                String rangeStart = subRange.getStartInclusive() ? subRange.getStart() : this.getPathComponentSuccessor(subRange.getStart());
                searchInitKey = Key.addComponent(parentKey, majorPathComplete, rangeStart);
            } else {
                searchInitKey = parentKey != null ? Key.addComponent(parentKey, majorPathComplete, "") : MIN_KEY;
            }
            if (subRange.getEnd() != null) {
                String rangeEnd = subRange.getEndInclusive() ? this.getPathComponentSuccessor(subRange.getEnd()) : subRange.getEnd();
                rangeConstraint = this.getRangeEndConstraint(Key.addComponent(parentKey, majorPathComplete, rangeEnd));
            } else {
                rangeConstraint = parentKey != null ? this.getPrefixConstraint(Key.addComponent(parentKey, majorPathComplete, "")) : null;
            }
        }
        assert (searchInitKey != null);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        if (noData) {
            dataEntry.setPartial(0, 0, true);
        }
        int nRecords = 0;
        Cursor cursor = db.openCursor(txn, cursorConfig);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            int nChildComponents;
            OperationStatus status;
            boolean parentFound = false;
            if (includeParent && parentKey != null) {
                keyEntry.setData(parentKey);
                status = cursor.getSearchKey(keyEntry, dataEntry, lockMode);
                if (status == OperationStatus.SUCCESS) {
                    visitor.visit(cursor, keyEntry, dataEntry);
                    parentFound = true;
                    ++nRecords;
                }
            }
            if (subRange != null && rangeConstraint != null && !subRange.isPrefix() && !rangeConstraint.inBounds(searchInitKey)) {
                boolean bl = false;
                return bl;
            }
            cursor.setRangeConstraint(rangeConstraint);
            if (parentFound && subRange == null) {
                status = cursor.getNext(keyEntry, dataEntry, lockMode);
            } else if (resumeKey != null) {
                keyEntry.setData(resumeKey);
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
                if (status == OperationStatus.SUCCESS && Arrays.equals(resumeKey, keyEntry.getData())) {
                    status = cursor.getNext(keyEntry, dataEntry, lockMode);
                }
            } else {
                keyEntry.setData(searchInitKey);
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
            }
            if (status != OperationStatus.SUCCESS) {
                boolean bl = false;
                return bl;
            }
            if (allDescendants) {
                while (status == OperationStatus.SUCCESS) {
                    visitor.visit(cursor, keyEntry, dataEntry);
                    if (batchSize > 0 && ++nRecords >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getNext(keyEntry, dataEntry, lockMode);
                }
                boolean bl = false;
                return bl;
            }
            int n = nChildComponents = parentKey != null ? Key.countComponents(parentKey) + 1 : 1;
            while (status == OperationStatus.SUCCESS) {
                int nComponents = Key.countComponents(keyEntry.getData());
                if (nComponents == nChildComponents) {
                    visitor.visit(cursor, keyEntry, dataEntry);
                    if (batchSize > 0 && ++nRecords >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getNext(keyEntry, dataEntry, lockMode);
                    continue;
                }
                assert (nComponents > nChildComponents);
                this.getChildKeySuccessor(keyEntry, parentKey);
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reverseScan(Transaction txn, Database db, byte[] parentKey, boolean majorPathComplete, KeyRange subRange, boolean includeParent, boolean allDescendants, boolean noData, byte[] resumeKey, int batchSize, CursorConfig cursorConfig, LockMode lockMode, ScanVisitor visitor) {
        Object rangeConstraint;
        byte[] searchInitKey;
        Object keyPrefix;
        assert (cursorConfig.getReadCommitted());
        if (subRange == null) {
            if (parentKey != null) {
                keyPrefix = Key.addComponent(parentKey, majorPathComplete, "");
                searchInitKey = null;
                rangeConstraint = this.getPrefixConstraint((byte[])keyPrefix);
            } else {
                keyPrefix = null;
                searchInitKey = null;
                rangeConstraint = null;
            }
        } else if (subRange.isPrefix()) {
            keyPrefix = Key.addComponent(parentKey, majorPathComplete, subRange.getStart());
            searchInitKey = null;
            rangeConstraint = this.getPrefixConstraint((byte[])keyPrefix);
        } else {
            keyPrefix = parentKey != null ? Key.addComponent(parentKey, majorPathComplete, "") : null;
            if (subRange.getEnd() != null) {
                String rangeEnd = subRange.getEndInclusive() ? this.getPathComponentSuccessor(subRange.getEnd()) : subRange.getEnd();
                searchInitKey = Key.addComponent(parentKey, majorPathComplete, rangeEnd);
            } else {
                searchInitKey = null;
            }
            if (subRange.getStart() != null) {
                String rangeStart = subRange.getStartInclusive() ? subRange.getStart() : this.getPathComponentSuccessor(subRange.getStart());
                rangeConstraint = this.getRangeStartConstraint(Key.addComponent(parentKey, majorPathComplete, rangeStart));
            } else {
                rangeConstraint = keyPrefix != null ? this.getPrefixConstraint((byte[])keyPrefix) : null;
            }
        }
        DatabaseEntry noDataEntry = new DatabaseEntry();
        noDataEntry.setPartial(0, 0, true);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = noData ? noDataEntry : new DatabaseEntry();
        int nRecords = 0;
        Cursor cursor = db.openCursor(txn, cursorConfig);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            int nChildComponents;
            OperationStatus status;
            if (includeParent && parentKey != null) {
                keyEntry.setData(parentKey);
                status = cursor.getSearchKey(keyEntry, dataEntry, lockMode);
                if (status == OperationStatus.SUCCESS) {
                    visitor.visit(cursor, keyEntry, dataEntry);
                    ++nRecords;
                }
            }
            if (resumeKey != null || searchInitKey != null || keyPrefix != null) {
                if (resumeKey != null) {
                    keyEntry.setData(resumeKey);
                    status = cursor.getSearchKeyRange(keyEntry, noDataEntry, LockMode.READ_UNCOMMITTED);
                } else if (searchInitKey != null) {
                    keyEntry.setData(searchInitKey);
                    status = cursor.getSearchKeyRange(keyEntry, noDataEntry, LockMode.READ_UNCOMMITTED);
                } else {
                    keyEntry.setData(keyPrefix);
                    status = cursor.getNextAfterPrefix(keyEntry, noDataEntry, LockMode.READ_UNCOMMITTED);
                }
                status = status == OperationStatus.SUCCESS ? cursor.getPrev(keyEntry, dataEntry, lockMode) : cursor.getLast(keyEntry, dataEntry, lockMode);
            } else {
                status = cursor.getLast(keyEntry, dataEntry, lockMode);
            }
            if (status != OperationStatus.SUCCESS) {
                boolean bl = false;
                return bl;
            }
            if (rangeConstraint != null && !rangeConstraint.inBounds(keyEntry.getData())) {
                status = OperationStatus.NOTFOUND;
            }
            cursor.setRangeConstraint(rangeConstraint);
            if (allDescendants) {
                while (status == OperationStatus.SUCCESS) {
                    visitor.visit(cursor, keyEntry, dataEntry);
                    if (batchSize > 0 && ++nRecords >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getPrev(keyEntry, dataEntry, lockMode);
                }
                boolean bl = false;
                return bl;
            }
            int n = nChildComponents = parentKey != null ? Key.countComponents(parentKey) + 1 : 1;
            while (status == OperationStatus.SUCCESS) {
                int nComponents = Key.countComponents(keyEntry.getData());
                if (nComponents == nChildComponents) {
                    visitor.visit(cursor, keyEntry, dataEntry);
                    if (batchSize > 0 && ++nRecords >= batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    status = cursor.getPrev(keyEntry, dataEntry, lockMode);
                    continue;
                }
                assert (nComponents > nChildComponents);
                byte[] nonChildKey = keyEntry.getData();
                keyEntry.setData(Key.getPrefixKey(nonChildKey, nChildComponents));
                status = cursor.getSearchKeyRange(keyEntry, dataEntry, lockMode);
                if (status != OperationStatus.SUCCESS || !Arrays.equals(nonChildKey, keyEntry.getData())) continue;
                status = cursor.getPrev(keyEntry, dataEntry, lockMode);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    private String getPathComponentSuccessor(String comp) {
        return comp + '\u0001';
    }

    private void getChildKeySuccessor(DatabaseEntry key, byte[] parentKey) {
        byte[] bytes = key.getData();
        int childOff = parentKey != null ? parentKey.length + 1 : 0;
        int childLen = Key.getComponentLength(bytes, childOff);
        int newLen = childOff + childLen + 1;
        assert (newLen <= bytes.length);
        bytes[newLen - 1] = 1;
        key.setSize(newLen);
    }

    private RangeConstraint getPrefixConstraint(final byte[] prefixKey) {
        final int prefixLen = prefixKey.length;
        return new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                if (checkKey.length < prefixLen) {
                    return false;
                }
                for (int i = 0; i < prefixLen; ++i) {
                    if (prefixKey[i] == checkKey[i]) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private RangeConstraint getRangeEndConstraint(final byte[] endKeyExclusive) {
        return new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                return KEY_BYTES_COMPARATOR.compare(checkKey, endKeyExclusive) < 0;
            }
        };
    }

    private RangeConstraint getRangeStartConstraint(final byte[] startKeyInclusive) {
        return new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                return KEY_BYTES_COMPARATOR.compare(checkKey, startKeyInclusive) >= 0;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version put(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = new DatabaseEntry(valueBytes);
        if (!prevValue.getReturnChoice().needValueOrVersion()) {
            Cursor cursor = db.openCursor(txn, null);
            DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
            try {
                OperationStatus status = cursor.put(keyEntry, dataEntry);
                assert (status == OperationStatus.SUCCESS);
                Version version = this.getVersion(cursor);
                return version;
            }
            finally {
                cursor.close();
            }
        }
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            while (true) {
                OperationStatus status;
                if ((status = cursor.putNoOverwrite(keyEntry, dataEntry)) == OperationStatus.SUCCESS) {
                    Version version = this.getVersion(cursor);
                    return version;
                }
                DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
                status = cursor.getSearchKey(keyEntry, prevData, LockMode.RMW);
                if (status != OperationStatus.SUCCESS) continue;
                this.getPrevValueVersion(cursor, prevData, prevValue);
                cursor.putCurrent(dataEntry);
                Version version = this.getVersion(cursor);
                return version;
            }
        }
        finally {
            cursor.close();
        }
    }

    public Version putIfAbsent(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = new DatabaseEntry(valueBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            while (true) {
                Version version;
                OperationStatus status;
                if ((status = cursor.putNoOverwrite(keyEntry, dataEntry)) == OperationStatus.SUCCESS) {
                    version = this.getVersion(cursor);
                    return version;
                }
                if (prevValue.getReturnChoice() == ReturnValueVersion.Choice.NONE) {
                    version = null;
                    return version;
                }
                DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
                status = cursor.getSearchKey(keyEntry, prevData, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) continue;
                this.getPrevValueVersion(cursor, prevData, prevValue);
                Version version2 = null;
                return version2;
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version putIfPresent(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = new DatabaseEntry(valueBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
            OperationStatus status = cursor.getSearchKey(keyEntry, prevData, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                Version version = null;
                return version;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            cursor.putCurrent(dataEntry);
            Version version = this.getVersion(cursor);
            return version;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version putIfVersion(Transaction txn, PartitionId partitionId, byte[] keyBytes, byte[] valueBytes, Version matchVersion, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && valueBytes != null && matchVersion != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry dataEntry = new DatabaseEntry(valueBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData;
            OperationStatus status = cursor.getSearchKey(keyEntry, NO_DATA, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                Version version = null;
                return version;
            }
            if (this.versionMatches(cursor, matchVersion)) {
                cursor.putCurrent(dataEntry);
                Version version = this.getVersion(cursor);
                return version;
            }
            if (prevValue.getReturnChoice().needValue()) {
                prevData = new DatabaseEntry();
                cursor.getCurrent(keyEntry, prevData, LockMode.RMW);
            } else {
                prevData = NO_DATA;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            Version version = null;
            return version;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Transaction txn, PartitionId partitionId, byte[] keyBytes, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        if (!prevValue.getReturnChoice().needValueOrVersion()) {
            OperationStatus status = db.delete(txn, keyEntry);
            return status == OperationStatus.SUCCESS;
        }
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData = prevValue.getReturnChoice().needValue() ? new DatabaseEntry() : NO_DATA;
            OperationStatus status = cursor.getSearchKey(keyEntry, prevData, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                boolean bl = false;
                return bl;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            cursor.delete();
            boolean bl = true;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIfVersion(Transaction txn, PartitionId partitionId, byte[] keyBytes, Version matchVersion, ReturnResultValueVersion prevValue) {
        assert (keyBytes != null && matchVersion != null);
        Database db = this.repNode.getPartitionDB(partitionId);
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        Cursor cursor = db.openCursor(txn, null);
        DbInternal.setNonCloning((Cursor)cursor, (boolean)true);
        try {
            DatabaseEntry prevData;
            OperationStatus status = cursor.getSearchKey(keyEntry, NO_DATA, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                boolean bl = false;
                return bl;
            }
            if (this.versionMatches(cursor, matchVersion)) {
                cursor.delete();
                boolean bl = true;
                return bl;
            }
            if (prevValue.getReturnChoice().needValue()) {
                prevData = new DatabaseEntry();
                cursor.getCurrent(keyEntry, prevData, LockMode.RMW);
            } else {
                prevData = NO_DATA;
            }
            this.getPrevValueVersion(cursor, prevData, prevValue);
            boolean bl = false;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    private void getPrevValueVersion(Cursor cursor, DatabaseEntry prevData, ReturnResultValueVersion prevValue) {
        switch (prevValue.getReturnChoice()) {
            case VALUE: {
                assert (!prevData.getPartial());
                prevValue.setValueVersion(prevData.getData(), null);
                break;
            }
            case VERSION: {
                prevValue.setValueVersion(null, this.getVersion(cursor));
                break;
            }
            case ALL: {
                assert (!prevData.getPartial());
                prevValue.setValueVersion(prevData.getData(), this.getVersion(cursor));
                break;
            }
            case NONE: {
                prevValue.setValueVersion(null, null);
                break;
            }
            default: {
                throw new IllegalStateException(prevValue.getReturnChoice().toString());
            }
        }
    }

    private Version getVersion(Cursor cursor) {
        CursorImpl cursorImpl = DbInternal.getCursorImpl((Cursor)cursor);
        RecordVersion recVersion = cursorImpl.getCurrentVersion(true);
        return new Version(this.getRepNodeUUID(), recVersion.getVLSN(), this.repNode.getRepNodeId(), recVersion.getLSN());
    }

    private boolean versionMatches(Cursor cursor, Version matchVersion) {
        CursorImpl cursorImpl;
        RecordVersion recVersion;
        RepNodeId repNodeId = this.repNode.getRepNodeId();
        if (matchVersion.samePhysicalVersion(repNodeId, (recVersion = (cursorImpl = DbInternal.getCursorImpl((Cursor)cursor)).getCurrentVersion(false)).getLSN())) {
            return true;
        }
        long vlsn = recVersion.getVLSN();
        if (!VLSN.isNull(vlsn)) {
            return matchVersion.sameLogicalVersion(vlsn);
        }
        recVersion = cursorImpl.getCurrentVersion(true);
        vlsn = recVersion.getVLSN();
        assert (!VLSN.isNull(vlsn));
        return matchVersion.sameLogicalVersion(vlsn);
    }

    private synchronized UUID getRepNodeUUID() {
        if (this.repNodeUUID != null) {
            return this.repNodeUUID;
        }
        RepImpl repImpl = RepInternal.getRepImpl((ReplicatedEnvironment)this.repNode.getEnv(5000L));
        if (repImpl == null) {
            throw new FaultException("Unable to get ReplicatedEnvironment after 5000 ms", true);
        }
        this.repNodeUUID = repImpl.getUUID();
        assert (this.repNodeUUID != null);
        return this.repNodeUUID;
    }

    private ResultValueVersion makeValueVersion(Cursor c, DatabaseEntry dataEntry) {
        return new ResultValueVersion(dataEntry.getData(), this.getVersion(c));
    }

    static {
        NO_DATA.setPartial(0, 0, true);
        KEY_BYTES_COMPARATOR = new Key.BytesComparator();
    }

    static interface ScanVisitor {
        public void visit(Cursor var1, DatabaseEntry var2, DatabaseEntry var3);
    }
}

