/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.topo.PartitionId;

public class MultiGetKeys
extends MultiKeyOperation {
    public MultiGetKeys(byte[] parentKey, KeyRange subRange, Depth depth) {
        super(InternalOperation.OpCode.MULTI_GET_KEYS, parentKey, subRange, depth);
    }

    MultiGetKeys(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_GET_KEYS, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        boolean moreElements = operationHandler.iterateKeys(txn, partitionId, this.getParentKey(), true, this.getSubRange(), this.getDepth(), Direction.FORWARD, 0, null, CursorConfig.DEFAULT, results);
        assert (!moreElements);
        return new Result.KeysIterateResult(this.getOpCode(), results, moreElements);
    }
}

