/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.utilint.Latency;
import com.sleepycat.utilint.LatencyStat;
import com.sleepycat.utilint.StatsTracker;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.ConsistencyException;
import oracle.kv.FaultException;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreException;
import oracle.kv.RequestLimitConfig;
import oracle.kv.RequestLimitException;
import oracle.kv.RequestTimeoutException;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.api.ClientId;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.RequestHandlerAPI;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepGroupStateTable;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.rgstate.RepNodeStateUpdateThread;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private final ResourceId dispatcherId;
    private final boolean isRemote;
    private final RequestLimitConfig requestLimitConfig;
    private final TopologyManager topoManager;
    private final RepGroupStateTable repGroupStateTable;
    private final RepNodeStateUpdateThread stateUpdateThread;
    private volatile RegistryUtils regUtils = null;
    private final AtomicInteger activeRequestCount = new AtomicInteger(0);
    private final StatsTracker<InternalOperation.OpCode> statsTracker;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Throwable shutdownException = null;
    private final Logger logger;
    private static final int MAX_LOCATOR_RNS = 10;
    private static final int STATE_UPDATE_THREAD_PERIOD_MS = 1000;
    private static final int RETRY_SLEEP_MAX_NS = 128000000;

    public RequestDispatcherImpl(String kvsName, RepNodeParams repNodeParams, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) {
        assert (kvsName != null);
        this.logger = logger;
        RequestLimitConfig defaultRequestLimitConfig = ParameterUtils.getRequestLimitConfig((ParameterMap)repNodeParams.getMap());
        this.requestLimitConfig = this.getRepNodeRequestLimitConfig(defaultRequestLimitConfig);
        this.topoManager = new TopologyManager(kvsName, logger);
        RepNodeId repNodeId = repNodeParams.getRepNodeId();
        this.repGroupStateTable = new RepGroupStateTable(repNodeId);
        this.initTopoManager();
        this.dispatcherId = repNodeId;
        this.isRemote = true;
        this.stateUpdateThread = new RepNodeStateUpdateThread(this, 1000, exceptionHandler, logger);
        int maxTrackedLatencyMillis = ParameterUtils.getMaxTrackedLatencyMillis((ParameterMap)repNodeParams.getMap());
        this.statsTracker = new StatsTracker<InternalOperation.OpCode>(InternalOperation.OpCode.values(), logger, Integer.MAX_VALUE, Long.MAX_VALUE, 0, maxTrackedLatencyMillis);
        this.stateUpdateThread.start();
    }

    public RequestDispatcherImpl(KVStoreConfig config, ClientId clientId, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) throws KVStoreException {
        this(config.getStoreName(), clientId, TopologyLocator.get(config.getHelperHosts(), 10), config.getRequestLimit(), exceptionHandler, logger);
        this.stateUpdateThread.start();
    }

    public RequestDispatcherImpl(String kvsName, ClientId clientId, Topology topology, RequestLimitConfig requestLimitConfig, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) {
        assert (kvsName != null);
        if (!topology.getKVStoreName().equals(kvsName)) {
            throw new IllegalArgumentException("Specified store name, " + kvsName + ", does not match store name at specified host/port, " + topology.getKVStoreName());
        }
        this.logger = logger;
        this.statsTracker = new StatsTracker<InternalOperation.OpCode>(InternalOperation.OpCode.values(), logger, Integer.MAX_VALUE, Long.MAX_VALUE, 0, 1000);
        this.requestLimitConfig = requestLimitConfig;
        this.topoManager = new TopologyManager(kvsName, logger);
        this.repGroupStateTable = new RepGroupStateTable(clientId);
        this.initTopoManager();
        this.dispatcherId = clientId;
        this.isRemote = false;
        this.stateUpdateThread = new RepNodeStateUpdateThread(this, 1000, exceptionHandler, logger);
        this.topoManager.update(topology);
    }

    private RequestLimitConfig getRepNodeRequestLimitConfig(RequestLimitConfig defaultConfig) {
        int maxActiveRequests = defaultConfig.getNodeLimit();
        String maxConnectionsProperty = System.getProperty("sun.rmi.transport.tcp.maxConnectionThreads");
        if (maxConnectionsProperty != null) {
            try {
                maxActiveRequests = Integer.parseInt(maxConnectionsProperty);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("RMI max connection threads:" + maxConnectionsProperty);
            }
        }
        return new RequestLimitConfig(maxActiveRequests, defaultConfig.getRequestThresholdPercent(), defaultConfig.getNodeLimitPercent());
    }

    @Override
    public void shutdown(Throwable exception) {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.shutdownException = exception;
        if (this.stateUpdateThread.isAlive()) {
            this.stateUpdateThread.shutdown();
        }
        this.logger.log(exception != null ? Level.WARNING : Level.INFO, "Dispatcher shutdown", exception);
    }

    private void checkShutdown() {
        if (this.shutdown.get()) {
            String message = "Request dispatcher has been shutdown.";
            throw new IllegalStateException("Request dispatcher has been shutdown.", this.shutdownException);
        }
    }

    public RepNodeStateUpdateThread getStateUpdateThread() {
        return this.stateUpdateThread;
    }

    private void initTopoManager() {
        this.topoManager.addListener(this.repGroupStateTable);
        this.topoManager.addListener(new RegUtilsMaintListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Request request, RepNodeId targetId, Set<RepNodeId> excludeRNs) throws FaultException {
        this.checkShutdown();
        request.decTTL();
        RepGroupId repGroupId = this.topoManager.getTopology().getRepGroupId(request.getPartitionId());
        request.updateForwardingRNs(this.dispatcherId, repGroupId.getGroupId());
        RepGroupState rgState = this.repGroupStateTable.getGroupState(repGroupId);
        int timeoutMs = request.getTimeout();
        long limitNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        int retryCount = 0;
        Exception exception = null;
        RepNodeState target = null;
        long retrySleepNs = 10000000L;
        do {
            try {
                target = targetId != null ? this.repGroupStateTable.getNodeState(targetId) : this.selectDispatchRN(rgState, request, excludeRNs);
            }
            catch (NoSuitableRNException nsre) {
                exception = nsre;
                if (!request.isInitiatingDispatcher(this.dispatcherId)) {
                    throw new RNUnavailableException(nsre.getMessage());
                }
                retrySleepNs = this.waitBeforeRetry(limitNs, retrySleepNs);
                excludeRNs.clear();
                continue;
            }
            long startNs = 0L;
            try {
                this.activeRequestCount.incrementAndGet();
                int targetRequestCount = target.requestStart();
                startNs = this.statsTracker.markStart();
                if (this.activeRequestCount.get() > this.requestLimitConfig.getRequestThreshold() && targetRequestCount > this.requestLimitConfig.getNodeLimit()) {
                    throw RequestLimitException.create(this.requestLimitConfig, target.getRepNodeId(), this.activeRequestCount.get(), targetRequestCount, this.isRemote);
                }
                RequestHandlerAPI requestHandler = target.getReqHandlerRef(this.regUtils, limitNs - startNs);
                if (requestHandler != null) {
                    if (retryCount++ > 0) {
                        request.setTimeout((int)TimeUnit.NANOSECONDS.toMillis(limitNs - System.nanoTime()));
                    }
                    request.setSerialVersion(target.getRequestHandlerSerialVersion());
                    Response response = requestHandler.execute(request);
                    this.processResponse(startNs, request, response);
                    if (this.logger.isLoggable(Level.FINE)) {
                        RepNodeId rnId = response.getRespondingRN();
                        RepNodeState rns = this.repGroupStateTable.getNodeState(rnId);
                        this.logger.fine("Response from " + rns.printString());
                    }
                    exception = null;
                    Response response2 = response;
                    return response2;
                }
                exception = new IllegalStateException("Could not establish handle to " + target.getRepNodeId());
            }
            catch (RemoteException re) {
                exception = re;
                this.handleRemoteException(request, target, re);
            }
            catch (InterruptedException ie) {
                throw new OperationFaultException("Unexpected interrupt", ie);
            }
            catch (RNUnavailableException rue) {
                exception = rue;
            }
            catch (ConsistencyException ce) {
                if (!request.isInitiatingDispatcher(this.dispatcherId)) {
                    throw ce;
                }
                exception = ce;
            }
            finally {
                target.requestEnd();
                this.statsTracker.markFinish(request.getOperation().getOpCode(), startNs);
                this.activeRequestCount.decrementAndGet();
                if (exception != null) {
                    this.logger.fine(exception.getMessage());
                    target.incErrorCount();
                }
                excludeRNs = this.excludeRN(excludeRNs, target);
            }
        } while (System.nanoTime() < limitNs);
        if (exception instanceof ConsistencyException) {
            throw (ConsistencyException)exception;
        }
        throw new RequestTimeoutException(timeoutMs, "Request dispatcher:" + this.dispatcherId + ", dispatch timed out after " + retryCount + " retries." + " Target:" + (target == null ? "not available" : target.getRepNodeId()) + " Timeout:" + timeoutMs + "ms", exception, this.isRemote);
    }

    private long waitBeforeRetry(long limitNs, long prevWaitNs) throws OperationFaultException {
        long thisWaitNs = Math.min(prevWaitNs << 1, 128000000L);
        long now = System.nanoTime();
        if (now >= limitNs) {
            return 0L;
        }
        if (now + thisWaitNs > limitNs) {
            thisWaitNs = limitNs - now;
        }
        this.logger.fine("Retrying after wait: " + TimeUnit.NANOSECONDS.toMillis(thisWaitNs) + "ms");
        try {
            Thread.sleep(TimeUnit.NANOSECONDS.toMillis(thisWaitNs));
        }
        catch (InterruptedException ie) {
            throw new OperationFaultException("Unexpected interrupt", ie);
        }
        return thisWaitNs;
    }

    @Override
    public Response executeNOP(RepNodeState rns, int timeoutMs) throws Exception {
        RequestHandlerAPI ref = rns.getReqHandlerRef(this.getRegUtils(), timeoutMs);
        if (ref == null) {
            return null;
        }
        rns.requestStart();
        long startTimeNs = this.statsTracker.markStart();
        try {
            int topoSeqNumber = this.getTopologyManager().getTopology().getSequenceNumber();
            Request nop = Request.createNOP(topoSeqNumber, this.getDispatcherId(), timeoutMs);
            nop.setSerialVersion(rns.getRequestHandlerSerialVersion());
            Response response = ref.execute(nop);
            this.processResponse(startTimeNs, nop, response);
            Response response2 = response;
            return response2;
        }
        catch (ConnectException ce) {
            this.noteReqHandlerException(rns, ce);
            throw ce;
        }
        catch (ServerError se) {
            this.noteReqHandlerException(rns, se);
            throw se;
        }
        catch (NoSuchObjectException noe) {
            this.noteReqHandlerException(rns, noe);
            throw noe;
        }
        finally {
            rns.requestEnd();
            this.statsTracker.markFinish(InternalOperation.OpCode.NOP, startTimeNs);
        }
    }

    private void handleRemoteException(Request request, RepNodeState rnState, RemoteException exception) {
        this.logger.fine(exception.getMessage());
        try {
            throw exception;
        }
        catch (UnknownHostException uhe) {
            return;
        }
        catch (ConnectException ce) {
            this.noteReqHandlerException(rnState, ce);
            return;
        }
        catch (ConnectIOException cie) {
            return;
        }
        catch (MarshalException me) {
            if (request.isWrite()) {
                throw new FaultException("Problem during unmarshalling", me, this.isRemote);
            }
            return;
        }
        catch (UnmarshalException ue) {
            if (request.isWrite()) {
                throw new FaultException("Problem during marshalling", ue, this.isRemote);
            }
            return;
        }
        catch (ServerException se) {
            throw new FaultException("Exception in server", se, this.isRemote);
        }
        catch (ServerError se) {
            this.noteReqHandlerException(rnState, se);
            throw new FaultException("Error in server", se, this.isRemote);
        }
        catch (NoSuchObjectException noe) {
            this.noteReqHandlerException(rnState, noe);
            return;
        }
        catch (RemoteException e) {
            throw new FaultException("unexpected exception", e, this.isRemote);
        }
    }

    private void noteReqHandlerException(RepNodeState rns, Exception e) {
        try {
            rns.noteReqHandlerException(e);
        }
        catch (InterruptedException ie) {
            throw new OperationFaultException("Unexpected interrupt", ie);
        }
    }

    private Set<RepNodeId> excludeRN(Set<RepNodeId> excludeSet, RepNodeState rnState) {
        if (rnState == null) {
            return excludeSet;
        }
        if (excludeSet == null) {
            excludeSet = new HashSet<RepNodeId>();
        }
        excludeSet.add(rnState.getRepNodeId());
        return excludeSet;
    }

    public Response execute(Request request, RepNodeId targetId) throws FaultException {
        return this.execute(request, targetId, null);
    }

    @Override
    public Response execute(Request request, Set<RepNodeId> excludeRNs) throws FaultException {
        return this.execute(request, null, excludeRNs);
    }

    @Override
    public Response execute(Request request) throws FaultException {
        return this.execute(request, null, null);
    }

    private void processResponse(long startNs, Request request, Response response) {
        TopologyInfo topoInfo = response.getTopoInfo();
        if (topoInfo != null && topoInfo.getChanges() != null) {
            this.topoManager.update(topoInfo.getChanges());
        }
        this.repGroupStateTable.update(request, response, (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs));
    }

    private RepNodeState selectDispatchRN(RepGroupState rgState, Request request, Set<RepNodeId> excludeRNs) throws NoSuitableRNException {
        RepNodeState master;
        boolean needsMaster = request.needsMaster();
        if (needsMaster && (master = rgState.getMaster()) != null && (excludeRNs == null || !excludeRNs.contains(master.getRepNodeId()))) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Dispatching to master: " + master.getRepNodeId());
            }
            return master;
        }
        RepNodeState rnState = rgState.getLoadBalancedRN(request, excludeRNs);
        if (rnState != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Dispatching target RN: " + rnState.getRepNodeId());
            }
            return rnState;
        }
        RepGroupId groupId = rgState.getResourceId();
        RepNodeState randomRN = rgState.getRandomRN(excludeRNs);
        if (randomRN == null) {
            String message = (needsMaster ? "No active (or reachable) master in rep group: " + groupId : "No suitable node currently available to service the request in rep group: " + groupId) + ". Unsuitable nodes: " + (excludeRNs == null ? "none" : excludeRNs);
            this.logger.fine(message);
            throw new NoSuitableRNException(message);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Dispatching to random RN: " + randomRN.getRepNodeId());
        }
        return randomRN;
    }

    public void logRequestStats() {
        for (RepNodeState rnState : this.repGroupStateTable.getRepNodeStates()) {
            this.logger.info(rnState.printString());
        }
    }

    @Override
    public TopologyManager getTopologyManager() {
        return this.topoManager;
    }

    @Override
    public RepGroupStateTable getRepGroupStateTable() {
        return this.repGroupStateTable;
    }

    @Override
    public ResourceId getDispatcherId() {
        return this.dispatcherId;
    }

    @Override
    public PartitionId getPartitionId(byte[] keyBytes) {
        return this.topoManager.getTopology().getPartitionId(keyBytes);
    }

    @Override
    public RegistryUtils getRegUtils() {
        return this.regUtils;
    }

    @Override
    public Map<InternalOperation.OpCode, Latency> getLatencyStats(boolean clear) {
        HashMap<InternalOperation.OpCode, Latency> map = new HashMap<InternalOperation.OpCode, Latency>();
        for (Map.Entry<InternalOperation.OpCode, LatencyStat> entry : this.statsTracker.getIntervalLatency().entrySet()) {
            Latency latency = clear ? entry.getValue().calculateAndClear() : entry.getValue().calculate();
            map.put(entry.getKey(), latency);
        }
        return map;
    }

    private class RegUtilsMaintListener
    implements TopologyManager.Listener {
        private RegUtilsMaintListener() {
        }

        @Override
        public void update(Topology topology) {
            RequestDispatcherImpl.this.regUtils = new RegistryUtils(topology);
        }
    }

    private class NoSuitableRNException
    extends Exception {
        NoSuitableRNException(String message) {
            super(message);
        }
    }
}

