/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.je.utilint.PropUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Durability;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import oracle.kv.KeyValueVersion;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationFactory;
import oracle.kv.OperationResult;
import oracle.kv.ReturnValueVersion;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.ops.Delete;
import oracle.kv.impl.api.ops.DeleteIfVersion;
import oracle.kv.impl.api.ops.Execute;
import oracle.kv.impl.api.ops.Get;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiDelete;
import oracle.kv.impl.api.ops.MultiGet;
import oracle.kv.impl.api.ops.MultiGetIterate;
import oracle.kv.impl.api.ops.MultiGetKeys;
import oracle.kv.impl.api.ops.MultiGetKeysIterate;
import oracle.kv.impl.api.ops.Put;
import oracle.kv.impl.api.ops.PutIfAbsent;
import oracle.kv.impl.api.ops.PutIfPresent;
import oracle.kv.impl.api.ops.PutIfVersion;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.StoreIterate;
import oracle.kv.impl.api.ops.StoreKeysIterate;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.stats.KVStats;

public class KVStoreImpl
implements KVStore {
    private static int DEFAULT_TTL = 5;
    private static int DEFAULT_ITERATOR_BATCH_SIZE = 100;
    private final RequestDispatcher dispatcher;
    private final int defaultTimeoutMs;
    private final Consistency defaultConsistency;
    private final Durability defaultDurability;
    private final OperationFactory operationFactory;
    private final int nPartitions;

    public KVStoreImpl(RequestDispatcher dispatcher, int defaultTimeoutMs, Consistency defaultConsistency, Durability defaultDurability) {
        this.dispatcher = dispatcher;
        this.defaultTimeoutMs = defaultTimeoutMs;
        this.defaultConsistency = defaultConsistency;
        this.defaultDurability = defaultDurability;
        this.operationFactory = new Execute.OperationFactoryImpl();
        this.nPartitions = dispatcher.getTopologyManager().getTopology().getPartitionMap().getNPartitions();
    }

    public RequestDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public ValueVersion get(Key key) throws FaultException {
        return this.get(key, null, 0L, null);
    }

    @Override
    public ValueVersion get(Key key, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        PartitionId partitionId;
        byte[] keyBytes = key.toByteArray();
        Get get = new Get(keyBytes);
        Request req = this.makeReadRequest(get, partitionId = this.dispatcher.getPartitionId(keyBytes), consistency, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        Value value = result.getPreviousValue();
        if (value == null) {
            return null;
        }
        ValueVersion ret = new ValueVersion();
        ret.setValue(value);
        ret.setVersion(result.getPreviousVersion());
        return ret;
    }

    @Override
    public SortedMap<Key, ValueVersion> multiGet(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGet(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public SortedMap<Key, ValueVersion> multiGet(Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = parentKey.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiGet get = new MultiGet(parentKeyBytes, subRange, depth);
        Request req = this.makeReadRequest(get, partitionId, consistency, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
        TreeMap<Key, ValueVersion> stringKeyResults = new TreeMap<Key, ValueVersion>();
        for (ResultKeyValueVersion entry : byteKeyResults) {
            stringKeyResults.put(Key.fromByteArray(entry.getKeyBytes()), new ValueVersion(entry.getValue(), entry.getVersion()));
        }
        return stringKeyResults;
    }

    @Override
    public SortedSet<Key> multiGetKeys(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetKeys(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public SortedSet<Key> multiGetKeys(Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = parentKey.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiGetKeys get = new MultiGetKeys(parentKeyBytes, subRange, depth);
        Request req = this.makeReadRequest(get, partitionId, consistency, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        List<byte[]> byteKeyResults = result.getKeyList();
        TreeSet<Key> stringKeySet = new TreeSet<Key>();
        for (byte[] entry : byteKeyResults) {
            stringKeySet.add(Key.fromByteArray(entry));
        }
        return stringKeySet;
    }

    @Override
    public Iterator<KeyValueVersion> multiGetIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> multiGetIterator(final Direction direction, int batchSize, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.REVERSE) {
            throw new IllegalArgumentException("Only Direction.FORWARD and REVERSE are supported, got: " + (Object)((Object)direction));
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey.toByteArray();
        final PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        return new ArrayIterator<KeyValueVersion>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            KeyValueVersion[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                MultiGetIterate get = new MultiGetIterate(parentKeyBytes, subRange, useDepth, direction, useBatchSize, this.resumeKey);
                Request req = KVStoreImpl.this.makeReadRequest(get, partitionId, consistency, timeout, timeoutUnit);
                Result result = KVStoreImpl.this.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<ResultKeyValueVersion> byteKeyResults = result.getKeyValueVersionList();
                if (byteKeyResults.size() == 0) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                KeyValueVersion[] stringKeyResults = new KeyValueVersion[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    stringKeyResults[i] = new KeyValueVersion(Key.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion());
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<Key> multiGetKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiGetKeysIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<Key> multiGetKeysIterator(final Direction direction, int batchSize, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD && direction != Direction.REVERSE) {
            throw new IllegalArgumentException("Only Direction.FORWARD and REVERSE are supported, got: " + (Object)((Object)direction));
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey.toByteArray();
        final PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        return new ArrayIterator<Key>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;

            Key[] getMoreElements() {
                if (!this.moreElements) {
                    return null;
                }
                MultiGetKeysIterate get = new MultiGetKeysIterate(parentKeyBytes, subRange, useDepth, direction, useBatchSize, this.resumeKey);
                Request req = KVStoreImpl.this.makeReadRequest(get, partitionId, consistency, timeout, timeoutUnit);
                Result result = KVStoreImpl.this.executeRequest(req);
                this.moreElements = result.hasMoreElements();
                List<byte[]> byteKeyResults = result.getKeyList();
                if (byteKeyResults.size() == 0) {
                    assert (!this.moreElements);
                    return null;
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1);
                Key[] stringKeyResults = new Key[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    byte[] entry = byteKeyResults.get(i);
                    stringKeyResults[i] = Key.fromByteArray(entry);
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize) throws FaultException {
        return this.storeIterator(direction, batchSize, null, null, null, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.storeIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        return this.storeIterator(direction, batchSize, 1, this.nPartitions, parentKey, subRange, depth, consistency, timeout, timeoutUnit);
    }

    public Iterator<KeyValueVersion> partitionIterator(Direction direction, int batchSize, int partition, Key parentKey, KeyRange subRange, Depth depth, Consistency consistency, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.FORWARD) {
            throw new IllegalArgumentException("Only Direction.FORWARD is currently supported, got: " + (Object)((Object)direction));
        }
        return this.storeIterator(Direction.UNORDERED, batchSize, partition, partition, parentKey, subRange, depth, consistency, timeout, timeoutUnit);
    }

    private Iterator<KeyValueVersion> storeIterator(Direction direction, int batchSize, final int firstPartition, final int lastPartition, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + (Object)((Object)direction));
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey != null ? parentKey.toByteArray() : null;
        return new ArrayIterator<KeyValueVersion>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;
            private PartitionId partitionId = new PartitionId(firstPartition);

            KeyValueVersion[] getMoreElements() {
                List<ResultKeyValueVersion> byteKeyResults;
                block4: {
                    while (true) {
                        if (!this.moreElements && this.partitionId.getPartitionId() < lastPartition) {
                            this.partitionId = new PartitionId(this.partitionId.getPartitionId() + 1);
                            this.moreElements = true;
                            this.resumeKey = null;
                        }
                        if (!this.moreElements) {
                            return null;
                        }
                        StoreIterate get = new StoreIterate(parentKeyBytes, subRange, useDepth, Direction.FORWARD, useBatchSize, this.resumeKey);
                        Request req = KVStoreImpl.this.makeReadRequest(get, this.partitionId, consistency, timeout, timeoutUnit);
                        Result result = KVStoreImpl.this.executeRequest(req);
                        this.moreElements = result.hasMoreElements();
                        byteKeyResults = result.getKeyValueVersionList();
                        if (byteKeyResults.size() != 0) break block4;
                        assert (!this.moreElements);
                    }
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1).getKeyBytes();
                KeyValueVersion[] stringKeyResults = new KeyValueVersion[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    ResultKeyValueVersion entry = byteKeyResults.get(i);
                    stringKeyResults[i] = new KeyValueVersion(Key.fromByteArray(entry.getKeyBytes()), entry.getValue(), entry.getVersion());
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize) throws FaultException {
        return this.storeKeysIterator(direction, batchSize, null, null, null, null, 0L, null);
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.storeKeysIterator(direction, batchSize, parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public Iterator<Key> storeKeysIterator(Direction direction, int batchSize, Key parentKey, final KeyRange subRange, Depth depth, final Consistency consistency, final long timeout, final TimeUnit timeoutUnit) throws FaultException {
        if (direction != Direction.UNORDERED) {
            throw new IllegalArgumentException("Only Direction.UNORDERED is currently supported, got: " + (Object)((Object)direction));
        }
        if (parentKey != null && parentKey.getMinorPath().size() > 0) {
            throw new IllegalArgumentException("Minor path of parentKey must be empty");
        }
        final Depth useDepth = depth != null ? depth : Depth.PARENT_AND_DESCENDANTS;
        final int useBatchSize = batchSize > 0 ? batchSize : DEFAULT_ITERATOR_BATCH_SIZE;
        final byte[] parentKeyBytes = parentKey != null ? parentKey.toByteArray() : null;
        return new ArrayIterator<Key>(){
            private boolean moreElements = true;
            private byte[] resumeKey = null;
            private PartitionId partitionId = new PartitionId(1);

            Key[] getMoreElements() {
                List<byte[]> byteKeyResults;
                block4: {
                    while (true) {
                        if (!this.moreElements && this.partitionId.getPartitionId() < KVStoreImpl.this.nPartitions) {
                            this.partitionId = new PartitionId(this.partitionId.getPartitionId() + 1);
                            this.moreElements = true;
                            this.resumeKey = null;
                        }
                        if (!this.moreElements) {
                            return null;
                        }
                        StoreKeysIterate get = new StoreKeysIterate(parentKeyBytes, subRange, useDepth, Direction.FORWARD, useBatchSize, this.resumeKey);
                        Request req = KVStoreImpl.this.makeReadRequest(get, this.partitionId, consistency, timeout, timeoutUnit);
                        Result result = KVStoreImpl.this.executeRequest(req);
                        this.moreElements = result.hasMoreElements();
                        byteKeyResults = result.getKeyList();
                        if (byteKeyResults.size() != 0) break block4;
                        assert (!this.moreElements);
                    }
                }
                this.resumeKey = byteKeyResults.get(byteKeyResults.size() - 1);
                Key[] stringKeyResults = new Key[byteKeyResults.size()];
                for (int i = 0; i < stringKeyResults.length; ++i) {
                    byte[] entry = byteKeyResults.get(i);
                    stringKeyResults[i] = Key.fromByteArray(entry);
                }
                return stringKeyResults;
            }
        };
    }

    @Override
    public Version put(Key key, Value value) throws FaultException {
        return this.put(key, value, null, null, 0L, null);
    }

    @Override
    public Version put(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = key.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        Put put = new Put(keyBytes, value, prevValChoice);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getNewVersion();
    }

    @Override
    public Version putIfAbsent(Key key, Value value) throws FaultException {
        return this.putIfAbsent(key, value, null, null, 0L, null);
    }

    @Override
    public Version putIfAbsent(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = key.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfAbsent put = new PutIfAbsent(keyBytes, value, prevValChoice);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getNewVersion();
    }

    @Override
    public Version putIfPresent(Key key, Value value) throws FaultException {
        return this.putIfPresent(key, value, null, null, 0L, null);
    }

    @Override
    public Version putIfPresent(Key key, Value value, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = key.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfPresent put = new PutIfPresent(keyBytes, value, prevValChoice);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getNewVersion();
    }

    @Override
    public Version putIfVersion(Key key, Value value, Version matchVersion) throws FaultException {
        return this.putIfVersion(key, value, matchVersion, null, null, 0L, null);
    }

    @Override
    public Version putIfVersion(Key key, Value value, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = key.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        PutIfVersion put = new PutIfVersion(keyBytes, value, prevValChoice, matchVersion);
        Request req = this.makeWriteRequest(put, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getNewVersion();
    }

    @Override
    public boolean delete(Key key) throws FaultException {
        return this.delete(key, null, null, 0L, null);
    }

    @Override
    public boolean delete(Key key, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = key.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        Delete del = new Delete(keyBytes, prevValChoice);
        Request req = this.makeWriteRequest(del, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getSuccess();
    }

    @Override
    public boolean deleteIfVersion(Key key, Version matchVersion) throws FaultException {
        return this.deleteIfVersion(key, matchVersion, null, null, 0L, null);
    }

    @Override
    public boolean deleteIfVersion(Key key, Version matchVersion, ReturnValueVersion prevValue, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        byte[] keyBytes = key.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(keyBytes);
        ReturnValueVersion.Choice prevValChoice = prevValue != null ? prevValue.getReturnChoice() : ReturnValueVersion.Choice.NONE;
        DeleteIfVersion del = new DeleteIfVersion(keyBytes, prevValChoice, matchVersion);
        Request req = this.makeWriteRequest(del, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        if (prevValue != null) {
            prevValue.setValue(result.getPreviousValue());
            prevValue.setVersion(result.getPreviousVersion());
        }
        return result.getSuccess();
    }

    @Override
    public int multiDelete(Key parentKey, KeyRange subRange, Depth depth) throws FaultException {
        return this.multiDelete(parentKey, subRange, depth, null, 0L, null);
    }

    @Override
    public int multiDelete(Key parentKey, KeyRange subRange, Depth depth, Durability durability, long timeout, TimeUnit timeoutUnit) throws FaultException {
        if (depth == null) {
            depth = Depth.PARENT_AND_DESCENDANTS;
        }
        byte[] parentKeyBytes = parentKey.toByteArray();
        PartitionId partitionId = this.dispatcher.getPartitionId(parentKeyBytes);
        MultiDelete del = new MultiDelete(parentKeyBytes, subRange, depth);
        Request req = this.makeWriteRequest(del, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        return result.getNDeletions();
    }

    @Override
    public List<OperationResult> execute(List<Operation> operations) throws OperationExecutionException, FaultException {
        return this.execute(operations, null, 0L, null);
    }

    @Override
    public List<OperationResult> execute(List<Operation> operations, Durability durability, long timeout, TimeUnit timeoutUnit) throws OperationExecutionException, FaultException {
        List<Execute.OperationImpl> ops = Execute.OperationImpl.downcast(operations);
        if (ops == null || ops.size() == 0) {
            throw new IllegalArgumentException("operations must be non-null and non-empty");
        }
        Execute.OperationImpl firstOp = ops.get(0);
        List<String> firstMajorPath = firstOp.getKey().getMajorPath();
        HashSet<Key> keySet = new HashSet<Key>();
        keySet.add(firstOp.getKey());
        for (int i = 1; i < ops.size(); ++i) {
            Execute.OperationImpl op = ops.get(i);
            Key opKey = op.getKey();
            if (!((Object)opKey.getMajorPath()).equals(firstMajorPath)) {
                throw new IllegalArgumentException("Two operations have different major paths, first: " + firstOp.getKey() + " other: " + opKey);
            }
            if (keySet.add(opKey)) continue;
            throw new IllegalArgumentException("More than one operation has the same Key: " + opKey);
        }
        Execute exe = new Execute(ops);
        PartitionId partitionId = this.dispatcher.getPartitionId(firstOp.getInternalOp().getKeyBytes());
        Request req = this.makeWriteRequest(exe, partitionId, durability, timeout, timeoutUnit);
        Result result = this.executeRequest(req);
        OperationExecutionException exception = result.getExecuteException(operations);
        if (exception != null) {
            throw exception;
        }
        return result.getExecuteResult();
    }

    @Override
    public OperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    @Override
    public void close() {
        this.dispatcher.shutdown(null);
    }

    private Request makeWriteRequest(InternalOperation op, PartitionId partitionId, Durability durability, long timeout, TimeUnit timeoutUnit) {
        return this.makeRequest(op, partitionId, true, durability != null ? durability : this.defaultDurability, null, timeout, timeoutUnit);
    }

    private Request makeReadRequest(InternalOperation op, PartitionId partitionId, Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        return this.makeRequest(op, partitionId, false, null, consistency != null ? consistency : this.defaultConsistency, timeout, timeoutUnit);
    }

    private Request makeRequest(InternalOperation op, PartitionId partitionId, boolean write, Durability durability, Consistency consistency, long timeout, TimeUnit timeoutUnit) {
        int timeoutMs = timeout > 0L ? PropUtil.durationToMillis(timeout, timeoutUnit) : this.defaultTimeoutMs;
        return new Request(op, partitionId, write, durability, consistency, DEFAULT_TTL, this.dispatcher.getTopologyManager().getTopology().getSequenceNumber(), this.dispatcher.getDispatcherId(), timeoutMs);
    }

    protected Result executeRequest(Request request) throws FaultException {
        return this.dispatcher.execute(request).getResult();
    }

    @Override
    public KVStats getStats(boolean clear) {
        return new KVStats(clear, this.dispatcher);
    }

    private abstract class ArrayIterator<E>
    implements Iterator<E> {
        private E[] elements = null;
        private int nextElement = 0;

        private ArrayIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.elements != null && this.nextElement < this.elements.length) {
                return true;
            }
            this.elements = this.getMoreElements();
            if (this.elements == null) {
                return false;
            }
            assert (this.elements.length > 0);
            this.nextElement = 0;
            return true;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.nextElement++];
        }

        abstract E[] getMoreElements();
    }
}

