/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import com.sleepycat.je.utilint.PropUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.RequestLimitConfig;

public class KVStoreConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    private static final Consistency DEFAULT_CONSISTENCY = Consistency.NONE_REQUIRED;
    private static final Durability DEFAULT_DURABILITY = Durability.COMMIT_NO_SYNC;
    private String storeName;
    private String[] helperHosts;
    private int requestTimeout;
    private Consistency consistency;
    private Durability durability;
    private RequestLimitConfig requestLimitConfig;

    public KVStoreConfig(String storeName, String ... helperHostPort) {
        this.setStoreName(storeName);
        this.setHelperHosts(helperHostPort);
        this.requestTimeout = 5000;
        this.consistency = DEFAULT_CONSISTENCY;
        this.durability = DEFAULT_DURABILITY;
        this.requestLimitConfig = RequestLimitConfig.getDefault();
    }

    public KVStoreConfig clone() {
        try {
            return (KVStoreConfig)super.clone();
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
    }

    public KVStoreConfig setStoreName(String storeName) throws IllegalArgumentException {
        this.setStoreNameVoid(storeName);
        return this;
    }

    public void setStoreNameVoid(String storeName) throws IllegalArgumentException {
        if (storeName == null) {
            throw new IllegalArgumentException("Store name may not be null");
        }
        this.storeName = storeName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public KVStoreConfig setHelperHosts(String ... helperHostPort) throws IllegalArgumentException {
        this.setHelperHostsVoid(helperHostPort);
        return this;
    }

    public void setHelperHostsVoid(String ... helperHostPort) throws IllegalArgumentException {
        if (helperHostPort.length == 0) {
            throw new IllegalArgumentException("No helperHostPort specified");
        }
        for (String s : helperHostPort) {
            if (s != null) continue;
            throw new IllegalArgumentException("helperHostPort is null");
        }
        this.helperHosts = helperHostPort;
    }

    public String[] getHelperHosts() {
        return this.helperHosts;
    }

    public KVStoreConfig setRequestTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setRequestTimeoutVoid(timeout, unit);
        return this;
    }

    public void setRequestTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        if (timeout == 0L) {
            throw new IllegalArgumentException("Timeout may not be zero");
        }
        this.requestTimeout = PropUtil.durationToMillis(timeout, unit);
    }

    public long getRequestTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.requestTimeout, unit);
    }

    public KVStoreConfig setConsistency(Consistency consistency) throws IllegalArgumentException {
        this.setConsistencyVoid(consistency);
        return this;
    }

    public void setConsistencyVoid(Consistency consistency) throws IllegalArgumentException {
        if (consistency == null) {
            throw new IllegalArgumentException("Consistency may not be null");
        }
        this.consistency = consistency;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public KVStoreConfig setDurability(Durability durability) throws IllegalArgumentException {
        this.setDurabilityVoid(durability);
        return this;
    }

    public void setDurabilityVoid(Durability durability) throws IllegalArgumentException {
        if (durability == null) {
            throw new IllegalArgumentException("Durability may not be null");
        }
        this.durability = durability;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public KVStoreConfig setRequestLimit(RequestLimitConfig requestLimitConfig) {
        if (requestLimitConfig == null) {
            throw new IllegalArgumentException("requestLimitConfig may not be null");
        }
        this.requestLimitConfig = requestLimitConfig;
        return this;
    }

    public RequestLimitConfig getRequestLimit() {
        return this.requestLimitConfig;
    }

    public String toString() {
        return "<KVStoreConfig storeName=" + this.storeName + " helperHosts=" + Arrays.toString(this.helperHosts) + " requestTimeout=" + this.requestTimeout + " consistency=" + this.consistency + " durability=" + this.durability;
    }
}

