/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.utils.HTMLStyledTextParser;

public class SWTGraphicUtil {
    private SWTGraphicUtil() {
    }

    public static void dispose(Widget widget, final Resource resource) {
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTGraphicUtil.dispose(resource);
            }
        });
    }

    public static void dispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public static Color createDisposableColor(int n, int n2, int n3) {
        Display display = Display.getCurrent();
        final Color color = new Color((Device)display, n, n2, n3);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (!color.isDisposed()) {
                    color.dispose();
                }
            }
        });
        return color;
    }

    public static Image createImage(String string) {
        return new Image((Device)Display.getCurrent(), SWTGraphicUtil.class.getClassLoader().getResourceAsStream(string));
    }

    public static Image createReflectedImage(Image image) {
        int n;
        if (image == null) {
            return null;
        }
        if (image.isDisposed()) {
            SWT.error((int)24);
        }
        Rectangle rectangle = image.getBounds();
        Image image2 = new Image(image.getDevice(), new Rectangle(0, 0, rectangle.width, (int)((double)rectangle.height * 1.5)));
        GC gC = new GC((Drawable)image2);
        gC.setAdvanced(true);
        gC.drawImage(image, 0, 0);
        Transform transform = new Transform(image.getDevice());
        transform.setElements(1.0f, 0.0f, 0.0f, -0.5f, 0.0f, (float)(rectangle.height + rectangle.height / 2));
        gC.setTransform(transform);
        gC.drawImage(image, 0, 0);
        transform.dispose();
        gC.dispose();
        ImageData imageData = image2.getImageData();
        int n2 = imageData.width;
        int n3 = imageData.height;
        byte[] byArray = new byte[n3 * n2];
        byte[] byArray2 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray2[n] = -1;
        }
        for (n = 0; n < n3; ++n) {
            byte[] byArray3 = new byte[n2];
            if (n < rectangle.height) {
                System.arraycopy(byArray2, 0, byArray, n * n2, n2);
                continue;
            }
            for (int i = 0; i < n2; ++i) {
                byArray3[i] = (byte)(255 - 255 * n / n3);
            }
            System.arraycopy(byArray3, 0, byArray, n * n2, n2);
        }
        imageData.alphaData = byArray;
        return new Image(image.getDevice(), imageData);
    }

    public static Image resize(Image image, int n, int n2) {
        if (image == null) {
            return null;
        }
        if (image.isDisposed()) {
            SWT.error((int)24);
        }
        Image image2 = new Image(image.getDevice(), n, n2);
        GC gC = new GC((Drawable)image2);
        gC.setAntialias(1);
        gC.setInterpolation(2);
        gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, n, n2);
        gC.dispose();
        return image2;
    }

    public static Image createReflectedResizedImage(Image image, int n, int n2) {
        int n3;
        if (image == null) {
            return null;
        }
        if (image.isDisposed()) {
            SWT.error((int)24);
        }
        Image image2 = new Image(image.getDevice(), n, (int)((double)n2 * 1.5));
        GC gC = new GC((Drawable)image2);
        gC.setAntialias(1);
        gC.setInterpolation(2);
        gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, n, n2);
        Transform transform = new Transform(image.getDevice());
        transform.setElements(1.0f, 0.0f, 0.0f, -0.5f, 0.0f, (float)((double)n2 * 1.5));
        gC.setTransform(transform);
        gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, n, n2);
        transform.dispose();
        gC.dispose();
        ImageData imageData = image2.getImageData();
        int n4 = imageData.width;
        int n5 = imageData.height;
        byte[] byArray = new byte[n5 * n4];
        byte[] byArray2 = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray2[n3] = -1;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            byte[] byArray3 = new byte[n4];
            if (n3 < n2) {
                System.arraycopy(byArray2, 0, byArray, n3 * n4, n4);
                continue;
            }
            for (int i = 0; i < n4; ++i) {
                byArray3[i] = (byte)(255 - 255 * n3 / n5);
            }
            System.arraycopy(byArray3, 0, byArray, n3 * n4, n4);
        }
        imageData.alphaData = byArray;
        return new Image(image.getDevice(), imageData);
    }

    public static void centerShell(Shell shell) {
        Monitor monitor = shell.getDisplay().getPrimaryMonitor();
        Rectangle rectangle = monitor.getBounds();
        Rectangle rectangle2 = shell.getBounds();
        int n = rectangle.x + (rectangle.width - rectangle2.width) / 2;
        int n2 = rectangle.y + (rectangle.height - rectangle2.height) / 2;
        shell.setLocation(n, n2);
    }

    public static void applyHTMLFormating(StyledText styledText) {
        try {
            new HTMLStyledTextParser(styledText).parse();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static ImageData blur(ImageData imageData, int n) {
        int n2;
        if (n < 1) {
            return imageData;
        }
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, 24, new PaletteData(255, 65280, 0xFF0000));
        if (n >= imageData2.height || n >= imageData2.width) {
            n = Math.min(imageData2.height, imageData2.width) - 1;
        }
        ArrayList<RGB[]> arrayList = new ArrayList<RGB[]>();
        int n3 = n * 2 + 1 > imageData2.height ? imageData2.height : n * 2 + 1;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            arrayList.add(arrayList.size(), SWTGraphicUtil.blurRow(imageData, i, n));
        }
        RGB[] rGBArray = new RGB[imageData2.width];
        int[] nArray = new int[imageData2.width];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < imageData2.width; ++n2) {
            rGBArray[n2] = new RGB(0, 0, 0);
        }
        while (n6 < imageData2.height) {
            if (n7 < imageData2.height) {
                do {
                    for (n2 = 0; n2 < imageData2.width; ++n2) {
                        rGBArray[n2].red += ((RGB[])arrayList.get((int)(n7 - n4)))[n2].red;
                        rGBArray[n2].green += ((RGB[])arrayList.get((int)(n7 - n4)))[n2].green;
                        rGBArray[n2].blue += ((RGB[])arrayList.get((int)(n7 - n4)))[n2].blue;
                    }
                    ++n8;
                    if (++n7 >= imageData2.height || n7 - n4 <= n * 2) continue;
                    arrayList.add(arrayList.size(), SWTGraphicUtil.blurRow(imageData, n7, n));
                } while (n7 <= n);
            }
            if (n6 - n5 > n) {
                for (n2 = 0; n2 < imageData2.width; ++n2) {
                    rGBArray[n2].red -= ((RGB[])arrayList.get((int)(n5 - n4)))[n2].red;
                    rGBArray[n2].green -= ((RGB[])arrayList.get((int)(n5 - n4)))[n2].green;
                    rGBArray[n2].blue -= ((RGB[])arrayList.get((int)(n5 - n4)))[n2].blue;
                }
                --n8;
                ++n5;
                arrayList.remove(0);
                ++n4;
            }
            for (n2 = 0; n2 < imageData2.width; ++n2) {
                nArray[n2] = imageData2.palette.getPixel(new RGB(rGBArray[n2].red / n8, rGBArray[n2].green / n8, rGBArray[n2].blue / n8));
            }
            imageData2.setPixels(0, n6, imageData2.width, nArray, 0);
            ++n6;
        }
        return imageData2;
    }

    private static RGB[] blurRow(ImageData imageData, int n, int n2) {
        RGB[] rGBArray = new RGB[imageData.width];
        int[] nArray = new int[imageData.width];
        imageData.getPixels(0, n, imageData.width, nArray, 0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            RGB rGB;
            if (n7 < nArray.length) {
                do {
                    rGB = imageData.palette.getRGB(nArray[n7]);
                    n3 += rGB.red;
                    n4 += rGB.green;
                    n5 += rGB.blue;
                    ++n8;
                } while (++n7 <= n2);
            }
            if (i - n6 > n2) {
                rGB = imageData.palette.getRGB(nArray[n6]);
                n3 -= rGB.red;
                n4 -= rGB.green;
                n5 -= rGB.blue;
                --n8;
                ++n6;
            }
            rGBArray[i] = new RGB(n3 / n8, n4 / n8, n5 / n8);
        }
        return rGBArray;
    }

    public static void enable(Control control, boolean bl) {
        if (control instanceof Composite) {
            for (Control control2 : ((Composite)control).getChildren()) {
                SWTGraphicUtil.enable(control2, bl);
            }
        }
        control.setEnabled(bl);
    }

    public static Font buildFontFrom(Control control, int n) {
        Font font = control.getFont();
        FontData[] fontDataArray = font.getFontData();
        if (fontDataArray == null || fontDataArray.length == 0) {
            return font;
        }
        return new Font((Device)control.getDisplay(), fontDataArray[0].getName(), fontDataArray[0].getHeight(), n);
    }

    public static Font buildFontFrom(Control control, int n, int n2) {
        Font font = control.getFont();
        FontData[] fontDataArray = font.getFontData();
        if (fontDataArray == null || fontDataArray.length == 0) {
            return font;
        }
        return new Font((Device)control.getDisplay(), fontDataArray[0].getName(), n2, n);
    }
}

