/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class HTMLStyledTextParser {
    private final StyledText styledText;

    HTMLStyledTextParser(StyledText styledText) {
        this.styledText = styledText;
    }

    public void parse() throws IOException {
        if (this.styledText == null || "".equals(this.styledText.getText().trim())) {
            return;
        }
        String string = this.styledText.getText().trim();
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
        LinkedList<StyleRange> linkedList = new LinkedList<StyleRange>();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            StyleRange styleRange;
            String string2 = i <= n2 - 4 ? string.substring(i, i + 3).toLowerCase() : null;
            String string3 = i <= n2 - 4 ? string.substring(i, i + 4).toLowerCase() : null;
            String string4 = i <= n2 - 5 ? string.substring(i, i + 5).toLowerCase() : null;
            if (string2 != null) {
                if ("<b>".equalsIgnoreCase(string2)) {
                    styleRange = new StyleRange();
                    styleRange.start = n;
                    styleRange.length = 0;
                    styleRange.fontStyle = 1;
                    linkedList.push(styleRange);
                    i += 2;
                    continue;
                }
                if ("<i>".equalsIgnoreCase(string2)) {
                    styleRange = new StyleRange();
                    styleRange.start = n;
                    styleRange.length = 0;
                    styleRange.fontStyle = 2;
                    linkedList.push(styleRange);
                    i += 2;
                    continue;
                }
                if ("<u>".equalsIgnoreCase(string2)) {
                    styleRange = new StyleRange();
                    styleRange.start = n;
                    styleRange.length = 0;
                    styleRange.fontStyle = 0;
                    styleRange.underline = true;
                    linkedList.push(styleRange);
                    i += 2;
                    continue;
                }
            }
            if (string3 != null) {
                if ("</b>".equalsIgnoreCase(string3)) {
                    styleRange = (StyleRange)linkedList.pop();
                    if ((styleRange.fontStyle & 1) == 0) {
                        StringBuilder stringBuilder2 = new StringBuilder();
                        stringBuilder2.append("Error at position #").append(n).append(" - closing </b> tag found but ");
                        if ((styleRange.fontStyle & 2) != 0) {
                            stringBuilder2.append("</i>");
                        } else {
                            stringBuilder2.append("</u>");
                        }
                        stringBuilder2.append(" tag expected !");
                        throw new RuntimeException(stringBuilder2.toString());
                    }
                    styleRange.length = n - styleRange.start;
                    arrayList.add(styleRange);
                    i += 3;
                    continue;
                }
                if ("</i>".equalsIgnoreCase(string3)) {
                    styleRange = (StyleRange)linkedList.pop();
                    if ((styleRange.fontStyle & 2) == 0) {
                        StringBuilder stringBuilder3 = new StringBuilder();
                        stringBuilder3.append("Error at position #").append(n).append(" - closing </i> tag found but ");
                        if ((styleRange.fontStyle & 1) != 0) {
                            stringBuilder3.append("</b>");
                        } else {
                            stringBuilder3.append("</u>");
                        }
                        stringBuilder3.append(" tag expected !");
                        throw new RuntimeException(stringBuilder3.toString());
                    }
                    styleRange.length = n - styleRange.start;
                    arrayList.add(styleRange);
                    i += 3;
                    continue;
                }
                if ("</u>".equalsIgnoreCase(string3)) {
                    styleRange = (StyleRange)linkedList.pop();
                    if (!styleRange.underline) {
                        StringBuilder stringBuilder4 = new StringBuilder();
                        stringBuilder4.append("Error at position #").append(n).append(" - closing </u> tag found but ");
                        if ((styleRange.fontStyle & 2) != 0) {
                            stringBuilder4.append("</i>");
                        } else {
                            stringBuilder4.append("</b>");
                        }
                        stringBuilder4.append(" tag expected !");
                        throw new RuntimeException(stringBuilder4.toString());
                    }
                    styleRange.length = n - styleRange.start;
                    arrayList.add(styleRange);
                    i += 3;
                    continue;
                }
            }
            if (string4 != null && "<br/>".equalsIgnoreCase(string4)) {
                stringBuilder.append("\n");
                i += 4;
                continue;
            }
            ++n;
            stringBuilder.append(string.substring(i, i + 1));
        }
        this.styledText.setText(stringBuilder.toString());
        this.styledText.setStyleRanges(arrayList.toArray(new StyleRange[arrayList.size()]));
    }
}

