/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.transitionComposite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.transitionComposite.TRANSITIONS;
import org.mihalis.opal.transitionComposite.Transition;
import org.mihalis.opal.transitionComposite.TransitionFactory;

public class TransitionComposite
extends Composite {
    private final List<Control> controls;
    private int selection = 0;
    private TRANSITIONS transition = TRANSITIONS.NONE;

    public TransitionComposite(Composite composite, int n) {
        super(composite, n);
        this.controls = new ArrayList<Control>();
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ((Control)TransitionComposite.this.controls.get(TransitionComposite.this.selection)).setBounds(TransitionComposite.this.getClientArea());
            }
        });
    }

    public void addControl(Control control) {
        this.checkWidget();
        this.controls.add(control);
        if (this.controls.size() == 1) {
            control.setVisible(true);
        } else {
            control.setVisible(false);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        for (Control control : this.controls) {
            Point point = control.computeSize(n, n2, bl);
            n3 = Math.max(n3, point.x);
            n4 = Math.max(n4, point.y);
        }
        return new Point(Math.max(n3, n), Math.max(n4, n2));
    }

    public TRANSITIONS getTransition() {
        this.checkWidget();
        return this.transition;
    }

    public void moveToFirst() {
        this.checkWidget();
        this.changeSelectionTo(0);
    }

    public void moveToLast() {
        this.checkWidget();
        this.changeSelectionTo(this.controls.size() - 1);
    }

    public void moveToNext() {
        this.checkWidget();
        int n = this.selection + 1;
        if (n == this.controls.size()) {
            return;
        }
        this.changeSelectionTo(n);
    }

    public void moveToPrevious() {
        this.checkWidget();
        int n = this.selection - 1;
        if (n < 0) {
            return;
        }
        this.changeSelectionTo(n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n > this.controls.size() - 1) {
            return;
        }
        this.changeSelectionTo(n);
    }

    private void changeSelectionTo(int n) {
        Transition transition = TransitionFactory.getTransitionFor(this.transition);
        transition.performTransition(this.controls.get(this.selection), this.controls.get(n));
        this.selection = n;
        this.controls.get(this.selection).setBounds(this.getClientArea());
    }

    public void setSelection(Control control) {
        this.checkWidget();
        for (int i = 0; i < this.controls.size(); ++i) {
            if (this.controls.get(i) == null || !this.controls.get(i).equals(control)) continue;
            this.changeSelectionTo(i);
            return;
        }
    }

    public void setTransition(TRANSITIONS tRANSITIONS) {
        this.checkWidget();
        this.transition = tRANSITIONS;
    }
}

