/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.titledSeparator;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class TitledSeparator
extends Composite {
    private int alignment = 16384;
    private Image image;
    private String text;

    public TitledSeparator(Composite composite, int n) {
        super(composite, n);
        Font font;
        final Color color = new Color((Device)this.getDisplay(), 0, 88, 150);
        this.setForeground(color);
        FontData[] fontDataArray = this.getFont().getFontData();
        if (fontDataArray != null && fontDataArray.length > 0) {
            FontData fontData = fontDataArray[0];
            fontData.setStyle(1);
            font = new Font((Device)this.getDisplay(), fontData);
            this.setFont(font);
        } else {
            font = null;
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TitledSeparator.this.redrawComposite();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)color);
                SWTGraphicUtil.dispose((Resource)font);
            }
        });
    }

    private void redrawComposite() {
        for (Control control : this.getChildren()) {
            control.dispose();
        }
        int n = 1;
        if (this.text != null) {
            ++n;
        }
        if (this.image != null) {
            ++n;
        }
        if (this.alignment == 0x1000000) {
            ++n;
        }
        super.setLayout((Layout)new GridLayout(n, false));
        this.createContent();
    }

    private void createContent() {
        switch (this.alignment) {
            case 0x1000000: {
                this.createSeparator();
                this.createTitle();
                break;
            }
            case 16384: {
                this.createTitle();
                this.createSeparator();
                break;
            }
            default: {
                this.createSeparator();
                this.createTitle();
            }
        }
    }

    private void createSeparator() {
        Label label = new Label((Composite)this, 258);
        label.setLayoutData((Object)new GridData(4, 2, true, false));
        label.setBackground(this.getBackground());
    }

    private void createTitle() {
        Label label;
        if (this.image != null) {
            label = this.createLabel();
            label.setImage(this.image);
        }
        if (this.text != null && !this.text.trim().equals("")) {
            label = this.createLabel();
            label.setText(this.text);
        }
    }

    private Label createLabel() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        label.setFont(this.getFont());
        label.setForeground(this.getForeground());
        label.setBackground(this.getBackground());
        return label;
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Not supported");
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this.alignment = n;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public void setText(String string) {
        this.checkWidget();
        this.text = string;
    }
}

