/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.textAssist;

import java.util.List;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.textAssist.TextAssistContentProvider;

public class TextAssist
extends Composite {
    private static final String SETTEXT_KEY = "org.mihalis.opal.textAssist.TextAssist.settext";
    private final Text text;
    private final Shell popup;
    private final Table table;
    private TextAssistContentProvider contentProvider;
    private int numberOfLines;

    public TextAssist(Composite composite, int n, TextAssistContentProvider textAssistContentProvider) {
        super(composite, 0);
        this.contentProvider = textAssistContentProvider;
        this.contentProvider.setTextAssist(this);
        this.setLayout((Layout)new FillLayout());
        this.numberOfLines = 10;
        this.text = new Text((Composite)this, n);
        this.popup = new Shell(this.getDisplay(), 16384);
        this.popup.setLayout((Layout)new FillLayout());
        this.table = new Table((Composite)this.popup, 4);
        this.text.addListener(1, this.createKeyDownListener());
        this.text.addListener(24, this.createModifyListener());
        this.text.addListener(16, this.createFocusOutListener());
        this.table.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                TextAssist.this.text.setText(TextAssist.this.table.getSelection()[0].getText());
                TextAssist.this.popup.setVisible(false);
            }
        });
        this.table.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    TextAssist.this.popup.setVisible(false);
                }
            }
        });
        this.table.addListener(16, this.createFocusOutListener());
        this.getShell().addListener(10, new Listener(){

            public void handleEvent(Event event) {
                TextAssist.this.popup.setVisible(false);
            }
        });
    }

    private Listener createKeyDownListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 0x1000002: {
                        int n = (TextAssist.this.table.getSelectionIndex() + 1) % TextAssist.this.table.getItemCount();
                        TextAssist.this.table.setSelection(n);
                        event.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        int n = TextAssist.this.table.getSelectionIndex() - 1;
                        if (n < 0) {
                            n = TextAssist.this.table.getItemCount() - 1;
                        }
                        TextAssist.this.table.setSelection(n);
                        event.doit = false;
                        break;
                    }
                    case 13: {
                        if (!TextAssist.this.popup.isVisible() || TextAssist.this.table.getSelectionIndex() == -1) break;
                        TextAssist.this.text.setText(TextAssist.this.table.getSelection()[0].getText());
                        TextAssist.this.popup.setVisible(false);
                        break;
                    }
                    case 27: {
                        TextAssist.this.popup.setVisible(false);
                    }
                }
            }
        };
    }

    private Listener createModifyListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (TextAssist.this.text.getData(TextAssist.SETTEXT_KEY) != null && Boolean.TRUE.equals(TextAssist.this.text.getData(TextAssist.SETTEXT_KEY))) {
                    TextAssist.this.text.setData(TextAssist.SETTEXT_KEY, null);
                    return;
                }
                TextAssist.this.text.setData(TextAssist.SETTEXT_KEY, null);
                String string = TextAssist.this.text.getText();
                if (string.length() == 0) {
                    TextAssist.this.popup.setVisible(false);
                    return;
                }
                List<String> list = TextAssist.this.contentProvider.getContent(string);
                if (list == null || list.isEmpty()) {
                    TextAssist.this.popup.setVisible(false);
                    return;
                }
                if (list.size() > TextAssist.this.numberOfLines) {
                    list = list.subList(0, TextAssist.this.numberOfLines);
                }
                TextAssist.this.table.removeAll();
                int n = Math.min(list.size(), TextAssist.this.numberOfLines);
                for (int i = 0; i < n; ++i) {
                    TableItem tableItem = new TableItem(TextAssist.this.table, 0);
                    tableItem.setText(list.get(i));
                }
                Point point = TextAssist.this.text.toDisplay(((TextAssist)TextAssist.this).text.getLocation().x, ((TextAssist)TextAssist.this).text.getSize().y + TextAssist.this.text.getBorderWidth() - 3);
                int n2 = point.x;
                int n3 = point.y;
                Rectangle rectangle = TextAssist.this.getMonitor().getClientArea();
                Rectangle rectangle2 = TextAssist.this.getDisplay().map((Control)TextAssist.this.getParent(), null, TextAssist.this.getBounds());
                TextAssist.this.popup.pack();
                int n4 = ((TextAssist)TextAssist.this).popup.getBounds().width;
                int n5 = ((TextAssist)TextAssist.this).popup.getBounds().height;
                if (n3 + n5 > rectangle.y + rectangle.height) {
                    n3 = rectangle2.y - n5;
                }
                if (n2 + n4 > rectangle.x + rectangle.width) {
                    n2 = rectangle.x + rectangle.width - n4;
                }
                TextAssist.this.popup.setLocation(n2, n3);
                TextAssist.this.popup.setVisible(true);
            }
        };
    }

    private Listener createFocusOutListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TextAssist.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TextAssist.this.isDisposed() || TextAssist.this.getDisplay().isDisposed()) {
                            return;
                        }
                        Control control = TextAssist.this.getDisplay().getFocusControl();
                        if (control == null || control != TextAssist.this.text && control != TextAssist.this.table) {
                            TextAssist.this.popup.setVisible(false);
                        }
                    }
                });
            }
        };
    }

    public Color getBackground() {
        this.checkWidget();
        return this.text.getBackground();
    }

    public TextAssistContentProvider getContentProvider() {
        this.checkWidget();
        return this.contentProvider;
    }

    public Color getForeground() {
        this.checkWidget();
        return super.getForeground();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.text.setBackground(color);
    }

    public void setContentProvider(TextAssistContentProvider textAssistContentProvider) {
        this.checkWidget();
        this.contentProvider = textAssistContentProvider;
    }

    public int getNumberOfLines() {
        this.checkWidget();
        return this.numberOfLines;
    }

    public void setNumberOfLines(int n) {
        this.checkWidget();
        this.numberOfLines = n;
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        this.text.addListener(n, listener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.text.addModifyListener(modifyListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.text.addSelectionListener(selectionListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        this.text.addVerifyListener(verifyListener);
    }

    public void append(String string) {
        this.checkWidget();
        this.text.append(string);
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        return this.text.computeSize(n, n2, bl);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        return super.computeTrim(n, n2, n3, n4);
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return this.text.getCaretLineNumber();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return this.text.getCaretLocation();
    }

    public int getCaretPosition() {
        this.checkWidget();
        return this.text.getCaretPosition();
    }

    public int getCharCount() {
        this.checkWidget();
        return this.text.getCharCount();
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.text.getDoubleClickEnabled();
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.text.getEchoChar();
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return super.getEnabled();
    }

    public int getLineCount() {
        this.checkWidget();
        return this.text.getLineCount();
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.text.getLineDelimiter();
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public String getMessage() {
        this.checkWidget();
        return this.text.getMessage();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.text.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.text.getSelectionCount();
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.text.getSelectionText();
    }

    public int getTabs() {
        this.checkWidget();
        return this.text.getTabs();
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        return this.text.getText(n, n2);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.text.getTopIndex();
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.text.getTopPixel();
    }

    public void insert(String string) {
        this.checkWidget();
        this.text.insert(string);
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.text.removeModifyListener(modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.text.removeSelectionListener(selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        this.text.removeVerifyListener(verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        this.text.selectAll();
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.text.setDoubleClickEnabled(bl);
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        this.text.setEchoChar(c);
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.text.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.text.setEnabled(bl);
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.text.setFont(font);
        this.table.setFont(font);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.text.setForeground(color);
    }

    public void setMessage(String string) {
        this.checkWidget();
        this.text.setMessage(string);
    }

    public void setOrientation(int n) {
        this.checkWidget();
        this.text.setOrientation(n);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        this.text.setRedraw(bl);
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.text.setSelection(n, n2);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.text.setSelection(n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        this.text.setSelection(point);
    }

    public void setTabs(int n) {
        this.checkWidget();
        this.text.setTabs(n);
    }

    public void setText(String string) {
        this.checkWidget();
        this.text.setData(SETTEXT_KEY, (Object)Boolean.TRUE);
        this.text.setText(string);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        this.text.setTextLimit(n);
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        this.text.setTopIndex(n);
    }

    public void showSelection() {
        this.checkWidget();
        this.text.showSelection();
    }
}

