/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.systemMonitor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.mihalis.opal.systemMonitor.Sample;
import org.mihalis.opal.systemMonitor.SampleFactory;
import org.mihalis.opal.systemMonitor.SampleIdentifier;
import org.mihalis.opal.systemMonitor.SampleWrapper;

public class SystemMonitor
extends Canvas {
    private final Map<String, SampleWrapper> samples = new LinkedHashMap<String, SampleWrapper>();
    private boolean captionVisible = true;
    private GC gc;
    private final Color borderColor = new Color((Device)this.getDisplay(), 96, 96, 96);
    private final Color gridColorBackground;
    private final Color gridColor = new Color((Device)this.getDisplay(), 89, 89, 89);
    private final int gridSize;
    private final int refreshTime;
    private boolean keepRunning = true;

    public SystemMonitor(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.gridColorBackground = new Color((Device)this.getDisplay(), 50, 50, 50);
        this.gridSize = 12;
        this.refreshTime = 300;
        this.createListeners();
        this.launchDataCollecting();
    }

    private void createListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                SystemMonitor.this.paintControl(paintEvent);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SystemMonitor.this.borderColor.dispose();
                SystemMonitor.this.gridColor.dispose();
                SystemMonitor.this.gridColorBackground.dispose();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                for (SampleWrapper sampleWrapper : SystemMonitor.this.samples.values()) {
                    sampleWrapper.resize(SystemMonitor.this.getClientArea().width / SystemMonitor.this.gridSize - 1);
                }
            }
        });
    }

    private void paintControl(PaintEvent paintEvent) {
        this.gc = paintEvent.gc;
        paintEvent.gc.setAdvanced(true);
        paintEvent.gc.setAntialias(1);
        this.drawBackground();
        this.drawGrid();
        for (SampleWrapper sampleWrapper : this.samples.values()) {
            this.drawData(sampleWrapper);
        }
        if (this.captionVisible && this.samples.size() == 1) {
            this.drawCaption();
        }
    }

    private void drawBackground() {
        Rectangle rectangle = this.getClientArea();
        this.gc.setForeground(this.borderColor);
        this.gc.setBackground(this.getDisplay().getSystemColor(2));
        this.gc.fillRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 5, 5);
        this.gc.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 5, 5);
    }

    private void drawGrid() {
        int n;
        Rectangle rectangle = this.getClientArea();
        this.gc.setClipping(rectangle.x + 3, rectangle.y + 3, rectangle.width - 6, rectangle.height - 6);
        this.gc.setForeground(this.gridColor);
        this.gc.setBackground(this.gridColorBackground);
        this.gc.fillRectangle(this.getClientArea());
        for (n = this.gridSize / 2; n < rectangle.x + rectangle.width; n += this.gridSize) {
            this.gc.drawLine(n, rectangle.x, n, rectangle.height);
        }
        for (n = this.gridSize / 2; n < rectangle.y + rectangle.height; n += this.gridSize) {
            this.gc.drawLine(rectangle.x, n, rectangle.width, n);
        }
        this.gc.setAlpha(180);
        this.gc.setBackground(this.getDisplay().getSystemColor(2));
        this.gc.fillRoundRectangle(rectangle.x + 10, rectangle.y + 10, rectangle.width + 20, rectangle.width + 20, 5, 5);
        this.gc.setAlpha(255);
        this.gc.setClipping(rectangle);
    }

    private void drawData(SampleWrapper sampleWrapper) {
        int n;
        List<Double> list = sampleWrapper.getData();
        if (list == null || list.size() < 2) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        double d = sampleWrapper.getMaxValue();
        this.gc.setClipping(rectangle);
        Color color = new Color((Device)this.getDisplay(), sampleWrapper.getBorderColor());
        Color color2 = new Color((Device)this.getDisplay(), sampleWrapper.getColor());
        int[] nArray = new int[2 * (list.size() + 2)];
        int n2 = rectangle.width - this.gridSize;
        int n3 = (int)((float)(rectangle.height - this.gridSize) * 0.98f);
        nArray[0] = n = this.gridSize / 2 + n2 - (list.size() - 1) * this.gridSize;
        nArray[1] = rectangle.y + rectangle.height + this.gridSize / 2 - (this.captionVisible ? 25 : 0);
        int n4 = 2;
        double d2 = -1.0;
        for (Double d3 : list) {
            nArray[n4++] = n;
            nArray[n4++] = rectangle.height - (int)((double)(this.gridSize / 2) + (double)n3 * d3 / d);
            n += this.gridSize;
            d2 = Math.max(d2, d3);
        }
        nArray[n4++] = n - this.gridSize;
        nArray[n4++] = rectangle.y + rectangle.height + this.gridSize / 2 - (this.captionVisible ? 25 : 0);
        this.gc.setAlpha(this.samples.size() == 1 ? 210 : 150);
        Region region = new Region((Device)this.getDisplay());
        region.add(nArray);
        this.gc.setClipping(region);
        this.gc.setForeground(color);
        this.gc.setBackground(this.getDisplay().getSystemColor(2));
        this.gc.fillGradientRectangle(this.gridSize / 2, rectangle.height - (int)((double)(this.gridSize / 2) + (double)n3 * d2 / d), n2, (int)((double)n3 * d2 / d), true);
        this.gc.setClipping(rectangle);
        this.gc.setForeground(color);
        this.gc.drawPolygon(nArray);
        region.dispose();
        color.dispose();
        color2.dispose();
        this.gc.setAlpha(255);
    }

    private void drawCaption() {
        for (SampleWrapper sampleWrapper : this.samples.values()) {
            if (sampleWrapper.getCaption() == null || sampleWrapper.getCaption().equals("")) continue;
            this.drawCaptionForSample(sampleWrapper);
            return;
        }
    }

    private void drawCaptionForSample(SampleWrapper sampleWrapper) {
        Font font;
        Rectangle rectangle = this.getClientArea();
        this.gc.setClipping(rectangle);
        this.gc.setBackground(this.getDisplay().getSystemColor(2));
        this.gc.fillRectangle(rectangle.x, rectangle.y + rectangle.height - 19, rectangle.width, 19);
        Color color = new Color((Device)this.getDisplay(), sampleWrapper.getBorderColor());
        this.gc.setForeground(color);
        for (FontData fontData : font = this.getFont().getFontData()) {
            fontData.setHeight(9);
        }
        Font font2 = new Font((Device)this.getDisplay(), (FontData[])font);
        this.gc.setFont(this.getFont());
        String string = sampleWrapper.getFormatPattern().replace("{value}", "1$").replace("{maxValue}", "2$").replace("{percentValue}", "3$");
        String string2 = String.format(string, (double)sampleWrapper.getLastValue(), (double)sampleWrapper.getLastMaxValue(), sampleWrapper.getLastValue() / sampleWrapper.getLastMaxValue() * 100.0);
        this.gc.drawString(sampleWrapper.getCaption() + " : " + string2, rectangle.x + this.gridSize, rectangle.y + rectangle.height - 19);
        font2.dispose();
        color.dispose();
    }

    private void launchDataCollecting() {
        this.getDisplay().timerExec(this.refreshTime, new Runnable(){

            @Override
            public void run() {
                SystemMonitor.this.collect();
                if (!SystemMonitor.this.isDisposed() && SystemMonitor.this.keepRunning && !SystemMonitor.this.getDisplay().isDisposed()) {
                    SystemMonitor.this.getDisplay().timerExec(SystemMonitor.this.refreshTime, (Runnable)this);
                }
            }
        });
    }

    private void collect() {
        for (SampleWrapper sampleWrapper : this.samples.values()) {
            sampleWrapper.collect();
        }
        if (!this.isDisposed() && !this.getDisplay().isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!SystemMonitor.this.isDisposed()) {
                        SystemMonitor.this.redraw();
                    }
                }
            });
        }
    }

    public SystemMonitor(Composite composite, int n, SampleIdentifier sampleIdentifier) {
        this(composite, n);
        SampleWrapper sampleWrapper = SampleFactory.getInstance().getSample(sampleIdentifier);
        this.addSample(sampleIdentifier.name(), sampleWrapper);
        this.captionVisible = !sampleWrapper.getCaption().trim().equals("");
    }

    public void addSample(String string, Sample sample) {
        this.samples.put(string, new SampleWrapper(sample));
    }

    private void addSample(String string, SampleWrapper sampleWrapper) {
        this.samples.put(string, sampleWrapper);
    }

    public void displayAll() {
        this.samples.clear();
        this.addSample(SampleIdentifier.CPU_USAGE.name(), SampleFactory.getInstance().getSample(SampleIdentifier.CPU_USAGE));
        this.addSample(SampleIdentifier.HEAP_MEMORY.name(), SampleFactory.getInstance().getSample(SampleIdentifier.HEAP_MEMORY));
        this.addSample(SampleIdentifier.PHYSICAL_MEMORY.name(), SampleFactory.getInstance().getSample(SampleIdentifier.PHYSICAL_MEMORY));
        this.addSample(SampleIdentifier.THREADS.name(), SampleFactory.getInstance().getSample(SampleIdentifier.THREADS));
    }

    public boolean isCaptionVisible() {
        return this.captionVisible;
    }

    public void setCaption(String string, String string2) {
        if (!this.samples.containsKey(string)) {
            SWT.error((int)5);
        }
        this.samples.get(string).setCaption(string2);
    }

    public void setCaptionVisible(boolean bl) {
        this.captionVisible = bl;
    }

    public void setColor(String string, RGB rGB) {
        if (!this.samples.containsKey(string)) {
            SWT.error((int)5);
        }
        this.samples.get(string).setColor(rGB);
    }

    public void setFormatPattern(String string, String string2) {
        if (!this.samples.containsKey(string)) {
            SWT.error((int)5);
        }
        this.samples.get(string).setFormatPattern(string2);
    }

    public void stop() {
        this.keepRunning = false;
    }
}

