/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.propertyTable;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.mihalis.opal.propertyTable.AbstractPTWidget;
import org.mihalis.opal.propertyTable.PTProperty;
import org.mihalis.opal.propertyTable.editor.PTStringEditor;
import org.mihalis.opal.utils.ResourceManager;
import org.mihalis.opal.utils.StringUtil;

public class PTWidgetTree
extends AbstractPTWidget {
    private Tree tree;

    @Override
    protected void buildWidget(Composite composite) {
        this.tree = new Tree(composite, 65536);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        final TreeColumn treeColumn = new TreeColumn(this.tree, 0);
        treeColumn.setText(ResourceManager.getLabel("property"));
        final TreeColumn treeColumn2 = new TreeColumn(this.tree, 0);
        treeColumn2.setText(ResourceManager.getLabel("value"));
        this.fillData();
        this.tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = PTWidgetTree.this.tree.getParent().getClientArea();
                Point point = PTWidgetTree.this.tree.computeSize(-1, -1);
                ScrollBar scrollBar = PTWidgetTree.this.tree.getVerticalBar();
                int n = rectangle.width - ((PTWidgetTree)PTWidgetTree.this).tree.computeTrim((int)0, (int)0, (int)0, (int)0).width - scrollBar.getSize().x;
                if (point.y > rectangle.height + PTWidgetTree.this.tree.getHeaderHeight()) {
                    Point point2 = scrollBar.getSize();
                    n -= point2.x;
                }
                treeColumn.pack();
                treeColumn2.setWidth(n - treeColumn.getWidth());
                PTWidgetTree.this.tree.removeControlListener((ControlListener)this);
            }
        });
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PTWidgetTree.this.tree.getSelectionCount() == 0 || PTWidgetTree.this.tree.getSelection()[0] == null) {
                    return;
                }
                PTWidgetTree.this.updateDescriptionPanel(PTWidgetTree.this.tree.getSelection()[0].getData());
            }
        });
    }

    private void fillData() {
        String string;
        AbstractMap abstractMap = this.getParentPropertyTable().sorted ? new TreeMap() : new HashMap();
        for (PTProperty object : this.getParentPropertyTable().getPropertiesAsList()) {
            string = StringUtil.safeToString(object.getCategory());
            if (!abstractMap.containsKey(string)) {
                abstractMap.put(string, new ArrayList());
            }
            ((List)abstractMap.get(string)).add(object);
        }
        for (String string2 : abstractMap.keySet()) {
            if (abstractMap.get(string2) == null || ((List)abstractMap.get(string2)).isEmpty()) continue;
            string = new TreeItem(this.tree, 0);
            string.setText(0, string2);
            string.setBackground(string.getDisplay().getSystemColor(29));
            string.setForeground(string.getDisplay().getSystemColor(2));
            string.setExpanded(true);
            for (PTProperty pTProperty : (List)abstractMap.get(string2)) {
                TreeItem treeItem = new TreeItem((TreeItem)string, 0);
                treeItem.setData((Object)pTProperty);
                treeItem.setText(0, StringUtil.safeToString(pTProperty.getName()));
                if (pTProperty.getEditor() == null) {
                    pTProperty.setEditor(new PTStringEditor());
                }
                final ControlEditor controlEditor = pTProperty.getEditor().render(this, (Item)treeItem, pTProperty);
                treeItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        if (controlEditor.getEditor() != null) {
                            controlEditor.getEditor().dispose();
                        }
                        controlEditor.dispose();
                    }
                });
                if (!pTProperty.isEnabled()) {
                    treeItem.setForeground(treeItem.getDisplay().getSystemColor(15));
                }
                treeItem.setExpanded(true);
            }
            string.setExpanded(true);
        }
    }

    @Override
    public void refillData() {
        for (TreeItem treeItem : this.tree.getItems()) {
            treeItem.dispose();
        }
        this.fillData();
    }

    @Override
    public Composite getWidget() {
        return this.tree;
    }
}

