/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.promptSupport;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.promptSupport.PromptSupport;
import org.mihalis.opal.utils.SWTGraphicUtil;

abstract class BaseFocusControlListener
implements FocusListener,
ControlListener {
    protected Control control;
    private boolean firstDraw;
    private Font initialFont;
    private Color initialBackgroundColor;
    private Color initialForegroundColor;

    BaseFocusControlListener(Control control) {
        this.control = control;
        this.firstDraw = true;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isFilled()) {
            return;
        }
        this.applyInitialLook();
        if (PromptSupport.getFocusBehavior(this.control) == PromptSupport.FocusBehavior.HIDE_PROMPT) {
            this.hidePrompt();
        } else {
            this.highLightPrompt();
        }
    }

    private void applyInitialLook() {
        this.control.setFont(this.initialFont);
        this.control.setBackground(this.initialBackgroundColor);
        this.control.setForeground(this.initialForegroundColor);
    }

    protected abstract void hidePrompt();

    protected abstract void highLightPrompt();

    public void focusLost(FocusEvent focusEvent) {
        if (this.isFilled()) {
            return;
        }
        this.storeInitialLook();
        this.applyForegroundColor();
        this.applyBackgroundColor();
        this.applyFontStyle();
        this.fillPromptText();
    }

    protected abstract boolean isFilled();

    private void applyForegroundColor() {
        this.control.setForeground(PromptSupport.getForeground(this.control));
    }

    private void applyBackgroundColor() {
        this.control.setBackground(PromptSupport.getBackground(this.control));
    }

    private void applyFontStyle() {
        final Font font = SWTGraphicUtil.buildFontFrom(this.control, PromptSupport.getFontStyle(this.control));
        this.control.setFont(font);
        this.control.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)font);
            }
        });
    }

    protected abstract void fillPromptText();

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        if (this.firstDraw) {
            this.storeInitialLook();
            this.firstDraw = true;
            this.focusLost(null);
        }
    }

    private void storeInitialLook() {
        this.initialFont = this.control.getFont();
        this.initialBackgroundColor = this.control.getBackground();
        this.initialForegroundColor = this.control.getForeground();
    }
}

