/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class PWColorChooser
extends PWWidget {
    private Color color;

    public PWColorChooser(String string, String string2) {
        super(string, string2, string == null ? 1 : 2, false);
    }

    @Override
    public Control build(Composite composite) {
        RGB rGB = (RGB)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        this.color = rGB == null ? Display.getDefault().getSystemColor(1) : new Color((Device)Display.getDefault(), rGB);
        this.buildLabel(composite, 2);
        final Button button = new Button(composite, 8);
        this.addControl((Control)button);
        button.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                PWColorChooser.this.drawButton(button);
            }
        });
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorDialog colorDialog = new ColorDialog(button.getShell());
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    SWTGraphicUtil.dispose((Resource)PWColorChooser.this.color);
                    PWColorChooser.this.color = new Color((Device)button.getDisplay(), rGB);
                    PWColorChooser.this.drawButton(button);
                    PreferenceWindow.getInstance().setValue(PWColorChooser.this.getPropertyKey(), rGB);
                }
            }
        });
        button.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)PWColorChooser.this.color);
            }
        });
        return button;
    }

    protected void drawButton(Button button) {
        int n = (int)button.getFont().getFontData()[0].height;
        int n2 = button.getBounds().width - 16;
        Image image = new Image((Device)button.getDisplay(), Math.max(1, n2), Math.max(1, n));
        GC gC = new GC((Drawable)image);
        gC.setBackground(this.color);
        gC.fillRectangle(0, 0, n2, n);
        gC.setForeground(button.getDisplay().getSystemColor(2));
        gC.drawRectangle(0, 0, n2 - 1, n - 1);
        gC.dispose();
        button.setImage(image);
    }

    @Override
    public void check() {
        Object object = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (object == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), null);
        } else if (!(object instanceof RGB)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a RGB because it is associated to a color chooser");
        }
    }
}

