/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.opalDialog.ChoiceItem;
import org.mihalis.opal.opalDialog.ChoiceWidget;
import org.mihalis.opal.opalDialog.Dialog;
import org.mihalis.opal.opalDialog.DialogArea;
import org.mihalis.opal.utils.ReadOnlyStyledText;
import org.mihalis.opal.utils.SWTGraphicUtil;
import org.mihalis.opal.utils.StringUtil;

public class MessageArea
extends DialogArea {
    private Composite composite;
    private String title;
    private Image icon;
    private String text;
    private int radioChoice = -1;
    private int radioDefaultSelection;
    private String[] radioValues;
    private Throwable exception;
    private Text textException;
    private String textBoxValue;
    private int choice = -1;
    private int choiceDefaultSelection;
    private ChoiceItem[] choiceValues;
    private ProgressBar progressBar;
    private int progressBarMinimumValue;
    private int progressBarMaximumValue;
    private int progressBarValue = -1;
    private boolean verticalScrollbar = false;
    private int height = -1;

    public MessageArea(Dialog dialog) {
        super(dialog);
    }

    public MessageArea addChoice(int n, ChoiceItem ... choiceItemArray) {
        this.setInitialised(true);
        this.choiceDefaultSelection = n;
        this.choiceValues = choiceItemArray;
        return this;
    }

    public MessageArea addRadioButtons(int n, String ... stringArray) {
        this.setInitialised(true);
        this.radioDefaultSelection = n;
        this.radioValues = stringArray;
        return this;
    }

    public MessageArea addTextBox(String string) {
        this.setInitialised(true);
        this.textBoxValue = string;
        return this;
    }

    public MessageArea addProgressBar(int n, int n2, int n3) {
        this.setInitialised(true);
        this.progressBarMinimumValue = n;
        this.progressBarMaximumValue = n2;
        this.progressBarValue = n3;
        return this;
    }

    @Override
    public void render() {
        int n;
        if (!this.isInitialised()) {
            return;
        }
        this.composite = new Composite((Composite)this.parent.shell, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.setBackground(this.composite.getDisplay().getSystemColor(1));
        boolean bl = this.icon != null;
        boolean bl2 = !StringUtil.isEmpty(this.title);
        boolean bl3 = !StringUtil.isEmpty(this.text);
        boolean bl4 = this.radioValues != null;
        boolean bl5 = this.exception != null;
        boolean bl6 = this.textBoxValue != null;
        boolean bl7 = this.choiceValues != null;
        boolean bl8 = this.progressBarValue != -1;
        int n2 = bl ? 2 : 1;
        int n3 = n = bl2 && bl3 ? 2 : 1;
        if (bl4) {
            n += this.radioValues.length;
        }
        if (bl7) {
            n += this.choiceValues.length;
        }
        if (bl5 || bl6) {
            ++n;
        }
        if (bl8) {
            ++n;
        }
        GridLayout gridLayout = new GridLayout(n2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        this.composite.setLayout((Layout)gridLayout);
        if (bl) {
            this.createIcon(n);
        }
        if (bl2) {
            this.createTitle(bl);
        }
        if (bl3) {
            this.createText(bl, bl2);
        }
        if (bl4) {
            this.createRadioButtons();
        }
        if (bl5) {
            this.createTextException();
        }
        if (bl6) {
            this.createTextBox();
        }
        if (bl7) {
            this.createChoice();
        }
        if (bl8) {
            this.createProgressBar();
        }
    }

    private void createIcon(int n) {
        Label label = new Label(this.composite, 0);
        label.setImage(this.icon);
        label.setBackground(this.composite.getDisplay().getSystemColor(1));
        label.setLayoutData((Object)new GridData(2, 1, false, false, 1, n));
    }

    private void createTitle(boolean bl) {
        Label label = new Label(this.composite, 0);
        label.setText(this.title);
        label.setFont(this.getBiggerFont());
        label.setForeground(this.getTitleColor());
        label.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridData = new GridData(1, 1, false, false, 1, 1);
        if (bl) {
            gridData.horizontalIndent = 8;
        } else {
            gridData.horizontalIndent = 10;
            gridData.verticalIndent = 10;
        }
        label.setLayoutData((Object)gridData);
    }

    private void createText(boolean bl, boolean bl2) {
        ReadOnlyStyledText readOnlyStyledText = new ReadOnlyStyledText(this.composite, 0 | (this.verticalScrollbar ? 512 : 0));
        readOnlyStyledText.setText(this.text);
        SWTGraphicUtil.applyHTMLFormating(readOnlyStyledText);
        readOnlyStyledText.setEditable(false);
        readOnlyStyledText.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        if (this.height != -1) {
            gridData.heightHint = this.height;
        }
        if (bl) {
            gridData.horizontalIndent = 8;
        } else {
            gridData.horizontalIndent = 20;
            gridData.verticalIndent = bl2 ? 8 : 20;
        }
        readOnlyStyledText.setLayoutData(gridData);
    }

    private void createRadioButtons() {
        for (int i = 0; i < this.radioValues.length; ++i) {
            final Button button = new Button(this.composite, 16);
            button.setBackground(Display.getCurrent().getSystemColor(1));
            button.setText(this.radioValues[i]);
            final Integer n = new Integer(i);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        MessageArea.this.radioChoice = n;
                    }
                }
            });
            button.setSelection(i == this.radioDefaultSelection);
            GridData gridData = new GridData(1, 1, false, false, 1, 1);
            gridData.horizontalIndent = 10;
            button.setLayoutData((Object)gridData);
        }
    }

    private void createTextException() {
        this.textException = new Text(this.composite, 2826);
        this.textException.setText(StringUtil.stackStraceAsString(this.exception));
        this.textException.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.minimumHeight = 300;
        this.textException.setLayoutData((Object)gridData);
    }

    private void createTextBox() {
        final Text text = new Text(this.composite, 2048);
        text.setText(this.textBoxValue);
        text.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MessageArea.this.textBoxValue = text.getText();
            }
        });
        text.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    MessageArea.this.parent.shell.dispose();
                    MessageArea.this.parent.getFooterArea().selectedButtonIndex = 0;
                }
            }
        });
        text.getShell().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                text.forceFocus();
                text.setSelection(text.getText().length());
                text.getShell().removeListener(26, (Listener)this);
            }
        });
    }

    private void createChoice() {
        for (int i = 0; i < this.choiceValues.length; ++i) {
            ChoiceWidget choiceWidget = new ChoiceWidget(this.composite, 16);
            choiceWidget.setBackground(Display.getCurrent().getSystemColor(1));
            choiceWidget.setChoiceItem(this.choiceValues[i]);
            final Integer n = new Integer(i);
            choiceWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MessageArea.this.choice = n;
                    MessageArea.this.parent.shell.dispose();
                }
            });
            choiceWidget.setSelection(i == this.choiceDefaultSelection);
            GridData gridData = new GridData(4, 4, false, false, 1, 1);
            choiceWidget.setLayoutData(gridData);
        }
    }

    private void createProgressBar() {
        this.progressBar = new ProgressBar(this.composite, 65792);
        this.progressBar.setMinimum(this.progressBarMinimumValue);
        this.progressBar.setMaximum(this.progressBarMaximumValue);
        this.progressBar.setSelection(this.progressBarValue);
        this.progressBar.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        this.progressBar.setLayoutData((Object)gridData);
    }

    void hideException() {
        this.textException.dispose();
        this.parent.pack();
    }

    void showException() {
        this.createTextException();
        this.parent.pack();
    }

    public String getTitle() {
        return this.title;
    }

    public MessageArea setTitle(String string) {
        this.title = string;
        this.setInitialised(true);
        return this;
    }

    public Image getIcon() {
        return this.icon;
    }

    public MessageArea setIcon(Image image) {
        this.icon = image;
        this.setInitialised(true);
        return this;
    }

    public String getText() {
        return this.text;
    }

    public MessageArea setText(String string) {
        this.text = string;
        this.setInitialised(true);
        return this;
    }

    public int getRadioChoice() {
        return this.radioChoice;
    }

    public Throwable getException() {
        return this.exception;
    }

    public MessageArea setException(Throwable throwable) {
        this.exception = throwable;
        this.setInitialised(true);
        return this;
    }

    public int getChoice() {
        return this.choice;
    }

    public String getTextBoxValue() {
        return this.textBoxValue;
    }

    public int getProgressBarMinimumValue() {
        return this.progressBarMinimumValue;
    }

    public void setProgressBarMinimumValue(int n) {
        this.progressBarMinimumValue = n;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setMinimum(n);
        }
    }

    public int getProgressBarMaximumValue() {
        return this.progressBarMaximumValue;
    }

    public void setProgressBarMaximumValue(int n) {
        this.progressBarMaximumValue = n;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setMaximum(n);
        }
    }

    public int getProgressBarValue() {
        return this.progressBarValue;
    }

    public void setProgressBarValue(int n) {
        this.progressBarValue = n;
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.setSelection(n);
        }
    }

    public boolean isVerticalScrollbar() {
        return this.verticalScrollbar;
    }

    public void setVerticalScrollbar(boolean bl) {
        this.verticalScrollbar = bl;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }
}

