/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.opalDialog.Dialog;
import org.mihalis.opal.opalDialog.DialogArea;
import org.mihalis.opal.utils.ResourceManager;

public class FooterArea
extends DialogArea {
    private Image icon;
    private String footerText;
    private List<String> buttonLabels;
    private int defaultButtonIndex;
    private int timer = -1;
    private int timerIndexButton = -1;
    int selectedButtonIndex = -1;
    private String collapsedLabelText;
    private String expandedLabelText = ResourceManager.getLabel("FewerDetails");
    private boolean expanded;
    private String detailText;
    private boolean details;
    private Button disabledButton;
    private String checkBoxLabel;
    private boolean checkBoxValue;
    private Label expandedPanel;
    private Composite composite;

    public FooterArea(Dialog dialog) {
        super(dialog);
        this.collapsedLabelText = ResourceManager.getLabel("MoreDetails");
    }

    public FooterArea addCheckBox(String string, boolean bl) {
        this.checkBoxLabel = string;
        this.checkBoxValue = bl;
        this.setInitialised(true);
        return this;
    }

    @Override
    void render() {
        int n;
        if (!this.isInitialised()) {
            return;
        }
        this.createSeparator();
        this.composite = new Composite((Composite)this.parent.shell, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.composite.setBackground(this.getGreyColor());
        int n2 = n = this.buttonLabels == null ? 0 : this.buttonLabels.size();
        if (this.details) {
            n += 2;
        }
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        this.composite.setLayout((Layout)gridLayout);
        if (this.details) {
            this.createDetails(n);
        }
        if (this.buttonLabels != null) {
            this.createButtons();
        }
        if (this.details && this.parent.getMessageArea().getException() == null && this.expanded) {
            this.createExpandedPanel(n);
        }
        if (this.checkBoxLabel != null) {
            this.createCheckBox(n);
        }
        if (this.footerText != null) {
            this.createFooter();
        }
    }

    private void createButtons() {
        Button button = null;
        for (int i = 0; i < this.buttonLabels.size(); ++i) {
            Button button2 = new Button(this.composite, 8);
            button2.setText(this.buttonLabels.get(i));
            GridData gridData = new GridData(3, 2, i == 0, false);
            gridData.minimumWidth = 70;
            gridData.widthHint = 70;
            button2.setLayoutData((Object)gridData);
            if (i == this.defaultButtonIndex) {
                button = button2;
            }
            final Integer n = new Integer(i);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FooterArea.this.parent.shell.dispose();
                    FooterArea.this.selectedButtonIndex = n;
                }
            });
            if (i != this.timerIndexButton || this.timer == -1) continue;
            this.disabledButton = button2;
            button2.setData((Object)button2.getText());
            button2.setText(button2.getText() + " (" + this.timer + ")");
            button2.setEnabled(false);
        }
        if (this.timerIndexButton != -1 && this.timer != -1) {
            Display.getCurrent().timerExec(1000, new Runnable(){

                @Override
                public void run() {
                    FooterArea.this.timer--;
                    if (FooterArea.this.disabledButton.isDisposed()) {
                        return;
                    }
                    if (FooterArea.this.timer == 0) {
                        FooterArea.this.disabledButton.setText((String)FooterArea.this.disabledButton.getData());
                        FooterArea.this.disabledButton.setEnabled(true);
                    } else {
                        FooterArea.this.disabledButton.setText(FooterArea.this.disabledButton.getData() + " (" + FooterArea.this.timer + ")");
                        Display.getCurrent().timerExec(1000, (Runnable)this);
                    }
                }
            });
        }
        this.parent.shell.setDefaultButton(button);
    }

    private void createDetails(int n) {
        final Label label = new Label(this.composite, 0);
        label.setBackground(this.getGreyColor());
        label.setImage(this.isExpanded() ? this.getFewerDetailsImage() : this.getMoreDetailsImage());
        label.setLayoutData((Object)new GridData(2, 2, false, false));
        final Label label2 = new Label(this.composite, 0);
        label2.setBackground(this.getGreyColor());
        label2.setText(this.isExpanded() ? this.expandedLabelText : this.collapsedLabelText);
        label2.setLayoutData((Object)new GridData(1, 2, false, false));
        final int n2 = n;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (FooterArea.this.parent.getMessageArea().getException() != null) {
                    if (label2.getText().equals(FooterArea.this.expandedLabelText)) {
                        label2.setText(FooterArea.this.collapsedLabelText);
                        label.setImage(FooterArea.this.getMoreDetailsImage());
                        FooterArea.this.parent.getMessageArea().hideException();
                    } else {
                        label2.setText(FooterArea.this.expandedLabelText);
                        label.setImage(FooterArea.this.getFewerDetailsImage());
                        FooterArea.this.parent.getMessageArea().showException();
                    }
                } else if (label2.getText().equals(FooterArea.this.expandedLabelText)) {
                    label2.setText(FooterArea.this.collapsedLabelText);
                    label.setImage(FooterArea.this.getMoreDetailsImage());
                    FooterArea.this.expandedPanel.dispose();
                    FooterArea.this.parent.pack();
                } else {
                    label2.setText(FooterArea.this.expandedLabelText);
                    label.setImage(FooterArea.this.getFewerDetailsImage());
                    FooterArea.this.createExpandedPanel(n2);
                    FooterArea.this.parent.pack();
                }
            }
        };
        label2.addListener(4, listener);
        label.addListener(4, listener);
    }

    private void createCheckBox(int n) {
        final Button button = new Button(this.composite, 32);
        button.setText(this.checkBoxLabel);
        button.setSelection(this.checkBoxValue);
        button.setBackground(this.getGreyColor());
        button.setLayoutData((Object)new GridData(1, 2, true, false, n, 1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FooterArea.this.checkBoxValue = button.getSelection();
            }
        });
    }

    private void createFooter() {
        Label label;
        this.createSeparator();
        Composite composite = new Composite((Composite)this.parent.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        composite.setBackground(this.getGreyColor());
        composite.setLayout((Layout)new GridLayout(this.icon == null ? 1 : 2, false));
        if (this.icon != null) {
            label = new Label(composite, 0);
            label.setBackground(this.getGreyColor());
            label.setImage(this.icon);
            label.setLayoutData((Object)new GridData(2, 2, false, false));
        }
        label = new Label(composite, 0);
        label.setBackground(this.getGreyColor());
        label.setText(this.footerText);
        label.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private void createExpandedPanel(int n) {
        this.expandedPanel = new Label(this.composite, 2048);
        this.expandedPanel.setText(this.detailText);
        this.expandedPanel.setBackground(this.getGreyColor());
        GridData gridData = new GridData(4, 4, false, false, n, 1);
        gridData.heightHint = 150;
        gridData.minimumHeight = 150;
        this.expandedPanel.setLayoutData((Object)gridData);
    }

    private void createSeparator() {
        Composite composite = new Composite((Composite)this.parent.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setBackground(this.getGreyColor());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public Image getIcon() {
        return this.icon;
    }

    public FooterArea setIcon(Image image) {
        this.icon = image;
        this.setInitialised(true);
        return this;
    }

    public String getFooterText() {
        return this.footerText;
    }

    public FooterArea setFooterText(String string) {
        this.footerText = string;
        this.setInitialised(true);
        return this;
    }

    public List<String> getButtonLabels() {
        return this.buttonLabels;
    }

    public FooterArea setButtonLabels(List<String> list) {
        this.buttonLabels = list;
        this.setInitialised(true);
        return this;
    }

    public FooterArea setButtonLabels(String ... stringArray) {
        this.buttonLabels = Arrays.asList(stringArray);
        this.setInitialised(true);
        return this;
    }

    public int getDefaultButtonIndex() {
        return this.defaultButtonIndex;
    }

    public FooterArea setDefaultButtonIndex(int n) {
        this.defaultButtonIndex = n;
        this.setInitialised(true);
        return this;
    }

    public int getTimer() {
        return this.timer;
    }

    public FooterArea setTimer(int n) {
        this.timer = n;
        this.setInitialised(true);
        return this;
    }

    public int getTimerIndexButton() {
        return this.timerIndexButton;
    }

    public FooterArea setTimerIndexButton(int n) {
        this.timerIndexButton = n;
        this.setInitialised(true);
        return this;
    }

    int getSelectedButton() {
        return this.selectedButtonIndex;
    }

    public String getCollapsedLabelText() {
        return this.collapsedLabelText;
    }

    public FooterArea setCollapsedLabelText(String string) {
        this.details = true;
        this.collapsedLabelText = string;
        this.setInitialised(true);
        return this;
    }

    public String getExpandedLabelText() {
        return this.expandedLabelText;
    }

    public FooterArea setExpandedLabelText(String string) {
        this.details = true;
        this.expandedLabelText = string;
        this.setInitialised(true);
        return this;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public FooterArea setExpanded(boolean bl) {
        this.details = true;
        this.expanded = bl;
        this.setInitialised(true);
        return this;
    }

    public String getDetailText() {
        return this.detailText;
    }

    public FooterArea setDetailText(String string) {
        this.details = true;
        this.detailText = string;
        this.setInitialised(true);
        return this;
    }

    public boolean getCheckBoxValue() {
        return this.checkBoxValue;
    }
}

