/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.opalDialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.opalDialog.ChoiceItem;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class ChoiceWidget
extends Composite {
    private Image oldImage;
    private ChoiceItem choiceItem;
    private Label image;
    private Label instruction;
    private Label text;
    private final List<SelectionListener> selectionListeners;
    private boolean selection;
    private boolean insideComposite;
    private boolean insideImage;
    private boolean insideText;
    private boolean insideInstruction;

    public ChoiceWidget(Composite composite, int n) {
        super(composite, n);
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayout(2, false));
        this.buildGreenArrow();
        this.buildInstruction();
        this.buildText();
        this.addMouseListeners();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ChoiceWidget.this.drawComposite();
            }
        });
    }

    private void buildGreenArrow() {
        this.image = new Label((Composite)this, 0);
        this.image.setImage(SWTGraphicUtil.createImage("images/arrowGreenRight.png"));
        this.image.setBackground(this.getDisplay().getSystemColor(1));
        this.image.setLayoutData((Object)new GridData(2, 1, false, false, 1, 2));
    }

    private void buildInstruction() {
        final Color color = new Color((Device)Display.getCurrent(), 35, 107, 178);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTGraphicUtil.dispose((Resource)color);
            }
        });
        this.instruction = new Label((Composite)this, 0);
        this.instruction.setForeground(color);
        this.instruction.setLayoutData((Object)new GridData(1, 1, false, false));
    }

    private void buildText() {
        this.text = new Label((Composite)this, 0);
        this.text.setForeground(this.getDisplay().getSystemColor(2));
        this.text.setLayoutData((Object)new GridData(1, 1, false, true));
    }

    private void addMouseListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget.equals((Object)ChoiceWidget.this)) {
                    ChoiceWidget.this.insideComposite = true;
                }
                if (event.widget.equals(ChoiceWidget.this.image)) {
                    ChoiceWidget.this.insideImage = true;
                }
                if (event.widget.equals(ChoiceWidget.this.text)) {
                    ChoiceWidget.this.insideText = true;
                }
                if (event.widget.equals(ChoiceWidget.this.instruction)) {
                    ChoiceWidget.this.insideInstruction = true;
                }
                ChoiceWidget.this.drawComposite();
            }
        };
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget.equals((Object)ChoiceWidget.this)) {
                    ChoiceWidget.this.insideComposite = false;
                }
                if (event.widget.equals(ChoiceWidget.this.image)) {
                    ChoiceWidget.this.insideImage = false;
                }
                if (event.widget.equals(ChoiceWidget.this.text)) {
                    ChoiceWidget.this.insideText = false;
                }
                if (event.widget.equals(ChoiceWidget.this.instruction)) {
                    ChoiceWidget.this.insideInstruction = false;
                }
                ChoiceWidget.this.drawComposite();
            }
        };
        Listener listener3 = new Listener(){

            public void handleEvent(Event event) {
                for (SelectionListener selectionListener : ChoiceWidget.this.selectionListeners) {
                    selectionListener.widgetSelected(null);
                }
            }
        };
        this.addListener(6, listener);
        this.image.addListener(6, listener);
        this.text.addListener(6, listener);
        this.instruction.addListener(6, listener);
        this.addListener(7, listener2);
        this.image.addListener(7, listener2);
        this.text.addListener(7, listener2);
        this.instruction.addListener(7, listener2);
        this.addListener(4, listener3);
        this.image.addListener(4, listener3);
        this.text.addListener(4, listener3);
        this.instruction.addListener(4, listener3);
    }

    private void drawComposite() {
        boolean bl;
        Rectangle rectangle = this.getClientArea();
        Image image = new Image((Device)this.getDisplay(), Math.max(1, rectangle.width), Math.max(1, rectangle.height));
        GC gC = new GC((Drawable)image);
        boolean bl2 = bl = this.insideComposite || this.insideImage || this.insideInstruction || this.insideText;
        if (!bl && !this.selection) {
            gC.setBackground(this.getDisplay().getSystemColor(1));
            gC.setForeground(this.getDisplay().getSystemColor(1));
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            Color color = bl ? new Color((Device)this.getDisplay(), 220, 231, 243) : new Color((Device)this.getDisplay(), 241, 241, 241);
            Color color2 = bl ? new Color((Device)this.getDisplay(), 35, 107, 178) : new Color((Device)this.getDisplay(), 192, 192, 192);
            gC.setForeground(this.getDisplay().getSystemColor(1));
            gC.setBackground(color);
            gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            gC.setForeground(color2);
            gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, 2, 2);
            color.dispose();
            color2.dispose();
        }
        gC.dispose();
        this.setBackgroundImage(image);
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.oldImage = image;
    }

    public ChoiceItem getChoiceItem() {
        return this.choiceItem;
    }

    public void setChoiceItem(ChoiceItem choiceItem) {
        this.choiceItem = choiceItem;
        this.instruction.setText(choiceItem.getInstruction());
        this.text.setText(choiceItem.getText());
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    public void setSelection(boolean bl) {
        this.selection = bl;
    }
}

