/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.obutton;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class ButtonConfiguration {
    private Font font;
    private Color fontColor;
    private int cornerRadius;
    private int gradientDirection;
    private Color backgroundColor;
    private Color secondBackgroundColor;

    public Font getFont() {
        return this.font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public int getGradientDirection() {
        return this.gradientDirection;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getSecondBackgroundColor() {
        return this.secondBackgroundColor;
    }

    public ButtonConfiguration setFont(Font font) {
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.font = font;
        return this;
    }

    public ButtonConfiguration setFontColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.fontColor = color;
        return this;
    }

    public ButtonConfiguration setCornerRadius(int n) {
        this.cornerRadius = Math.max(0, n);
        return this;
    }

    public ButtonConfiguration setGradientDirection(int n) {
        if (n != 512 && n != 256) {
            SWT.error((int)5);
        }
        this.gradientDirection = n;
        return this;
    }

    public ButtonConfiguration setBackgroundColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.backgroundColor = color;
        return this;
    }

    public ButtonConfiguration setSecondBackgroundColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.secondBackgroundColor = color;
        return this;
    }
}

