/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.obutton;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.obutton.ButtonConfiguration;
import org.mihalis.opal.obutton.ButtonRenderer;
import org.mihalis.opal.obutton.OButton;
import org.mihalis.opal.utils.AdvancedPath;
import org.mihalis.opal.utils.SWTGraphicUtil;

public abstract class AbstractButtonRenderer
implements ButtonRenderer {
    private static final int RADIUS_VALUE = 10;
    private static final Color DISABLED_FONT_COLOR = SWTGraphicUtil.createDisposableColor(119, 119, 119);
    private static final Color DISABLED_SECOND_BACKGROUND_COLOR = SWTGraphicUtil.createDisposableColor(220, 220, 220);
    private static final Color DISABLED_FIRST_BACKGROUND_COLOR = SWTGraphicUtil.createDisposableColor(237, 237, 237);
    private ButtonConfiguration normal;
    private ButtonConfiguration hover;
    private ButtonConfiguration disabled;
    private ButtonConfiguration selected;
    private ButtonConfiguration onclick;
    private GC gc;
    private ButtonConfiguration configuration;
    private int gapOnClic;
    protected OButton parent;
    private Image imageUp;
    private Image imageDown;
    private Image imageLeft;
    private Image imageRight;
    private static final int MARGIN = 5;
    private static final int GAP_ON_CLIC = 2;

    protected AbstractButtonRenderer() {
        this.initButtonConfiguration();
        this.createArrows();
    }

    private void initButtonConfiguration() {
        this.normal = this.createNormalConfiguration();
        this.hover = this.createHoverConfiguration();
        this.disabled = this.createDisabledConfiguration();
        this.selected = this.createSelectedConfiguration();
        this.onclick = this.createOnClickConfiguration();
    }

    protected ButtonConfiguration createNormalConfiguration() {
        ButtonConfiguration buttonConfiguration = new ButtonConfiguration();
        buttonConfiguration.setCornerRadius(10);
        buttonConfiguration.setFont(Display.getDefault().getSystemFont()).setFontColor(this.getFontColor());
        buttonConfiguration.setGradientDirection(512);
        buttonConfiguration.setBackgroundColor(this.getFirstBackgroundColor());
        buttonConfiguration.setSecondBackgroundColor(this.getSecondBackgroundColor());
        return buttonConfiguration;
    }

    protected abstract Color getFontColor();

    protected abstract Color getFirstBackgroundColor();

    protected abstract Color getSecondBackgroundColor();

    protected ButtonConfiguration createHoverConfiguration() {
        ButtonConfiguration buttonConfiguration = new ButtonConfiguration();
        buttonConfiguration.setCornerRadius(10);
        buttonConfiguration.setFont(Display.getDefault().getSystemFont()).setFontColor(this.getFontColor());
        buttonConfiguration.setGradientDirection(512);
        buttonConfiguration.setBackgroundColor(this.getSecondBackgroundColor());
        buttonConfiguration.setSecondBackgroundColor(this.getFirstBackgroundColor());
        return buttonConfiguration;
    }

    protected ButtonConfiguration createDisabledConfiguration() {
        ButtonConfiguration buttonConfiguration = new ButtonConfiguration();
        buttonConfiguration.setCornerRadius(10);
        buttonConfiguration.setFont(Display.getDefault().getSystemFont()).setFontColor(DISABLED_FONT_COLOR);
        buttonConfiguration.setGradientDirection(512);
        buttonConfiguration.setBackgroundColor(DISABLED_FIRST_BACKGROUND_COLOR);
        buttonConfiguration.setSecondBackgroundColor(DISABLED_SECOND_BACKGROUND_COLOR);
        return buttonConfiguration;
    }

    protected ButtonConfiguration createSelectedConfiguration() {
        return this.createHoverConfiguration();
    }

    protected ButtonConfiguration createOnClickConfiguration() {
        return this.createHoverConfiguration();
    }

    private void createArrows() {
        this.imageUp = new Image((Device)Display.getCurrent(), this.getClass().getClassLoader().getResourceAsStream("images/arrow_up.png"));
        this.imageDown = new Image((Device)Display.getCurrent(), this.getClass().getClassLoader().getResourceAsStream("images/arrow_down.png"));
        this.imageLeft = new Image((Device)Display.getCurrent(), this.getClass().getClassLoader().getResourceAsStream("images/arrow_left.png"));
        this.imageRight = new Image((Device)Display.getCurrent(), this.getClass().getClassLoader().getResourceAsStream("images/arrow_right.png"));
        Display.getCurrent().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                AbstractButtonRenderer.this.imageUp.dispose();
                AbstractButtonRenderer.this.imageDown.dispose();
                AbstractButtonRenderer.this.imageLeft.dispose();
                AbstractButtonRenderer.this.imageRight.dispose();
            }
        });
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawButtonWhenMouseHover(GC gC, OButton oButton) {
        this.gc = gC;
        this.configuration = this.hover;
        this.gapOnClic = 0;
        this.parent = oButton;
        this.draw();
    }

    private void draw() {
        this.gc.setAdvanced(true);
        this.gc.setAntialias(1);
        this.drawBackground();
        int n = this.computeStartingPosition();
        n += this.drawImage(n);
        if (this.parent.getText() != null) {
            this.drawText(n);
        }
    }

    private void drawBackground() {
        this.createClipping();
        this.gc.setForeground(this.configuration.getBackgroundColor());
        this.gc.setBackground(this.configuration.getSecondBackgroundColor());
        this.gc.fillGradientRectangle(0, this.gapOnClic, this.parent.getWidth(), this.parent.getHeight() - 2, this.configuration.getGradientDirection() == 512);
        this.gc.setClipping((Rectangle)null);
    }

    private void createClipping() {
        AdvancedPath advancedPath = new AdvancedPath((Device)this.parent.getDisplay());
        advancedPath.addRoundRectangle(0.0f, this.gapOnClic, this.parent.getWidth(), this.parent.getHeight() - 2, this.configuration.getCornerRadius(), this.configuration.getCornerRadius());
        this.gc.setClipping((Path)advancedPath);
    }

    private int computeStartingPosition() {
        int n = this.computeSizeOfTextAndImages().x;
        switch (this.parent.alignment) {
            case 0x1000000: {
                return (this.parent.getWidth() - n) / 2;
            }
            case 131072: {
                return this.parent.getWidth() - n - 5;
            }
        }
        return 5;
    }

    private int drawImage(int n) {
        Image image = this.extractImage();
        if (image == null) {
            return 0;
        }
        int n2 = (this.parent.getHeight() - image.getBounds().height - 2) / 2;
        this.gc.drawImage(image, n, n2 + this.gapOnClic);
        return image.getBounds().width + 5;
    }

    private Image extractImage() {
        Image image;
        if ((this.parent.getStyle() & 4) != 0) {
            if ((this.parent.getStyle() & 0x400) != 0) {
                return this.imageDown;
            }
            if ((this.parent.getStyle() & 0x80) != 0) {
                return this.imageUp;
            }
            if ((this.parent.getStyle() & 0x4000) != 0) {
                return this.imageLeft;
            }
            if ((this.parent.getStyle() & 0x20000) != 0) {
                return this.imageRight;
            }
        }
        if (this.parent.getImage() == null) {
            return null;
        }
        if (!this.parent.isEnabled()) {
            image = new Image((Device)this.parent.getDisplay(), this.parent.getImage(), 1);
            this.parent.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    if (!image.isDisposed()) {
                        image.dispose();
                    }
                }
            });
        } else {
            image = this.parent.getImage();
        }
        return image;
    }

    private void drawText(int n) {
        this.gc.setFont(this.configuration.getFont());
        this.gc.setForeground(this.configuration.getFontColor());
        Point point = this.gc.stringExtent(this.parent.getText());
        int n2 = (this.parent.getHeight() - point.y - 2) / 2;
        this.gc.drawText(this.parent.getText(), n, n2 + this.gapOnClic, true);
    }

    @Override
    public void drawButtonWhenDisabled(GC gC, OButton oButton) {
        this.gc = gC;
        this.configuration = this.disabled;
        this.gapOnClic = 0;
        this.parent = oButton;
        this.draw();
    }

    @Override
    public void drawButtonWhenSelected(GC gC, OButton oButton) {
        this.gc = gC;
        this.configuration = this.selected;
        this.gapOnClic = 0;
        this.parent = oButton;
        this.draw();
    }

    @Override
    public void drawButton(GC gC, OButton oButton) {
        this.gc = gC;
        this.configuration = this.normal;
        this.gapOnClic = 0;
        this.parent = oButton;
        this.draw();
    }

    @Override
    public void drawButtonWhenClicked(GC gC, OButton oButton) {
        this.gc = gC;
        this.configuration = this.onclick;
        this.gapOnClic = 2;
        this.parent = oButton;
        this.draw();
    }

    @Override
    public Point computeSize(OButton oButton, int n, int n2, boolean bl) {
        this.parent = oButton;
        Point point = this.computeSizeOfTextAndImages();
        return new Point(10 + point.x, 10 + point.y + 2);
    }

    private Point computeSizeOfTextAndImages() {
        GC gC;
        boolean bl;
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = this.parent.getText() != null && !this.parent.getText().equals("");
        if (bl) {
            gC = new GC((Drawable)this.parent);
            if (this.configuration == null) {
                gC.setFont(this.parent.getFont());
            } else {
                gC.setFont(this.configuration.getFont());
            }
            Point point = gC.stringExtent(this.parent.getText());
            gC.dispose();
            n += point.x;
            n2 = point.y;
        }
        gC = new Point(-1, -1);
        this.computeImageSize(this.extractImage(), (Point)gC);
        if (gC.x != -1) {
            n += gC.x;
            n2 = Math.max(gC.y, n2);
            if (bl) {
                n += 5;
            }
        }
        return new Point(n, n2);
    }

    private void computeImageSize(Image image, Point point) {
        if (image == null) {
            return;
        }
        Rectangle rectangle = image.getBounds();
        point.x = Math.max(rectangle.width, point.x);
        point.y = Math.max(rectangle.height, point.y);
    }
}

