/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.notify;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.notify.NotifierColors;
import org.mihalis.opal.notify.NotifierColorsFactory;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class Notifier {
    private static final int FONT_SIZE = 10;
    private static final int MAX_DURATION_FOR_OPENING = 500;
    private static final int DISPLAY_TIME = 4500;
    private static final int FADE_TIMER = 50;
    private static final int FADE_OUT_STEP = 8;
    private static final int STEP = 5;

    public static void notify(String string, String string2) {
        Notifier.notify(null, string, string2, NotifierColorsFactory.NotifierTheme.YELLOW_THEME);
    }

    public static void notify(Image image, String string, String string2) {
        Notifier.notify(image, string, string2, NotifierColorsFactory.NotifierTheme.YELLOW_THEME);
    }

    public static void notify(String string, String string2, NotifierColorsFactory.NotifierTheme notifierTheme) {
        Notifier.notify(null, string, string2, notifierTheme);
    }

    public static void notify(Image image, String string, String string2, NotifierColorsFactory.NotifierTheme notifierTheme) {
        Shell shell = Notifier.createNotificationWindow(image, string, string2, NotifierColorsFactory.getColorsForTheme(notifierTheme));
        Notifier.makeShellAppears(shell);
    }

    private static Shell createNotificationWindow(Image image, String string, String string2, final NotifierColors notifierColors) {
        Shell shell = new Shell(524296);
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setBackgroundMode(2);
        Notifier.createTitle(shell, string, notifierColors);
        Notifier.createImage(shell, image);
        Notifier.createText(shell, string2, notifierColors);
        Notifier.createBackground(shell, notifierColors);
        Notifier.createCloseAction(shell);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                notifierColors.dispose();
            }
        });
        shell.pack();
        shell.setMinimumSize(320, 100);
        return shell;
    }

    private static void createTitle(Shell shell, String string, NotifierColors notifierColors) {
        Label label = new Label((Composite)shell, 0);
        GridData gridData = new GridData(1, 1, true, false, 2, 1);
        gridData.horizontalIndent = 40;
        label.setLayoutData((Object)gridData);
        Color color = notifierColors.titleColor;
        label.setForeground(color);
        Font font = SWTGraphicUtil.buildFontFrom((Control)label, 1, 10);
        label.setFont(font);
        label.setText(string);
        SWTGraphicUtil.dispose((Widget)shell, (Resource)font);
    }

    private static void createImage(Shell shell, Image image) {
        Label label = new Label((Composite)shell, 0);
        GridData gridData = new GridData(2, 1, false, true);
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        if (image == null) {
            Image image2 = SWTGraphicUtil.createImage("images/information.png");
            label.setImage(image2);
            SWTGraphicUtil.dispose((Widget)shell, (Resource)image2);
        } else {
            label.setImage(image);
        }
    }

    private static void createText(Shell shell, String string, NotifierColors notifierColors) {
        StyledText styledText = new StyledText((Composite)shell, 72);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 15;
        styledText.setLayoutData((Object)gridData);
        styledText.setEnabled(false);
        Font font = SWTGraphicUtil.buildFontFrom((Control)styledText, 0, 10);
        styledText.setFont(font);
        Color color = notifierColors.textColor;
        styledText.setForeground(color);
        styledText.setText(string);
        SWTGraphicUtil.applyHTMLFormating(styledText);
        SWTGraphicUtil.dispose((Widget)shell, (Resource)font);
    }

    private static void createBackground(final Shell shell, final NotifierColors notifierColors) {
        shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = shell.getClientArea();
                Image image = new Image((Device)Display.getDefault(), Math.max(1, rectangle.width), rectangle.height);
                GC gC = new GC((Drawable)image);
                gC.setAntialias(1);
                Color color = notifierColors.borderColor;
                Color color2 = notifierColors.leftColor;
                Color color3 = notifierColors.rightColor;
                gC.setBackground(color);
                gC.fillRoundRectangle(0, 0, rectangle.width, rectangle.height, 8, 8);
                gC.setBackground(color2);
                gC.fillRoundRectangle(1, 1, rectangle.width - 2, rectangle.height - 2, 8, 8);
                gC.setBackground(color3);
                gC.fillRoundRectangle(30, 1, rectangle.width - 32, rectangle.height - 2, 8, 8);
                gC.fillRectangle(30, 1, 10, rectangle.height - 2);
                Image image2 = SWTGraphicUtil.createImage("images/close.png");
                gC.drawImage(image2, rectangle.width - 21, 13);
                gC.dispose();
                image2.dispose();
                shell.setBackgroundImage(image);
            }
        });
    }

    private static void makeShellAppears(final Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Rectangle rectangle = Display.getDefault().getPrimaryMonitor().getClientArea();
        final int n = rectangle.x + rectangle.width - shell.getSize().x;
        final int n2 = 500 / shell.getSize().y * 5;
        final int n3 = 1275 / shell.getSize().y;
        final int n4 = rectangle.y + rectangle.height - shell.getSize().y;
        shell.setAlpha(0);
        shell.setLocation(n, rectangle.y + rectangle.height);
        shell.open();
        shell.getDisplay().timerExec(n2, new Runnable(){

            @Override
            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                shell.setLocation(n, shell.getLocation().y - 5);
                shell.setAlpha(shell.getAlpha() + n3);
                if (shell.getLocation().y >= n4) {
                    shell.getDisplay().timerExec(n2, (Runnable)this);
                } else {
                    shell.setAlpha(255);
                    Display.getDefault().timerExec(4500, Notifier.fadeOut(shell, false));
                }
            }
        });
    }

    private static Runnable fadeOut(final Shell shell, final boolean bl) {
        return new Runnable(){

            @Override
            public void run() {
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                int n = shell.getAlpha();
                if ((n -= 8 * (bl ? 8 : 1)) <= 0) {
                    shell.setAlpha(0);
                    shell.dispose();
                    return;
                }
                shell.setAlpha(n);
                Display.getDefault().timerExec(50, (Runnable)this);
            }
        };
    }

    private static void createCloseAction(final Shell shell) {
        shell.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = shell.getClientArea();
                int n = rectangle.width - 21;
                if (event.x >= n && event.x <= n + 8 && event.y >= 13 && event.y <= 21) {
                    Display.getDefault().timerExec(0, Notifier.fadeOut(shell, true));
                }
            }
        });
    }
}

