/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.launcher.LLabel;
import org.mihalis.opal.launcher.LauncherItem;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class Launcher
extends Composite {
    private final List<LauncherItem> items = new ArrayList<LauncherItem>();
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private boolean needRedraw = true;
    private int selection = -1;

    public Launcher(Composite composite, int n) {
        super(composite, n | 0x800);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Launcher.this.drawLauncher();
            }
        });
        this.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                Launcher.this.OnKeyPressed(event);
            }
        });
    }

    private void drawLauncher() {
        if (!this.needRedraw) {
            return;
        }
        this.disposePreviousContent();
        this.createButtons();
        this.pack();
        this.needRedraw = false;
    }

    private void disposePreviousContent() {
        for (Control control : this.getChildren()) {
            control.dispose();
        }
    }

    private void createButtons() {
        GridLayout gridLayout = new GridLayout(this.items.size() / 2, true);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        for (LauncherItem launcherItem : this.items) {
            LLabel lLabel = new LLabel(this, 0x1000000);
            lLabel.setText(launcherItem.title);
            lLabel.setImage(SWTGraphicUtil.createImage(launcherItem.image));
            lLabel.setBackground(this.getDisplay().getSystemColor(1));
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = 192;
            gridData.heightHint = 220;
            lLabel.setLayoutData(gridData);
            launcherItem.label = lLabel;
            lLabel.addListener(2, new Listener(){

                public void handleEvent(Event event) {
                    Launcher.this.OnKeyPressed(event);
                }
            });
            lLabel.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    Launcher.this.OnClick(event);
                }
            });
            lLabel.addListener(8, new Listener(){

                public void handleEvent(Event event) {
                    Launcher.this.OnDoubleClick(event);
                }
            });
        }
    }

    private void OnKeyPressed(Event event) {
        switch (event.keyCode) {
            case 0x1000003: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection % 2 != 1) break;
                this.changeColor(this.selection, false);
                --this.selection;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000001: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection < 2) break;
                this.changeColor(this.selection, false);
                this.selection -= 2;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000004: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection % 2 != 0) break;
                this.changeColor(this.selection, false);
                ++this.selection;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000002: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection > this.items.size() - 2) break;
                this.changeColor(this.selection, false);
                this.selection += 2;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000007: {
                this.changeColor(this.selection, false);
                this.selection = 0;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000008: {
                this.changeColor(this.selection, false);
                this.selection = this.items.size() - 1;
                this.changeColor(this.selection, true);
            }
        }
    }

    private void OnClick(Event event) {
        for (int i = 0; i < this.items.size(); ++i) {
            LauncherItem launcherItem = this.items.get(i);
            if (launcherItem.label == null || !((Object)((Object)launcherItem.label)).equals(event.widget)) continue;
            if (this.selection != i) {
                this.changeColor(this.selection, false);
                this.selection = i;
                this.changeColor(this.selection, true);
            }
            return;
        }
    }

    private void changeColor(int n, boolean bl) {
        if (n != -1 && this.items.get((int)n).label != null) {
            this.items.get((int)n).label.setBackground(bl ? this.getDisplay().getSystemColor(19) : this.getDisplay().getSystemColor(1));
        }
    }

    private void OnDoubleClick(Event event) {
        for (int i = 0; i < this.items.size(); ++i) {
            LauncherItem launcherItem = this.items.get(i);
            if (launcherItem.label == null || !((Object)((Object)launcherItem.label)).equals(event.widget)) continue;
            if (this.selection != i) {
                this.changeColor(this.selection, false);
                this.selection = i;
                this.changeColor(this.selection, true);
            }
            this.startAnimation(i, event);
            return;
        }
    }

    private void startAnimation(int n, final Event event) {
        final LLabel lLabel = this.items.get((int)n).label;
        this.getDisplay().timerExec(0, new Runnable(){

            @Override
            public void run() {
                if (lLabel.incrementAnimation()) {
                    Launcher.this.getDisplay().timerExec(20, (Runnable)this);
                } else {
                    Launcher.this.fireSelectionListeners(event);
                }
            }
        });
    }

    private boolean fireSelectionListeners(Event event) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            Event event2 = new Event();
            event2.button = event.button;
            event2.display = this.getDisplay();
            event2.item = null;
            event2.widget = this;
            event2.data = null;
            event2.time = event.time;
            event2.x = event.x;
            event2.y = event.y;
            SelectionEvent selectionEvent = new SelectionEvent(event2);
            selectionListener.widgetSelected(selectionEvent);
            if (selectionEvent.doit) continue;
            return false;
        }
        return true;
    }

    public void addItem(String string, String string2) {
        this.checkWidget();
        this.items.add(new LauncherItem(string, string2));
        this.needRedraw = true;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(selectionListener);
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }
}

