/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.itemSelector;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.mihalis.opal.itemSelector.DLItem;
import org.mihalis.opal.utils.SWTGraphicUtil;
import org.mihalis.opal.utils.SimpleSelectionAdapter;

public class DualList
extends Composite {
    private final List<DLItem> items = new ArrayList<DLItem>();
    private final List<DLItem> selection = new ArrayList<DLItem>();
    private final Table itemsTable;
    private final Table selectionTable;
    private List<SelectionListener> eventTable;

    public DualList(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(4, false));
        this.itemsTable = this.createTable();
        this.itemsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                DualList.this.selectItem();
            }
        });
        Button button = this.createButton("double_right.png", true, 3);
        button.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.selectAll();
            }
        });
        this.selectionTable = this.createTable();
        this.selectionTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                DualList.this.deselectItem();
            }
        });
        Button button2 = this.createButton("double_up.png", true, 3);
        button2.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveSelectionToFirstPosition();
            }
        });
        Button button3 = this.createButton("arrow_right.png", false, 2);
        button3.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.selectItem();
            }
        });
        Button button4 = this.createButton("arrow_up.png", false, 2);
        button4.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveUpItem();
            }
        });
        Button button5 = this.createButton("arrow_left.png", false, 2);
        button5.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.deselectItem();
            }
        });
        Button button6 = this.createButton("arrow_down.png", false, 2);
        button6.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveDownItem();
            }
        });
        Button button7 = this.createButton("double_left.png", false, 1);
        button7.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.deselectAll();
            }
        });
        Button button8 = this.createButton("double_down.png", true, 1);
        button8.addSelectionListener((SelectionListener)new SimpleSelectionAdapter(){

            @Override
            public void handle(SelectionEvent selectionEvent) {
                DualList.this.moveSelectionToLastPosition();
            }
        });
    }

    private Table createTable() {
        Table table = new Table((Composite)this, 66306);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        GridData gridData = new GridData(4, 4, true, true, 1, 4);
        gridData.widthHint = 200;
        table.setLayoutData((Object)gridData);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 16384);
        table.setData((Object)-1);
        return table;
    }

    private Button createButton(String string, boolean bl, int n) {
        Button button = new Button((Composite)this, 8);
        final Image image = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/" + string));
        button.setImage(image);
        button.setLayoutData((Object)new GridData(2, n, false, bl));
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTGraphicUtil.dispose((Resource)image);
            }
        });
        return button;
    }

    public void add(DLItem dLItem) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        this.items.add(dLItem);
    }

    public void add(DLItem dLItem, int n) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        if (n <= 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.add(n, dLItem);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        if (this.eventTable == null) {
            this.eventTable = new ArrayList<SelectionListener>();
        }
        this.eventTable.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.remove(selectionListener);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n <= 0 || n >= this.items.size()) {
            return;
        }
        this.fireEvents(this.selection.remove(n));
        this.redrawTables();
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (int n : nArray) {
            if (n <= 0 || n >= this.items.size()) continue;
            arrayList.add(this.selection.get(n));
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            DLItem dLItem = (DLItem)object.next();
            this.selection.remove(dLItem);
        }
        arrayList.clear();
        this.redrawTables();
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            SWT.error((int)6);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (int i = n; i <= n2; ++i) {
            if (i <= 0 || i >= this.items.size()) continue;
            arrayList.add(this.selection.get(i));
        }
        for (DLItem dLItem : arrayList) {
            this.selection.remove(dLItem);
        }
        arrayList.clear();
        this.redrawTables();
    }

    public void deselectAll() {
        this.checkWidget();
        this.items.addAll(this.selection);
        this.selection.clear();
        this.redrawTables();
    }

    public DLItem getItem(int n) {
        this.checkWidget();
        if (n <= 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(n);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public DLItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new DLItem[this.items.size()]);
    }

    public List<DLItem> getItemsAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.items);
    }

    public DLItem[] getSelection() {
        this.checkWidget();
        return this.selection.toArray(new DLItem[this.items.size()]);
    }

    public List<DLItem> getSelectionAsList() {
        this.checkWidget();
        return new ArrayList<DLItem>(this.selection);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.size();
    }

    public void remove(int n) {
        this.checkWidget();
        if (n <= 0 || n >= this.items.size()) {
            SWT.error((int)5);
        }
        this.items.remove(n);
        this.redrawTables();
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        for (int n : nArray) {
            if (n <= 0 || n >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(n);
        }
        this.redrawTables();
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            SWT.error((int)5);
        }
        for (int i = n; i <= n2; ++i) {
            if (i <= 0 || i >= this.items.size()) {
                SWT.error((int)5);
            }
            this.items.remove(i);
        }
        this.redrawTables();
    }

    public void remove(DLItem dLItem) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        if (!this.items.contains(dLItem)) {
            SWT.error((int)5);
        }
        this.items.remove(dLItem);
        this.redrawTables();
    }

    public void removeAll() {
        this.checkWidget();
        this.items.clear();
        this.redrawTables();
    }

    public void select(int n) {
        this.checkWidget();
        if (n <= 0 || n >= this.items.size()) {
            return;
        }
        this.selection.add(this.items.get(n));
        this.fireEvents(this.items.get(n));
        this.redrawTables();
    }

    public void select(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            SWT.error((int)4);
        }
        for (int n : nArray) {
            if (n <= 0 || n >= this.items.size()) continue;
            this.selection.add(this.items.get(n));
            this.fireEvents(this.items.get(n));
        }
        this.redrawTables();
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            SWT.error((int)6);
        }
        for (int i = n; i <= n2; ++i) {
            if (i <= 0 || i >= this.items.size()) continue;
            this.selection.add(this.items.get(i));
            this.fireEvents(this.items.get(i));
        }
        this.redrawTables();
    }

    public void selectAll() {
        this.checkWidget();
        this.selection.addAll(this.items);
        for (DLItem dLItem : this.items) {
            this.fireEvents(dLItem);
        }
        this.items.clear();
        this.redrawTables();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        boolean bl = this.itemsContainImage();
        Point point = this.itemsTable.computeSize(-1, -1);
        Point point2 = this.selectionTable.computeSize(-1, -1);
        int n5 = this.itemsTable.getSize().x;
        if (point.y > this.itemsTable.getSize().y) {
            n5 -= this.itemsTable.getVerticalBar().getSize().x;
        }
        int n6 = this.selectionTable.getSize().x;
        if (point2.y > this.selectionTable.getSize().y) {
            n6 -= this.selectionTable.getVerticalBar().getSize().x;
        }
        if (bl) {
            this.itemsTable.getColumn(0).pack();
            this.itemsTable.getColumn(1).setWidth(n5 - this.itemsTable.getColumn(0).getWidth());
            this.selectionTable.getColumn(0).pack();
            this.selectionTable.getColumn(1).setWidth(n6 - this.selectionTable.getColumn(0).getWidth());
        } else {
            this.itemsTable.getColumn(0).setWidth(n5);
            this.selectionTable.getColumn(0).setWidth(n6);
        }
    }

    private boolean itemsContainImage() {
        for (DLItem dLItem : this.items) {
            if (dLItem.getImage() == null) continue;
            return true;
        }
        for (DLItem dLItem : this.selection) {
            if (dLItem.getImage() == null) continue;
            return true;
        }
        return false;
    }

    public void setItem(int n, DLItem dLItem) {
        this.checkWidget();
        if (dLItem == null) {
            SWT.error((int)4);
        }
        if (n <= 0 || n >= this.items.size()) {
            SWT.error((int)6);
        }
        this.items.set(n, dLItem);
        this.redrawTables();
    }

    public void setItems(DLItem[] dLItemArray) {
        this.checkWidget();
        if (dLItemArray == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (DLItem dLItem : dLItemArray) {
            if (dLItem == null) {
                SWT.error((int)5);
            }
            arrayList.add(dLItem);
        }
        this.items.clear();
        this.items.addAll(arrayList);
        this.redrawTables();
    }

    public void setItems(List<DLItem> list) {
        this.checkWidget();
        this.checkWidget();
        if (list == null) {
            SWT.error((int)4);
        }
        ArrayList<DLItem> arrayList = new ArrayList<DLItem>();
        for (DLItem dLItem : list) {
            if (dLItem == null) {
                SWT.error((int)5);
            }
            arrayList.add(dLItem);
        }
        this.items.clear();
        this.items.addAll(arrayList);
        this.redrawTables();
    }

    private void redrawTables() {
        this.setRedraw(false);
        this.redrawTable(this.itemsTable, false);
        this.redrawTable(this.selectionTable, true);
        this.setRedraw(true);
        this.setBounds(this.getBounds());
    }

    private void redrawTable(Table table, boolean bl) {
        this.clean(table);
        this.fillData(table, bl ? this.selection : this.items);
    }

    private void clean(Table table) {
        if (table == null) {
            return;
        }
        for (TableItem tableItem : table.getItems()) {
            tableItem.dispose();
        }
    }

    private void fillData(Table table, List<DLItem> list) {
        for (DLItem dLItem : list) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setData((Object)dLItem);
            if (dLItem.getBackground() != null) {
                tableItem.setBackground(dLItem.getBackground());
            }
            if (dLItem.getForeground() != null) {
                tableItem.setForeground(dLItem.getForeground());
            }
            if (dLItem.getImage() != null) {
                tableItem.setImage(0, dLItem.getImage());
            }
            if (dLItem.getFont() != null) {
                tableItem.setFont(dLItem.getFont());
            }
            tableItem.setText(1, dLItem.getText());
        }
    }

    protected void moveSelectionToFirstPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int n = 0;
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            this.selection.remove(dLItem);
            this.selection.add(n++, dLItem);
        }
        this.redrawTables();
        this.selectionTable.select(0, n - 1);
        this.selectionTable.forceFocus();
    }

    protected void selectItem() {
        if (this.itemsTable.getSelectionCount() == 0) {
            return;
        }
        for (TableItem tableItem : this.itemsTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            this.selection.add(dLItem);
            this.items.remove(dLItem);
        }
        this.redrawTables();
    }

    protected void moveUpItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        for (int n : this.selectionTable.getSelectionIndices()) {
            if (n != 0) continue;
            this.selectionTable.forceFocus();
            return;
        }
        int[] nArray = new int[this.selectionTable.getSelectionCount()];
        int n = 0;
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            int n2 = this.selection.indexOf(tableItem.getData());
            this.swap(n2, n2 - 1);
            nArray[n++] = n2 - 1;
        }
        this.redrawTables();
        this.selectionTable.select(nArray);
        this.selectionTable.forceFocus();
    }

    protected void deselectItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            this.items.add(dLItem);
            this.selection.remove(dLItem);
        }
        this.redrawTables();
    }

    protected void moveDownItem() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        for (int n : this.selectionTable.getSelectionIndices()) {
            if (n != this.selectionTable.getItemCount() - 1) continue;
            this.selectionTable.forceFocus();
            return;
        }
        int[] nArray = new int[this.selectionTable.getSelectionCount()];
        int n = 0;
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            int n2 = this.selection.indexOf(tableItem.getData());
            this.swap(n2, n2 + 1);
            nArray[n++] = n2 + 1;
        }
        this.redrawTables();
        this.selectionTable.select(nArray);
        this.selectionTable.forceFocus();
    }

    private void swap(int n, int n2) {
        DLItem dLItem = this.selection.get(n);
        this.selection.set(n, this.selection.get(n2));
        this.selection.set(n2, dLItem);
    }

    protected void moveSelectionToLastPosition() {
        if (this.selectionTable.getSelectionCount() == 0) {
            return;
        }
        int n = this.selectionTable.getSelectionCount();
        for (TableItem tableItem : this.selectionTable.getSelection()) {
            DLItem dLItem = (DLItem)tableItem.getData();
            this.selection.remove(dLItem);
            this.selection.add(dLItem);
        }
        this.redrawTables();
        int n2 = this.selectionTable.getItemCount();
        this.selectionTable.select(n2 - n, n2 - 1);
        this.selectionTable.forceFocus();
    }

    private void fireEvents(DLItem dLItem) {
        if (this.eventTable == null) {
            return;
        }
        Event event = new Event();
        event.button = 1;
        event.display = this.getDisplay();
        event.item = null;
        event.widget = this;
        event.data = dLItem;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener selectionListener : this.eventTable) {
            selectionListener.widgetSelected(selectionEvent);
        }
    }
}

