/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.horizontalSpinner;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.utils.StringUtil;

public class HorizontalSpinner
extends Composite {
    private final List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>();
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private Button leftButton;
    private Button rightButton;
    private Text text;
    private int digits = 0;
    private int increment = 1;
    private int maximum = 0;
    private int minimum = 255;
    private int pageIncrement = 10;
    private int storedValue = 0;
    private ALIGNMENT alignment = ALIGNMENT.BOTH;
    private final char decimalFormatSeparator;

    public HorizontalSpinner(Composite composite, int n) {
        super(composite, n);
        if ((n & 0x4000) == 16384) {
            this.alignment = ALIGNMENT.LEFT;
        }
        if ((n & 0x20000) == 131072) {
            this.alignment = ALIGNMENT.RIGHT;
        }
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.createContent(n);
        this.addTextListeners();
        this.addButtonsListener();
        this.addModifyListeners();
        this.decimalFormatSeparator = new DecimalFormatSymbols().getDecimalSeparator();
    }

    private void createContent(int n) {
        boolean bl = (n & 8) == 8;
        boolean bl2 = (n & 0x800000) == 0x800000;
        int n2 = 4 | (bl2 ? 0x800000 : 0);
        if (this.alignment == ALIGNMENT.BOTH) {
            this.createMinusButton(n2);
            this.createText(bl);
            this.createPlusButton(n2);
        } else if (this.alignment == ALIGNMENT.LEFT) {
            this.createMinusButton(n2);
            this.createPlusButton(n2);
            this.createText(bl);
        } else {
            this.createText(bl);
            this.createMinusButton(n2);
            this.createPlusButton(n2);
        }
    }

    private void createMinusButton(int n) {
        this.leftButton = new Button((Composite)this, n | 0x4000);
        this.leftButton.setFont(this.getFont());
        this.leftButton.setBackground(this.getBackground());
        this.leftButton.setCursor(this.getCursor());
        this.leftButton.setEnabled(this.getEnabled());
        this.leftButton.setFont(this.getFont());
        this.leftButton.setForeground(this.getForeground());
        this.leftButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void createText(boolean bl) {
        this.text = new Text((Composite)this, bl ? 8 : 0);
        GridData gridData = new GridData(4, 2, true, false);
        gridData.minimumWidth = 40;
        this.text.setLayoutData((Object)gridData);
    }

    private void createPlusButton(int n) {
        this.rightButton = new Button((Composite)this, n | 0x20000);
        this.rightButton.setFont(this.getFont());
        this.rightButton.setBackground(this.getBackground());
        this.rightButton.setCursor(this.getCursor());
        this.rightButton.setEnabled(this.getEnabled());
        this.rightButton.setFont(this.getFont());
        this.rightButton.setForeground(this.getForeground());
        this.rightButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void addTextListeners() {
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                if (verifyEvent.character != '\u0000' && !Character.isDigit(verifyEvent.character) && verifyEvent.keyCode != 8 && verifyEvent.keyCode != 127) {
                    verifyEvent.doit = false;
                    return;
                }
                verifyEvent.doit = HorizontalSpinner.this.verifyEntryAndStoreValue(verifyEvent.text, verifyEvent.keyCode);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000001) {
                    HorizontalSpinner.this.increaseValue(HorizontalSpinner.this.increment);
                }
                if (keyEvent.keyCode == 0x1000002) {
                    HorizontalSpinner.this.decreaseValue(HorizontalSpinner.this.increment);
                }
                if (keyEvent.keyCode == 0x1000005) {
                    HorizontalSpinner.this.increaseValue(HorizontalSpinner.this.pageIncrement);
                }
                if (keyEvent.keyCode == 0x1000006) {
                    HorizontalSpinner.this.decreaseValue(HorizontalSpinner.this.pageIncrement);
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (HorizontalSpinner.this.text.getText().trim().equals("")) {
                    HorizontalSpinner.this.setSelection(HorizontalSpinner.this.storedValue);
                }
            }
        });
    }

    private boolean verifyEntryAndStoreValue(String string, int n) {
        String string2 = n == 127 ? StringUtil.removeCharAt(this.text.getText(), this.text.getCaretPosition()) : (n == 8 && this.text.getCaretPosition() == 0 ? StringUtil.removeCharAt(this.text.getText(), this.text.getCaretPosition() - 1) : (n == 0 ? string : StringUtil.insertString(this.text.getText(), string, this.text.getCaretPosition())));
        try {
            double d = Double.parseDouble(string2.replace(this.decimalFormatSeparator, '.'));
            this.storedValue = (int)(d * Math.pow(10.0, this.getDigits()));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(null);
        }
        return true;
    }

    private void addButtonsListener() {
        this.leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HorizontalSpinner.this.decreaseValue(HorizontalSpinner.this.increment);
            }
        });
        this.rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HorizontalSpinner.this.increaseValue(HorizontalSpinner.this.increment);
            }
        });
    }

    private void increaseValue(int n) {
        this.setSelection(this.getSelection() + n);
    }

    private void decreaseValue(int n) {
        this.setSelection(this.getSelection() - n);
    }

    private void addModifyListeners() {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                for (ModifyListener modifyListener : HorizontalSpinner.this.modifyListeners) {
                    modifyListener.modifyText(modifyEvent);
                }
            }
        });
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.modifyListeners.add(modifyListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.add(selectionListener);
    }

    public void copy() {
        this.checkWidget();
        this.text.copy();
    }

    public void cut() {
        this.checkWidget();
        this.text.cut();
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return this.storedValue;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public void paste() {
        this.checkWidget();
        this.text.paste();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.modifyListeners.remove(modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.remove(selectionListener);
    }

    public void setDigits(int n) {
        this.checkWidget();
        this.digits = n;
        this.convertSelection();
    }

    public void setIncrement(int n) {
        this.checkWidget();
        this.increment = n;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        this.maximum = n;
    }

    public void setMinimum(int n) {
        this.checkWidget();
        this.minimum = n;
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < this.minimum) {
            n = this.minimum;
        } else if (n > this.maximum) {
            n = this.maximum;
        }
        this.storedValue = n;
        this.text.setText(this.convertSelection());
        this.text.selectAll();
        this.text.setFocus();
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(null);
        }
    }

    private String convertSelection() {
        int n;
        if (this.getDigits() == 0) {
            return String.valueOf(this.storedValue);
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf((double)this.storedValue * Math.pow(10.0, -1 * this.getDigits())));
        for (n = 0; n < this.digits; ++n) {
            stringBuilder.append("0");
        }
        n = stringBuilder.indexOf(".");
        String string = stringBuilder.substring(0, n + 1 + this.digits);
        return string.replace('.', this.decimalFormatSeparator);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        this.text.setTextLimit(n);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setMinimum(n2);
        this.setMaximum(n3);
        this.setDigits(n4);
        this.setIncrement(n5);
        this.setPageIncrement(n6);
        this.setSelection(n);
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public boolean forceFocus() {
        this.checkWidget();
        return this.text.forceFocus();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.leftButton.setBackground(color);
        this.rightButton.setBackground(color);
        this.text.setBackground(color);
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.leftButton.setBackgroundImage(image);
        this.rightButton.setBackgroundImage(image);
        this.text.setBackgroundImage(image);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.leftButton.setCursor(cursor);
        this.rightButton.setCursor(cursor);
        this.text.setCursor(cursor);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.leftButton.setEnabled(bl);
        this.rightButton.setEnabled(bl);
        this.text.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.leftButton.setForeground(color);
        this.rightButton.setForeground(color);
        this.text.setForeground(color);
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.leftButton.setMenu(menu);
        this.rightButton.setMenu(menu);
        this.text.setMenu(menu);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.leftButton.setToolTipText(string);
        this.rightButton.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    private static enum ALIGNMENT {
        LEFT,
        RIGHT,
        BOTH;

    }
}

