/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.gradientComposite;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class GradientComposite
extends Composite {
    private Image oldImage;
    private Color gradientEnd;
    private Color gradientStart;

    public GradientComposite(Composite composite, int n) {
        super(composite, n);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GradientComposite.this.redrawComposite();
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTGraphicUtil.dispose((Resource)GradientComposite.this.oldImage);
                SWTGraphicUtil.dispose((Resource)GradientComposite.this.gradientEnd);
                SWTGraphicUtil.dispose((Resource)GradientComposite.this.gradientStart);
            }
        });
        this.gradientEnd = new Color((Device)this.getDisplay(), 110, 110, 110);
        this.gradientStart = new Color((Device)this.getDisplay(), 0, 0, 0);
    }

    private void redrawComposite() {
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        Image image = new Image((Device)display, Math.max(1, rectangle.width), Math.max(1, rectangle.height));
        GC gC = new GC((Drawable)image);
        gC.setForeground(this.gradientStart);
        gC.setBackground(this.gradientEnd);
        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2, true);
        gC.setForeground(this.gradientEnd);
        gC.setBackground(this.gradientStart);
        gC.fillGradientRectangle(rectangle.x, rectangle.height / 2, rectangle.width, rectangle.height / 2, true);
        gC.dispose();
        this.setBackgroundImage(image);
        if (this.oldImage != null) {
            this.oldImage.dispose();
        }
        this.oldImage = image;
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public void setGradientEnd(Color color) {
        SWTGraphicUtil.dispose((Resource)this.gradientEnd);
        this.gradientEnd = color;
    }

    public Color getGradientStart() {
        return this.gradientStart;
    }

    public void setGradientStart(Color color) {
        SWTGraphicUtil.dispose((Resource)this.gradientStart);
        this.gradientStart = color;
    }
}

