/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.dynamictablecolumns;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.mihalis.opal.dynamictablecolumns.DynamicColumnData;
import org.mihalis.opal.dynamictablecolumns.DynamicLength;
import org.mihalis.opal.dynamictablecolumns.DynamicLengthMeasure;

public class DynamicTreeColumnLayout
extends Layout {
    private List<DynamicColumnData> mcolumns = new LinkedList<DynamicColumnData>();
    private Map<Composite, Listener> installedListeners = new HashMap<Composite, Listener>();
    private int totalFixedWidth = 0;
    private double totalPerctWidth = 0.0;
    private int percentageMargin = 18;
    private boolean relayout = true;

    public void setColumnData(DynamicColumnData dynamicColumnData) {
        this.mcolumns.add(dynamicColumnData);
    }

    public void setColumnData(TableColumn tableColumn, String string, String string2) {
        this.mcolumns.add(new DynamicColumnData(tableColumn, string, string2));
    }

    public void setColumnData(TableColumn tableColumn, String string) {
        this.mcolumns.add(new DynamicColumnData(tableColumn, string));
    }

    protected Point computeSize(final Composite composite, int n, int n2, boolean bl) {
        Listener listener;
        if (this.installedListeners.get(composite) == null) {
            listener = new Listener(){

                public void handleEvent(Event event) {
                    event.doit = false;
                    DynamicTreeColumnLayout.this.calculate(composite.getBounds().width);
                }
            };
            composite.addListener(11, listener);
            this.installedListeners.put(composite, listener);
        }
        listener = ((Scrollable)composite.getChildren()[0]).computeSize(n, n2);
        this.calculate(listener.x);
        return listener;
    }

    public void calculate(int n) {
        this.totalFixedWidth = 0;
        this.totalPerctWidth = 0.0;
        for (DynamicColumnData object : this.mcolumns) {
            DynamicLength dynamicLength = object.getPreferredLength();
            switch (dynamicLength.getMeasure()) {
                case PIXEL: {
                    this.totalFixedWidth = (int)((double)this.totalFixedWidth + dynamicLength.getValue());
                    break;
                }
                case PERCENTAGE: {
                    this.totalPerctWidth += dynamicLength.getValue().doubleValue();
                }
            }
        }
        Integer n2 = n - this.totalFixedWidth - this.percentageMargin;
        for (DynamicColumnData dynamicColumnData : this.mcolumns) {
            DynamicLength dynamicLength = dynamicColumnData.getPreferredLength();
            Double d = dynamicLength.getValue();
            DynamicLengthMeasure dynamicLengthMeasure = dynamicLength.getMeasure();
            DynamicLength dynamicLength2 = dynamicColumnData.getMinLength();
            Double d2 = dynamicLength2.getValue();
            switch (dynamicLengthMeasure) {
                case PIXEL: {
                    this.updateColumnWidth(dynamicColumnData, Math.max(d, d2));
                    break;
                }
                case PERCENTAGE: {
                    double d3 = d / this.totalPerctWidth;
                    int n3 = (int)(d3 * (double)n2.intValue());
                    this.updateColumnWidth(dynamicColumnData, Math.max((double)n3, d2));
                }
            }
        }
    }

    private void updateColumnWidth(DynamicColumnData dynamicColumnData, Double d) {
        TableColumn tableColumn = dynamicColumnData.getTableColumn();
        TreeColumn treeColumn = dynamicColumnData.getTreeColumn();
        if (tableColumn != null) {
            tableColumn.setWidth(d.intValue());
        } else if (treeColumn != null) {
            treeColumn.setWidth(d.intValue());
        } else {
            throw new IllegalStateException("No valid to set the column width!");
        }
    }

    public List<DynamicColumnData> getManagedColumns() {
        return this.mcolumns;
    }

    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        if (n == 0) {
            return;
        }
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rectangle.x;
        int n5 = n2 % n;
        int n6 = rectangle.y;
        int n7 = n2 / n;
        Control control = controlArray[0];
        int n8 = n7;
        control.setBounds(n4, n6, n8 += n5 / 2, n3);
        if (this.relayout) {
            this.relayout = false;
            composite.layout();
        }
    }
}

