/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.checkBoxGroup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class CheckBoxGroup
extends Canvas
implements PaintListener {
    protected final Button button;
    private final Composite content;
    private final List<SelectionListener> selectionListeners;
    private boolean transparent = false;

    public CheckBoxGroup(Composite composite, int n) {
        super(composite, n);
        super.setLayout((Layout)new GridLayout());
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.button = new Button((Composite)this, 32);
        GridData gridData = new GridData(1, 2, true, false);
        gridData.horizontalIndent = 15;
        this.button.setLayoutData((Object)gridData);
        this.button.setSelection(true);
        this.button.pack();
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                selectionEvent.doit = CheckBoxGroup.this.fireSelectionListeners(selectionEvent);
                if (!selectionEvent.doit) {
                    return;
                }
                if (CheckBoxGroup.this.button.getSelection()) {
                    CheckBoxGroup.this.activate();
                } else {
                    CheckBoxGroup.this.deactivate();
                }
            }
        });
        this.content = new Composite((Composite)this, n);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPaintListener(this);
    }

    private boolean fireSelectionListeners(SelectionEvent selectionEvent) {
        selectionEvent.widget = this;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(selectionEvent);
            if (selectionEvent.doit) continue;
            return false;
        }
        return true;
    }

    private void drawWidget(GC gC) {
        Rectangle rectangle = this.getClientArea();
        int n = (int)((double)this.button.getSize().y * 1.5);
        int n2 = n / 2;
        gC.setForeground(this.getDisplay().getSystemColor(18));
        gC.drawRoundRectangle(1, n2, rectangle.width - 2, rectangle.height - n2 - 2, 2, 2);
        gC.setForeground(this.getDisplay().getSystemColor(19));
        gC.drawRoundRectangle(2, n2 + 1, rectangle.width - 4, rectangle.height - n2 - 4, 2, 2);
    }

    public void activate() {
        this.button.setSelection(true);
        SWTGraphicUtil.enable((Control)this.content, true);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.add(selectionListener);
    }

    public void deactivate() {
        this.button.setSelection(false);
        SWTGraphicUtil.enable((Control)this.content, false);
    }

    public boolean isActivated() {
        return this.button.getSelection();
    }

    public Layout getLayout() {
        return this.content.getLayout();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.remove(selectionListener);
    }

    public boolean setFocus() {
        return this.content.setFocus();
    }

    public void setLayout(Layout layout) {
        this.content.setLayout(layout);
    }

    public String getText() {
        return this.button.getText();
    }

    public void setText(String string) {
        this.button.setText(string);
    }

    public Font getFont() {
        return this.button.getFont();
    }

    public void setFont(Font font) {
        this.button.setFont(font);
    }

    public Composite getContent() {
        return this.content;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        if (bl) {
            this.setBackgroundMode(1);
            this.content.setBackgroundMode(1);
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        if (paintEvent.widget == this) {
            this.drawWidget(paintEvent.gc);
        }
    }
}

