/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.calculator;

import org.mihalis.opal.calculator.CalculatorButtonsPanel;
import org.mihalis.opal.calculator.DivideByZeroException;
import org.mihalis.opal.utils.ResourceManager;

class CalculatorEngine {
    private DISPLAY_MODE displayMode;
    private boolean clearOnNextDigit;
    private double lastNumber;
    private String lastOperator;
    private final CalculatorButtonsPanel panel;

    CalculatorEngine(CalculatorButtonsPanel calculatorButtonsPanel) {
        this.panel = calculatorButtonsPanel;
    }

    void addDecimalPoint() {
        String string;
        this.displayMode = DISPLAY_MODE.INPUT;
        if (this.clearOnNextDigit) {
            this.setDisplayString("");
        }
        if ((string = this.getDisplayString()).indexOf(".") < 0) {
            this.setDisplayString(new String(string + "."));
        }
    }

    private void setDisplayString(String string) {
        this.panel.getDisplayArea().setText(string);
        this.panel.fireModifyListeners();
    }

    void addDigitToDisplay(int n) {
        String string;
        if (this.clearOnNextDigit) {
            this.setDisplayString("");
        }
        if ((string = this.getDisplayString()).indexOf("0") == 0) {
            string = string.substring(1);
        }
        if (!string.equals("0") || n > 0) {
            this.setDisplayString(string + n);
        }
        this.displayMode = DISPLAY_MODE.INPUT;
        this.clearOnNextDigit = false;
    }

    void clearAll() {
        this.setDisplayString("0");
        this.lastOperator = "0";
        this.lastNumber = 0.0;
        this.displayMode = DISPLAY_MODE.INPUT;
        this.clearOnNextDigit = true;
    }

    void clearExisting() {
        this.setDisplayString("0");
        this.clearOnNextDigit = true;
        this.displayMode = DISPLAY_MODE.INPUT;
    }

    void processBackSpace() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            this.setDisplayString(this.getDisplayString().substring(0, this.getDisplayString().length() - 1));
            if (this.getDisplayString().length() < 1) {
                this.setDisplayString("0");
            }
        }
    }

    private String getDisplayString() {
        return this.panel.getDisplayArea().getText();
    }

    void processEquals() {
        double d = 0.0;
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                d = this.processLastOperator();
                this.displayResult(d);
            }
            catch (DivideByZeroException divideByZeroException) {
                this.displayError("calculator.dividebyzero");
            }
            this.lastOperator = "0";
        }
    }

    private void displayResult(double d) {
        if (Math.floor(d) == d) {
            this.setDisplayString(Integer.toString((int)d));
        } else {
            this.setDisplayString(Double.toString(d));
        }
        this.lastNumber = d;
        this.displayMode = DISPLAY_MODE.RESULT;
        this.clearOnNextDigit = true;
    }

    private void displayError(String string) {
        this.setDisplayString(ResourceManager.getLabel(string));
        this.lastNumber = 0.0;
        this.displayMode = DISPLAY_MODE.ERROR;
        this.clearOnNextDigit = true;
    }

    void processInverse() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                if (this.getNumberInDisplay() == 0.0) {
                    this.displayError("calculator.dividebyzero");
                }
                double d = 1.0 / this.getNumberInDisplay();
                this.displayResult(d);
            }
            catch (Exception exception) {
                this.displayError("calculator.dividebyzero");
                this.displayMode = DISPLAY_MODE.ERROR;
            }
        }
    }

    private double getNumberInDisplay() {
        String string = this.getDisplayString();
        return Double.parseDouble(string);
    }

    void processOperator(String string) {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            double d = this.getNumberInDisplay();
            if (this.lastOperator != null && !this.lastOperator.equals("0")) {
                try {
                    double d2 = this.processLastOperator();
                    this.displayResult(d2);
                    this.lastNumber = d2;
                }
                catch (DivideByZeroException divideByZeroException) {}
            } else {
                this.lastNumber = d;
            }
            this.clearOnNextDigit = true;
            this.lastOperator = string;
        }
    }

    private double processLastOperator() throws DivideByZeroException {
        double d = 0.0;
        double d2 = this.getNumberInDisplay();
        if (this.lastOperator.equals("/")) {
            if (d2 == 0.0) {
                throw new DivideByZeroException();
            }
            d = this.lastNumber / d2;
        }
        if (this.lastOperator.equals("*")) {
            d = this.lastNumber * d2;
        }
        if (this.lastOperator.equals("-")) {
            d = this.lastNumber - d2;
        }
        if (this.lastOperator.equals("+")) {
            d = this.lastNumber + d2;
        }
        return d;
    }

    void processPerCent() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                double d = this.getNumberInDisplay() / 100.0;
                this.displayResult(d);
            }
            catch (Exception exception) {
                this.displayError("calculator.invalid");
                this.displayMode = DISPLAY_MODE.ERROR;
            }
        }
    }

    void processSignChange() {
        double d;
        if (this.displayMode == DISPLAY_MODE.INPUT) {
            String string = this.getDisplayString();
            if (string.length() > 0 && !string.equals("0")) {
                if (string.indexOf("-") == 0) {
                    this.setDisplayString(string.substring(1));
                } else {
                    this.setDisplayString("-" + string);
                }
            }
        } else if (this.displayMode == DISPLAY_MODE.RESULT && (d = this.getNumberInDisplay()) != 0.0) {
            this.displayResult(-d);
        }
    }

    void processSqrt() {
        if (this.displayMode != DISPLAY_MODE.ERROR) {
            try {
                if (this.getDisplayString().indexOf("-") == 0) {
                    this.displayError("calculator.invalid");
                }
                double d = Math.sqrt(this.getNumberInDisplay());
                this.displayResult(d);
            }
            catch (Exception exception) {
                this.displayError("calculator.invalid");
                this.displayMode = DISPLAY_MODE.ERROR;
            }
        }
    }

    private static enum DISPLAY_MODE {
        INPUT,
        RESULT,
        ERROR;

    }
}

