/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.calculator;

import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mihalis.opal.calculator.CalculatorButtonsPanel;

public class CalculatorCombo
extends Composite {
    private Label label;
    private Button arrow;
    private Shell popup;
    private Listener listener;
    private Listener filter;
    private boolean hasFocus;
    private KeyListener keyListener;
    private CalculatorButtonsPanel panel;

    public CalculatorCombo(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 133120);
        this.label.setBackground(this.getDisplay().getSystemColor(25));
        this.label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.arrow = new Button((Composite)this, 1028);
        this.arrow.setLayoutData((Object)new GridData(4, 4, false, false));
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (CalculatorCombo.this.popup == event.widget) {
                    CalculatorCombo.this.popupEvent(event);
                    return;
                }
                if (CalculatorCombo.this.arrow == event.widget) {
                    CalculatorCombo.this.buttonEvent(event);
                    return;
                }
                if (CalculatorCombo.this == event.widget) {
                    CalculatorCombo.this.multiChoiceEvent(event);
                    return;
                }
                if (CalculatorCombo.this.getShell() == event.widget) {
                    CalculatorCombo.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CalculatorCombo.this.isDisposed()) {
                                return;
                            }
                            CalculatorCombo.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        int[] nArray = new int[]{12, 10, 11};
        for (int i = 0; i < nArray.length; ++i) {
            this.addListener(nArray[i], this.listener);
        }
        int[] nArray2 = new int[]{13, 15};
        for (int i = 0; i < nArray2.length; ++i) {
            this.arrow.addListener(nArray2[i], this.listener);
        }
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == CalculatorCombo.this.getShell()) {
                    CalculatorCombo.this.handleFocus(16);
                }
            }
        };
        this.createPopup();
    }

    private void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle rectangle = this.popup.getBounds();
                Color color = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(color);
                event.gc.drawRectangle(0, 0, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
                break;
            }
            case 12: {
                if (this.keyListener == null) break;
                this.label.removeKeyListener(this.keyListener);
            }
        }
    }

    private void dropDown(boolean bl) {
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.popup.setVisible(false);
            if (!this.isDisposed()) {
                this.label.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            this.popup.dispose();
            this.popup = null;
            this.createPopup();
        }
        Point point = this.label.toDisplay(this.label.getLocation().x, this.label.getLocation().y);
        int n = point.x;
        int n2 = point.y + this.label.getSize().y;
        this.popup.setLocation(n, n2);
        this.popup.setVisible(true);
        this.popup.setFocus();
    }

    private void createPopup() {
        this.popup = new Shell(this.getShell(), 16392);
        this.popup.setLayout((Layout)new GridLayout());
        int[] nArray = new int[]{21, 9, 27, 12};
        for (int i = 0; i < nArray.length; ++i) {
            this.popup.addListener(nArray[i], this.listener);
        }
        this.panel = new CalculatorButtonsPanel((Composite)this.popup, 0);
        this.panel.setLayoutData(new GridData(4, 4, true, true));
        this.panel.setDisplayArea(this.label);
        this.keyListener = this.panel.getKeyListener();
        this.label.addKeyListener(this.keyListener);
        this.popup.pack();
    }

    private void buttonEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    private void handleFocus(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event event = new Event();
                this.notifyListeners(16, event);
                break;
            }
        }
    }

    private boolean isDropped() {
        return !this.popup.isDisposed() && this.popup.getVisible();
    }

    private void multiChoiceEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                if (!this.isDropped()) break;
                this.dropDown(false);
            }
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.panel.addModifyListener(modifyListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        GC gC = new GC((Drawable)this.label);
        int n5 = gC.stringExtent((String)"                    ").x;
        int n6 = gC.stringExtent((String)this.label.getText()).x;
        gC.dispose();
        Point point = this.label.computeSize(-1, -1, bl);
        Point point2 = this.arrow.computeSize(-1, -1, bl);
        int n7 = this.getBorderWidth();
        n4 = Math.max(point.y, point2.y);
        n3 = n6 + 2 * n5 + point2.x + 2 * n7;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3 + 2 * n7, n4 + 2 * n7);
    }

    public String getValue() {
        this.checkWidget();
        return this.label.getText();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        this.panel.removeModifyListener(modifyListener);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.arrow.setEnabled(bl);
        this.label.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.label.setToolTipText(string);
    }

    public void setValue(String string) {
        this.checkWidget();
        new Float(string);
        this.label.setText(string);
    }
}

