/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.calculator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.mihalis.opal.calculator.CalculatorEngine;

class CalculatorButtonsPanel
extends Composite {
    private final Color DARK_RED;
    private final Color DARK_BLUE;
    private final CalculatorEngine engine;
    private Label displayArea;
    private KeyListener keyListener;
    private final List<ModifyListener> modifyListeners;

    CalculatorButtonsPanel(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(5, false));
        this.DARK_RED = new Color((Device)this.getDisplay(), 139, 0, 0);
        this.DARK_BLUE = new Color((Device)this.getDisplay(), 0, 0, 139);
        this.createButtons();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CalculatorButtonsPanel.this.DARK_RED.dispose();
                CalculatorButtonsPanel.this.DARK_BLUE.dispose();
            }
        });
        this.engine = new CalculatorEngine(this);
        this.addKeyListeners();
        this.modifyListeners = new ArrayList<ModifyListener>();
    }

    private void createButtons() {
        Button button = this.createButton(" Back ", this.DARK_RED);
        button.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processBackSpace();
            }
        });
        Button button2 = this.createButton(" CE ", this.DARK_RED);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.clearExisting();
            }
        });
        Button button3 = this.createButton(" C ", this.DARK_RED);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.clearAll();
            }
        });
        Button button4 = this.createButton(" 7 ", this.getDisplay().getSystemColor(9));
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(7);
            }
        });
        Button button5 = this.createButton(" 8 ", this.getDisplay().getSystemColor(9));
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(8);
            }
        });
        Button button6 = this.createButton(" 9 ", this.getDisplay().getSystemColor(9));
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(9);
            }
        });
        Button button7 = this.createButton(" / ", this.getDisplay().getSystemColor(3));
        button7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processOperator("/");
            }
        });
        Button button8 = this.createButton(" \u221a ", this.DARK_RED);
        button8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processSqrt();
            }
        });
        Button button9 = this.createButton(" 4 ", this.getDisplay().getSystemColor(9));
        button9.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(4);
            }
        });
        Button button10 = this.createButton(" 5 ", this.getDisplay().getSystemColor(9));
        button10.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(5);
            }
        });
        Button button11 = this.createButton(" 6 ", this.getDisplay().getSystemColor(9));
        button11.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(6);
            }
        });
        Button button12 = this.createButton(" * ", this.getDisplay().getSystemColor(3));
        button12.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processOperator("*");
            }
        });
        Button button13 = this.createButton(" 1/x ", this.DARK_BLUE);
        button13.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processInverse();
            }
        });
        Button button14 = this.createButton(" 1 ", this.getDisplay().getSystemColor(9));
        button14.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(1);
            }
        });
        Button button15 = this.createButton(" 2 ", this.getDisplay().getSystemColor(9));
        button15.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(2);
            }
        });
        Button button16 = this.createButton(" 3 ", this.getDisplay().getSystemColor(9));
        button16.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(3);
            }
        });
        Button button17 = this.createButton(" - ", this.getDisplay().getSystemColor(3));
        button17.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processOperator("-");
            }
        });
        Button button18 = this.createButton(" % ", this.DARK_BLUE);
        button18.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processPerCent();
            }
        });
        Button button19 = this.createButton(" 0 ", this.getDisplay().getSystemColor(9));
        button19.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDigitToDisplay(0);
            }
        });
        Button button20 = this.createButton(" +/- ", this.getDisplay().getSystemColor(9));
        button20.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processSignChange();
            }
        });
        Button button21 = this.createButton(" . ", this.getDisplay().getSystemColor(9));
        button21.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.addDecimalPoint();
            }
        });
        Button button22 = this.createButton(" + ", this.getDisplay().getSystemColor(3));
        button22.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processOperator("+");
            }
        });
        Button button23 = this.createButton(" = ", this.getDisplay().getSystemColor(3));
        button23.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CalculatorButtonsPanel.this.engine.processEquals();
            }
        });
    }

    private Button createButton(final String string, final Color color) {
        final Button button = new Button((Composite)this, 0x20000008);
        button.setText("");
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 30;
        button.setLayoutData((Object)gridData);
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.setForeground(color);
                paintEvent.gc.setFont(CalculatorButtonsPanel.this.getFont());
                Point point = paintEvent.gc.textExtent(string, 0x40000000);
                paintEvent.gc.drawText(string, (button.getBounds().width - point.x) / 2, (button.getBounds().height - point.y) / 2, true);
            }
        });
        return button;
    }

    private void addKeyListeners() {
        this.keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.character) {
                    case '0': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(0);
                        return;
                    }
                    case '1': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(1);
                        return;
                    }
                    case '2': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(2);
                        return;
                    }
                    case '3': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(3);
                        return;
                    }
                    case '4': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(4);
                        return;
                    }
                    case '5': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(5);
                        return;
                    }
                    case '6': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(6);
                        return;
                    }
                    case '7': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(7);
                        return;
                    }
                    case '8': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(8);
                        return;
                    }
                    case '9': {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(9);
                        return;
                    }
                    case '.': {
                        CalculatorButtonsPanel.this.engine.addDecimalPoint();
                        return;
                    }
                    case '+': {
                        CalculatorButtonsPanel.this.engine.processOperator("+");
                        return;
                    }
                    case '-': {
                        CalculatorButtonsPanel.this.engine.processOperator("-");
                        return;
                    }
                    case '*': {
                        CalculatorButtonsPanel.this.engine.processOperator("*");
                        return;
                    }
                    case '/': {
                        CalculatorButtonsPanel.this.engine.processOperator("/");
                        return;
                    }
                    case '=': {
                        CalculatorButtonsPanel.this.engine.processEquals();
                        return;
                    }
                    case '%': {
                        CalculatorButtonsPanel.this.engine.processPerCent();
                        return;
                    }
                }
                switch (keyEvent.keyCode) {
                    case 0x1000030: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(0);
                        return;
                    }
                    case 0x1000031: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(1);
                        return;
                    }
                    case 16777266: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(2);
                        return;
                    }
                    case 0x1000033: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(3);
                        return;
                    }
                    case 16777268: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(4);
                        return;
                    }
                    case 16777269: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(5);
                        return;
                    }
                    case 16777270: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(6);
                        return;
                    }
                    case 16777271: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(7);
                        return;
                    }
                    case 16777272: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(8);
                        return;
                    }
                    case 16777273: {
                        CalculatorButtonsPanel.this.engine.addDigitToDisplay(9);
                        return;
                    }
                    case 16777259: {
                        CalculatorButtonsPanel.this.engine.processOperator("+");
                        return;
                    }
                    case 16777261: {
                        CalculatorButtonsPanel.this.engine.processOperator("-");
                        return;
                    }
                    case 16777263: {
                        CalculatorButtonsPanel.this.engine.processOperator("/");
                        return;
                    }
                    case 16777258: {
                        CalculatorButtonsPanel.this.engine.processOperator("*");
                        return;
                    }
                    case 13: 
                    case 16777277: 
                    case 0x1000050: {
                        CalculatorButtonsPanel.this.engine.processEquals();
                        return;
                    }
                    case 16777262: {
                        CalculatorButtonsPanel.this.engine.addDecimalPoint();
                        return;
                    }
                    case 8: {
                        CalculatorButtonsPanel.this.engine.processBackSpace();
                        return;
                    }
                    case 27: {
                        CalculatorButtonsPanel.this.engine.clearAll();
                        return;
                    }
                }
            }
        };
        for (Control control : this.getChildren()) {
            control.addKeyListener(this.keyListener);
        }
        this.addKeyListener(this.keyListener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.modifyListeners.add(modifyListener);
    }

    void fireModifyListeners() {
        for (ModifyListener modifyListener : this.modifyListeners) {
            Event event = new Event();
            event.widget = this;
            ModifyEvent modifyEvent = new ModifyEvent(event);
            modifyListener.modifyText(modifyEvent);
        }
    }

    KeyListener getKeyListener() {
        return this.keyListener;
    }

    Label getDisplayArea() {
        return this.displayArea;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error((int)4);
        }
        this.modifyListeners.remove(modifyListener);
    }

    void setDisplayArea(Label label) {
        this.displayArea = label;
    }
}

