/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.brushedMetalComposite;

import java.util.Random;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class BrushedMetalComposite
extends Composite {
    private Image oldImage;
    private int radius = 10;
    private float amount = 0.1f;
    private int color = -7829368;
    private float shine = 0.1f;
    private boolean monochrome = true;
    private Random randomNumbers;

    public BrushedMetalComposite(Composite composite, int n) {
        super(composite, n);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                BrushedMetalComposite.this.redrawComposite();
            }
        });
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTGraphicUtil.dispose((Resource)BrushedMetalComposite.this.oldImage);
            }
        });
    }

    private void redrawComposite() {
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        ImageData imageData = this.drawBrushedMetalBackground(Math.max(1, rectangle.width), Math.max(1, rectangle.width));
        Image image = new Image((Device)display, imageData);
        this.setBackgroundImage(image);
        SWTGraphicUtil.dispose((Resource)this.oldImage);
        this.oldImage = image;
    }

    private ImageData drawBrushedMetalBackground(int n, int n2) {
        int[] nArray = new int[n];
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n2, 32, paletteData);
        this.randomNumbers = new Random(0L);
        int n3 = this.color & 0xFF000000;
        int n4 = this.color >> 16 & 0xFF;
        int n5 = this.color >> 8 & 0xFF;
        int n6 = this.color & 0xFF;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n7;
                int n8 = n4;
                int n9 = n5;
                int n10 = n6;
                if (this.shine != 0.0f) {
                    n7 = (int)((double)(255.0f * this.shine) * Math.sin((double)j / (double)n * Math.PI));
                    n8 += n7;
                    n9 += n7;
                    n10 += n7;
                }
                if (this.monochrome) {
                    n7 = (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount);
                    nArray[j] = n3 | this.clamp(n8 + n7) << 16 | this.clamp(n9 + n7) << 8 | this.clamp(n10 + n7);
                    continue;
                }
                nArray[j] = n3 | this.random(n8) << 16 | this.random(n9) << 8 | this.random(n10);
            }
            if (this.radius != 0) {
                this.setDataElements(imageData, paletteData, 0, i, n, 1, this.blur(nArray, n, this.radius));
                continue;
            }
            this.setDataElements(imageData, paletteData, 0, i, n, 1, nArray);
        }
        return imageData;
    }

    private void setDataElements(ImageData imageData, PaletteData paletteData, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                int n6 = nArray[n5++];
                int n7 = paletteData.getPixel(new RGB(n6 >> 16 & 0xFF, n6 >> 8 & 0xFF, n6 & 0xFF));
                imageData.setPixel(j, i, n7);
                imageData.setAlpha(j, i, n6 >> 24 & 0xFF);
            }
        }
    }

    private int random(int n) {
        if ((n += (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount)) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    private int clamp(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    private int[] blur(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int[] nArray2 = new int[n];
        int n5 = n - 1;
        int n6 = 2 * n2 + 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n4 = -n2; n4 <= n2; ++n4) {
            n3 = nArray[this.mod(n4, n)];
            n7 += n3 >> 16 & 0xFF;
            n8 += n3 >> 8 & 0xFF;
            n9 += n3 & 0xFF;
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n10;
            nArray2[n4] = 0xFF000000 | n7 / n6 << 16 | n8 / n6 << 8 | n9 / n6;
            n3 = n4 + n2 + 1;
            if (n3 > n5) {
                n3 = this.mod(n3, n);
            }
            if ((n10 = n4 - n2) < 0) {
                n10 = this.mod(n10, n);
            }
            int n11 = nArray[n3];
            int n12 = nArray[n10];
            n7 += (n11 & 0xFF0000) - (n12 & 0xFF0000) >> 16;
            n8 += (n11 & 0xFF00) - (n12 & 0xFF00) >> 8;
            n9 += (n11 & 0xFF) - (n12 & 0xFF);
        }
        return nArray2;
    }

    private int mod(int n, int n2) {
        int n3;
        if ((n -= (n3 = n / n2) * n2) < 0) {
            return n + n2;
        }
        return n;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        this.radius = n;
        this.redrawComposite();
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float f) {
        if (f < 0.0f || f > 1.0f) {
            SWT.error((int)5);
        }
        this.amount = f;
        this.redrawComposite();
    }

    public Color getColor() {
        return new Color((Device)this.getDisplay(), this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF);
    }

    public void setColor(Color color) {
        if (color == null) {
            SWT.error((int)4);
        }
        this.color = 0xFF000000 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        this.redrawComposite();
    }

    public float getShine() {
        return this.shine;
    }

    public void setShine(float f) {
        if (this.amount < 0.0f || this.amount > 1.0f) {
            SWT.error((int)5);
        }
        this.shine = f;
        this.redrawComposite();
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public void setMonochrome(boolean bl) {
        this.monochrome = bl;
        this.redrawComposite();
    }
}

