/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.mihalis.opal.breadcrumb.Breadcrumb;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class BreadcrumbItem
extends Item {
    private static final int MIN_WIDTH = 40;
    private static final int MARGIN = 4;
    private static Color SELECTED_COLOR = SWTGraphicUtil.createDisposableColor(223, 220, 213);
    private final Breadcrumb parentBreadcrumb;
    private final List<SelectionListener> selectionListeners;
    private Rectangle bounds;
    private boolean enabled;
    private boolean selection;
    private int width;
    private int height;
    private Image disabledImage;
    private Image selectionImage;
    private int alignment;
    private Color textColorSelected;
    private Color textColor;
    private String tooltipText;
    private GC gc;
    private int toolbarHeight;
    private boolean isLast;

    public BreadcrumbItem(Breadcrumb breadcrumb) {
        this(breadcrumb, 0);
    }

    public BreadcrumbItem(Breadcrumb breadcrumb, int n) {
        super((Widget)breadcrumb, BreadcrumbItem.checkStyle(n));
        breadcrumb.addItem(this);
        this.parentBreadcrumb = breadcrumb;
        this.textColor = breadcrumb.getDisplay().getSystemColor(2);
        this.textColorSelected = breadcrumb.getDisplay().getSystemColor(2);
        this.enabled = true;
        if ((n & 0x4000) != 0) {
            this.alignment = 16384;
        }
        if ((n & 0x1000000) != 0) {
            this.alignment = 0x1000000;
        }
        if ((n & 0x20000) != 0) {
            this.alignment = 131072;
        }
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.height = -1;
        this.width = -1;
    }

    private static int checkStyle(int n) {
        if (((n = BreadcrumbItem.checkBits(n, 0, 8, 2)) & 0xA) != 0) {
            return BreadcrumbItem.checkBits(n, 0x1000000, 16384, 131072);
        }
        return n;
    }

    static int checkBits(int n, int n2, int n3, int n4) {
        int n5 = n2 | n3 | n4;
        if ((n & n5) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n5 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n5 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n5 | n4;
        }
        return n;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(selectionListener);
    }

    Point computeDefaultSize() {
        Point point = this.computeSizeOfTextAndImages();
        return new Point(8 + point.x, 8 + point.y);
    }

    private Point computeSizeOfTextAndImages() {
        GC gC;
        boolean bl;
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = this.getText() != null && !this.getText().equals("");
        if (bl) {
            gC = new GC((Drawable)this.parentBreadcrumb);
            gC.setFont(this.parentBreadcrumb.getFont());
            Point point = gC.stringExtent(this.getText());
            gC.dispose();
            n += point.x;
            n2 = point.y;
        }
        gC = new Point(-1, -1);
        this.computeImageSize(this.getImage(), (Point)gC);
        this.computeImageSize(this.selectionImage, (Point)gC);
        this.computeImageSize(this.disabledImage, (Point)gC);
        if (gC.x != -1) {
            n += gC.x;
            n2 = Math.max(gC.y, n2);
            if (bl) {
                n += 4;
            }
        }
        return new Point(n, n2);
    }

    private void computeImageSize(Image image, Point point) {
        if (image == null) {
            return;
        }
        Rectangle rectangle = image.getBounds();
        point.x = Math.max(rectangle.width, point.x);
        point.y = Math.max(rectangle.height, point.y);
    }

    public void dispose() {
        this.getParent().removeItem(this);
        this.bounds = null;
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
        }
        this.disabledImage = null;
        if (this.selectionImage != null) {
            this.selectionImage.dispose();
        }
        this.selectionImage = null;
        if (this.textColor != null) {
            this.textColor.dispose();
        }
        this.textColor = null;
        if (this.textColorSelected != null) {
            this.textColorSelected.dispose();
        }
        this.textColorSelected = null;
        super.dispose();
    }

    void drawButton(GC gC, int n, int n2, boolean bl) {
        this.gc = gC;
        this.toolbarHeight = n2;
        this.isLast = bl;
        if (this.selection) {
            this.drawBackground(n);
        }
        if (!bl) {
            this.drawTriangles(n);
        }
        int n3 = this.computeStartingPosition(n);
        n3 += this.drawImage(n + n3);
        this.drawText(n + n3);
        this.bounds = new Rectangle(n, 0, this.getWidth(), n2);
    }

    private void drawBackground(int n) {
        int n2;
        this.gc.setAdvanced(true);
        this.gc.setAntialias(1);
        this.gc.setForeground(SELECTED_COLOR);
        this.gc.setBackground(SELECTED_COLOR);
        boolean bl = this.parentBreadcrumb.hasBorder;
        boolean bl2 = this.parentBreadcrumb.indexOf(this) == 0;
        int n3 = n2 = bl ? 1 : 0;
        int n4 = bl2 ? 0 : 5 + (bl ? 0 : 1);
        int n5 = n + n2 + n4;
        int n6 = n2;
        int n7 = this.getWidth() - n2 - n4 - (this.isLast && bl ? 1 : 0);
        int n8 = this.getHeight() - 2 * n2;
        this.gc.fillRectangle(n5, n6, n7, n8);
        if (!bl2) {
            this.gc.fillPolygon(new int[]{n5 - 5, n6, n5, n6, n5, n6 + this.toolbarHeight / 2});
            this.gc.fillPolygon(new int[]{n5 - 5, n6 + n8, n5, n6 + n8, n5, n6 + this.toolbarHeight / 2});
        }
        if (!this.isLast) {
            this.gc.fillPolygon(new int[]{n5 + n7, n6 + 1, n5 + n7, n6 + this.getHeight(), n5 + n7 + 5, n6 + this.toolbarHeight / 2});
        }
        this.gc.setClipping((Rectangle)null);
    }

    private void drawTriangles(int n) {
        this.gc.setForeground(Breadcrumb.BORDER_COLOR);
        this.drawTriangle(n + this.getWidth());
        this.gc.setAlpha(127);
        this.gc.setForeground(Breadcrumb.BORDER_COLOR_1);
        this.drawTriangle(n + this.getWidth() + 1);
        this.gc.setForeground(Breadcrumb.BORDER_COLOR_2);
        this.drawTriangle(n + this.getWidth() + 2);
        this.gc.setForeground(Breadcrumb.BORDER_COLOR_3);
        this.drawTriangle(n + this.getWidth() + 3);
        this.gc.setAlpha(255);
        if (this.parentBreadcrumb.hasBorder) {
            this.gc.setForeground(Breadcrumb.BORDER_COLOR);
            this.gc.drawLine(n + this.getWidth(), 0, n + this.getWidth() + 3, 0);
            this.gc.drawLine(n + this.getWidth(), this.toolbarHeight - 1, n + this.getWidth() + 3, this.toolbarHeight - 1);
        }
    }

    private void drawTriangle(int n) {
        this.gc.drawLine(n, 0, n + 5, this.toolbarHeight / 2);
        this.gc.drawLine(n + 5, this.toolbarHeight / 2, n, this.toolbarHeight);
    }

    private int computeStartingPosition(int n) {
        int n2 = this.computeSizeOfTextAndImages().x;
        switch (this.alignment) {
            case 0x1000000: {
                return (this.getWidth() - n2) / 2;
            }
            case 131072: {
                return this.getWidth() - n2 - 4;
            }
        }
        return 4;
    }

    void fireSelectionEvent() {
        Event event = new Event();
        event.widget = this.parentBreadcrumb;
        event.display = this.getDisplay();
        event.item = this;
        event.type = 13;
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private int drawImage(int n) {
        Image image = !this.isEnabled() ? this.disabledImage : (this.selection ? this.selectionImage : this.getImage());
        if (image == null) {
            return 0;
        }
        int n2 = (this.toolbarHeight - image.getBounds().height) / 2;
        this.gc.drawImage(image, n, n2);
        return image.getBounds().width + 4;
    }

    private void drawText(int n) {
        this.gc.setFont(this.parentBreadcrumb.getFont());
        if (this.selection) {
            this.gc.setForeground(this.textColorSelected);
        } else {
            this.gc.setForeground(this.textColor);
        }
        Point point = this.gc.stringExtent(this.getText());
        int n2 = (this.toolbarHeight - point.y) / 2;
        int n3 = this.parentBreadcrumb.indexOf(this) == 0 || this.isLast ? 0 : 5;
        this.gc.drawText(this.getText(), n + n3, n2, true);
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.bounds;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public int getHeight() {
        this.checkWidget();
        if (this.height == -1) {
            return this.computeDefaultSize().y;
        }
        return this.height;
    }

    public Breadcrumb getParent() {
        this.checkWidget();
        return this.parentBreadcrumb;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public Image getSelectionImage() {
        this.checkWidget();
        return this.selectionImage;
    }

    public Color getTextColor() {
        this.checkWidget();
        return this.textColor;
    }

    public Color getTextColorSelected() {
        this.checkWidget();
        return this.textColorSelected;
    }

    public String getTooltipText() {
        this.checkWidget();
        return this.tooltipText;
    }

    public int getWidth() {
        this.checkWidget();
        if (this.width == -1) {
            return Math.max(this.computeDefaultSize().x, 40);
        }
        return Math.max(this.width, 40);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.enabled;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this.alignment = n;
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (this.bounds == null) {
            SWT.error((int)4);
        }
        this.bounds = new Rectangle(Math.max(0, rectangle.x), Math.max(0, rectangle.y), Math.max(0, rectangle.width), Math.max(0, rectangle.height));
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        this.disabledImage = image;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.enabled = bl;
    }

    public void setHeight(int n) {
        this.checkWidget();
        this.height = Math.max(n, 0);
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        this.selection = bl;
    }

    public void setSelectionImage(Image image) {
        this.checkWidget();
        this.selectionImage = image;
    }

    public void setTextColor(Color color) {
        this.checkWidget();
        this.textColor = color;
    }

    public void setTextColorSelected(Color color) {
        this.checkWidget();
        this.textColorSelected = color;
    }

    public void setTooltipText(String string) {
        this.checkWidget();
        this.tooltipText = string == null ? "" : string;
    }

    public void setWidth(int n) {
        this.checkWidget();
        this.width = Math.max(0, n);
    }
}

