/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.breadcrumb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.breadcrumb.BreadcrumbItem;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class Breadcrumb
extends Canvas {
    private final List<BreadcrumbItem> items = new ArrayList<BreadcrumbItem>();
    private static Color START_GRADIENT_COLOR = SWTGraphicUtil.createDisposableColor(255, 255, 255);
    private static Color END_GRADIENT_COLOR = SWTGraphicUtil.createDisposableColor(224, 224, 224);
    static Color BORDER_COLOR = SWTGraphicUtil.createDisposableColor(128, 128, 128);
    static Color BORDER_COLOR_1 = SWTGraphicUtil.createDisposableColor(212, 212, 212);
    static Color BORDER_COLOR_2 = SWTGraphicUtil.createDisposableColor(229, 229, 229);
    static Color BORDER_COLOR_3 = SWTGraphicUtil.createDisposableColor(243, 243, 243);
    boolean hasBorder = false;

    public Breadcrumb(Composite composite, int n) {
        super(composite, Breadcrumb.checkStyle(n) | 0x20000000);
        this.hasBorder = (n & 0x800) != 0;
        this.addListeners();
    }

    private static int checkStyle(int n) {
        if ((n & 0x800) != 0) {
            n &= 0xFFFFF7FF;
        }
        return 0;
    }

    private void addListeners() {
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                for (BreadcrumbItem breadcrumbItem : Breadcrumb.this.items) {
                    boolean bl;
                    if (!breadcrumbItem.getBounds().contains(event.x, event.y)) continue;
                    boolean bl2 = (breadcrumbItem.getStyle() & 2) != 0;
                    boolean bl3 = bl = (breadcrumbItem.getStyle() & 8) != 0;
                    if (bl2 || bl) {
                        breadcrumbItem.setSelection(!breadcrumbItem.getSelection());
                        Breadcrumb.this.redraw();
                        Breadcrumb.this.update();
                    }
                    return;
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                for (BreadcrumbItem breadcrumbItem : Breadcrumb.this.items) {
                    if (!breadcrumbItem.getBounds().contains(event.x, event.y)) continue;
                    if ((breadcrumbItem.getStyle() & 8) != 0) {
                        breadcrumbItem.setSelection(false);
                    }
                    if ((breadcrumbItem.getStyle() & 0xA) != 0) {
                        breadcrumbItem.fireSelectionEvent();
                        Breadcrumb.this.redraw();
                        Breadcrumb.this.update();
                    }
                    return;
                }
            }
        });
        this.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                for (BreadcrumbItem breadcrumbItem : Breadcrumb.this.items) {
                    if (!breadcrumbItem.getBounds().contains(event.x, event.y)) continue;
                    Breadcrumb.this.setToolTipText(breadcrumbItem.getTooltipText() == null ? "" : breadcrumbItem.getTooltipText());
                    return;
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Breadcrumb.this.paintControl(paintEvent);
            }
        });
    }

    void addItem(BreadcrumbItem breadcrumbItem) {
        this.items.add(breadcrumbItem);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        for (BreadcrumbItem breadcrumbItem : this.items) {
            n3 += breadcrumbItem.getWidth();
            n4 = Math.max(n4, breadcrumbItem.getHeight());
        }
        return new Point(Math.max(n3, n), Math.max(n4, n2));
    }

    public BreadcrumbItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n > this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(n);
    }

    public BreadcrumbItem getItem(Point point) {
        this.checkWidget();
        for (BreadcrumbItem breadcrumbItem : this.items) {
            if (!breadcrumbItem.getBounds().contains(point)) continue;
            return breadcrumbItem;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public BreadcrumbItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new BreadcrumbItem[this.items.size()]);
    }

    public int indexOf(BreadcrumbItem breadcrumbItem) {
        this.checkWidget();
        return this.items.indexOf((Object)breadcrumbItem);
    }

    protected void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        gC.setAdvanced(true);
        gC.setAntialias(1);
        int n = this.getSize().x;
        int n2 = this.getSize().y;
        this.drawBackground(gC, n, n2);
        Iterator<BreadcrumbItem> iterator = this.items.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            BreadcrumbItem breadcrumbItem = iterator.next();
            breadcrumbItem.drawButton(gC, n3, n2, !iterator.hasNext());
            n3 += breadcrumbItem.getWidth();
        }
    }

    private void drawBackground(GC gC, int n, int n2) {
        gC.setForeground(START_GRADIENT_COLOR);
        gC.setBackground(END_GRADIENT_COLOR);
        gC.fillGradientRectangle(0, 0, n, n2, true);
        if (this.hasBorder) {
            gC.setForeground(BORDER_COLOR);
            gC.drawRectangle(0, 0, n - 1, n2 - 1);
        }
    }

    void removeItem(BreadcrumbItem breadcrumbItem) {
        this.items.remove((Object)breadcrumbItem);
    }
}

