/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.angles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class AngleSlider
extends Canvas {
    private static final int WHOLE_RADIUS = 40;
    private static final int BUTTON_RADIUS = 10;
    private static final int STEP = 5;
    private final Image backgroundImage = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/angleBackground.png"));
    private final Image buttonFocus = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/angleButtonFocus.png"));
    private final Image buttonNoFocus = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/angleButtonFocusLost.png"));
    private int selection;
    private final List<SelectionListener> selectionListeners;
    private boolean mousePressed;

    public AngleSlider(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                AngleSlider.this.paintControl(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SWTGraphicUtil.dispose((Resource)AngleSlider.this.backgroundImage);
                SWTGraphicUtil.dispose((Resource)AngleSlider.this.buttonFocus);
                SWTGraphicUtil.dispose((Resource)AngleSlider.this.buttonNoFocus);
            }
        });
        this.addListener(3, this.createMouseListener());
        this.addListener(4, this.createMouseListener());
        this.addListener(5, this.createMouseListener());
        this.addListener(1, this.createKeyListener());
        this.selection = 0;
        this.selectionListeners = new ArrayList<SelectionListener>();
    }

    private void paintControl(Event event) {
        GC gC = event.gc;
        gC.drawImage(this.backgroundImage, 0, 0);
        float f = (float)this.selection / 360.0f;
        f = (float)((double)(f * 2.0f) * Math.PI - 1.5707963267948966);
        float f2 = (float)(20.0 - 10.0 * Math.cos(f));
        float f3 = (float)(20.0 - 10.0 * Math.sin(f));
        if (this.isFocusControl()) {
            gC.drawImage(this.buttonFocus, (int)f2 - 2, (int)f3 - 2);
        } else {
            gC.drawImage(this.buttonNoFocus, (int)f2 - 2, (int)f3 - 2);
        }
        if (!this.isEnabled()) {
            gC.setAlpha(127);
            gC.setAntialias(1);
            gC.setBackground(this.getDisplay().getSystemColor(1));
            gC.fillOval(4, 4, 33, 33);
        }
    }

    private Listener createMouseListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!AngleSlider.this.isEnabled()) {
                    return;
                }
                if (event.type == 3) {
                    AngleSlider.this.mousePressed = true;
                }
                if (event.type == 3 || event.type == 5 && AngleSlider.this.mousePressed) {
                    float f = (float)event.x - 20.0f;
                    float f2 = (float)event.y - 20.0f;
                    double d = Math.atan2(f, f2);
                    AngleSlider.this.selection = 360 - (int)(360.0 * d / (Math.PI * 2) + 360.0) % 360;
                    AngleSlider.this.redraw();
                }
                if (event.type == 4) {
                    AngleSlider.this.mousePressed = false;
                    AngleSlider.this.fireSelectionListeners(event);
                }
            }
        };
    }

    private void fireSelectionListeners(Event event) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private Listener createKeyListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!AngleSlider.this.isEnabled()) {
                    return;
                }
                if (event.type != 1) {
                    return;
                }
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000003) {
                    AngleSlider.this.setSelection(AngleSlider.this.selection + 5);
                }
                if (event.keyCode == 0x1000002 || event.keyCode == 0x1000004) {
                    AngleSlider.this.setSelection(AngleSlider.this.selection - 5);
                }
            }
        };
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.add(selectionListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        return new Point(40, 40);
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.remove(selectionListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.redraw();
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n > 360) {
            SWT.error((int)28);
        }
        this.selection = n;
        this.fireSelectionListeners(new Event());
        this.redraw();
    }
}

