/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.tool;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.session.Session;
import org.neodatis.tool.wrappers.NeoDatisNumber;
import org.neodatis.tool.wrappers.OdbDateFormat;

public class ObjectTool {
    public static OdbDateFormat format = new OdbDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
    public static int ID_CALLER_IS_ODB_EXPLORER = 1;
    public static int ID_CALLER_IS_XML = 2;
    public static int ID_CALLER_IS_SERIALIZER = 2;
    protected OidGenerator oidGenerator;

    public ObjectTool(Session session) {
        this.oidGenerator = session.getOidGenerator();
    }

    public Object stringToObject(int odbTypeId, String value, int caller) throws NumberFormatException, ParseException {
        Object theObject = null;
        if (value == null || value.equals("null")) {
            return new NullNativeObjectInfo(odbTypeId);
        }
        switch (odbTypeId) {
            case 20: {
                theObject = new Byte(value);
                break;
            }
            case 10: {
                theObject = value.equals("true") ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 30: {
                theObject = new Character(value.charAt(0));
                break;
            }
            case 70: {
                theObject = new Float(value);
                break;
            }
            case 80: {
                theObject = new Double(value);
                break;
            }
            case 50: {
                theObject = new Integer(value);
                break;
            }
            case 60: {
                theObject = new Long(value);
                break;
            }
            case 40: {
                theObject = new Short(value);
                break;
            }
            case 200: {
                theObject = NeoDatisNumber.createDecimalFromString(value);
                break;
            }
            case 190: {
                theObject = NeoDatisNumber.createBigIntegerFromString(value);
                break;
            }
            case 160: {
                theObject = value.equals("true") ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 150: {
                theObject = new Character(value.charAt(0));
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                if (this.callerIsOdbExplorer(caller)) {
                    theObject = format.parse(value);
                }
                if (this.callerIsXml(caller) || this.callerIsSerializer(caller)) {
                    theObject = new java.util.Date(Long.parseLong(value));
                }
                java.util.Date date = (java.util.Date)theObject;
                if (odbTypeId == 171) {
                    theObject = new Date(date.getTime());
                }
                if (odbTypeId != 172) break;
                theObject = new Timestamp(date.getTime());
                break;
            }
            case 173: 
            case 174: {
                java.util.Date dateCalendar = null;
                if (this.callerIsOdbExplorer(caller)) {
                    dateCalendar = format.parse(value);
                }
                if (this.callerIsXml(caller) || this.callerIsSerializer(caller)) {
                    dateCalendar = new java.util.Date(Long.parseLong(value));
                }
                Calendar c = Calendar.getInstance();
                c.setTime(dateCalendar);
                theObject = c;
                break;
            }
            case 130: {
                theObject = new Float(value);
                break;
            }
            case 140: {
                theObject = new Double(value);
                break;
            }
            case 110: {
                theObject = new Integer(value);
                break;
            }
            case 120: {
                theObject = new Long(value);
                break;
            }
            case 210: {
                theObject = value;
                break;
            }
            case 180: 
            case 181: 
            case 182: {
                theObject = this.oidGenerator.objectOidFromString(value);
            }
            case 185: 
            case 186: 
            case 187: {
                theObject = this.oidGenerator.classOidFromString(value);
            }
        }
        if (theObject == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(ODBType.getNameFromId(odbTypeId)));
        }
        return theObject;
    }

    public NativeObjectInfo stringToObjectInfo(int odbTypeId, String value, int caller, ClassInfo ci) throws NumberFormatException, ParseException {
        if (ODBType.isAtomicNative(odbTypeId)) {
            Object theObject = this.stringToObject(odbTypeId, value, caller);
            return new AtomicNativeObjectInfo(theObject, odbTypeId);
        }
        if (ODBType.isEnum(odbTypeId)) {
            return new EnumNativeObjectInfo(ci, value);
        }
        return NullNativeObjectInfo.getInstance();
    }

    public String atomicNativeObjectToString(AtomicNativeObjectInfo anoi, int caller) {
        if (anoi == null || anoi.isNull()) {
            return "null";
        }
        if (anoi.getObject() instanceof java.util.Date) {
            if (this.callerIsOdbExplorer(caller)) {
                return format.format((java.util.Date)anoi.getObject());
            }
            return String.valueOf(((java.util.Date)anoi.getObject()).getTime());
        }
        return anoi.getObject().toString();
    }

    public boolean callerIsOdbExplorer(int caller) {
        return caller == ID_CALLER_IS_ODB_EXPLORER;
    }

    public boolean callerIsXml(int caller) {
        return caller == ID_CALLER_IS_XML;
    }

    public boolean callerIsSerializer(int caller) {
        return caller == ID_CALLER_IS_SERIALIZER;
    }
}

