/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.plugin.idf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.layers.layer4.StorageEngineAdapter;
import org.neodatis.odb.plugin.idf.IOManager;
import org.neodatis.odb.plugin.idf.Indexer;

public class IDFPlugin
extends StorageEngineAdapter {
    protected static final String CLASS_OID = "class-oid";
    protected Map<String, IOManager> ioManagers;
    protected boolean debug = true;
    protected NeoDatisConfig neoDatisConfig;
    protected String baseName;

    public void open(String baseName, NeoDatisConfig config) {
        this.neoDatisConfig = config;
        this.baseName = baseName;
        this.neoDatisConfig.setBaseName(baseName);
        this.initClassOidIOManager();
    }

    private void initClassOidIOManager() {
        this.ioManagers = new HashMap<String, IOManager>();
        IOManager ioManager = this.createIOManagerFor(CLASS_OID);
        System.out.println("debug:IDF Plugin - " + this.config.getBaseDirectory() + "/" + this.baseName);
        ClassOidIterator iterator = ioManager.getIndexer().getClassOidIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ClassOid coid = iterator.next();
                String soid = coid.oidToString();
                ioManager = this.createIOManagerFor(soid);
            }
        }
    }

    public ClassOidIterator getClassOidIterator() {
        Indexer indexer = this.ioManagers.get(CLASS_OID).getIndexer();
        if (indexer == null) {
            return null;
        }
        return indexer.getClassOidIterator();
    }

    public ObjectOidIterator getObjectOidIterator(ClassOid classOid, ObjectOidIterator.Way way) {
        Indexer indexer = this.ioManagers.get(classOid.oidToString()).getIndexer();
        if (indexer == null) {
            return null;
        }
        return indexer.getObjectOidIterator();
    }

    public OidAndBytes read(OID oid, boolean useCache) {
        IOManager ioManager = this.getIOManagerFor(oid);
        return ioManager.read(oid, useCache);
    }

    public void write(OidAndBytes oidAndBytes) {
        try {
            IOManager ioManager = this.getIOManagerFor(oidAndBytes.oid);
            ioManager.write(oidAndBytes);
        }
        catch (Exception e) {
            this.rollback();
            throw new NeoDatisRuntimeException(e, "Error while writing data for oid " + oidAndBytes.oid.oidToString());
        }
    }

    protected synchronized IOManager createIOManagerFor(String oid) {
        IOManager ioManager = this.ioManagers.get(oid);
        if (ioManager == null) {
            ioManager = new IOManager(oid, this.neoDatisConfig);
            this.ioManagers.put(oid, ioManager);
        }
        return ioManager;
    }

    protected synchronized IOManager getIOManagerFor(OID oid) {
        if (oid instanceof ObjectOid) {
            ObjectOid ooid = (ObjectOid)oid;
            String classOid = ooid.getClassOid().oidToString();
            IOManager ioManager = this.ioManagers.get(classOid);
            if (ioManager == null) {
                ioManager = this.createIOManagerFor(classOid);
            }
            return ioManager;
        }
        if (oid instanceof ClassOid) {
            IOManager ioManager = this.ioManagers.get(CLASS_OID);
            if (ioManager == null) {
                ioManager = this.createIOManagerFor(CLASS_OID);
            }
            return ioManager;
        }
        return null;
    }

    public void close() {
        try {
            Iterator<IOManager> iterator = this.ioManagers.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void commit() {
        Iterator<IOManager> iterator = this.ioManagers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().commit();
        }
    }

    public void deleteObjectWithOid(OID oid) {
        IOManager ioManager = this.getIOManagerFor(oid);
        ioManager.delete(oid);
    }

    public boolean existOid(OID oid) {
        IOManager ioManager = this.getIOManagerFor(oid);
        return ioManager.getIndexer().existKey(oid);
    }

    public String getEngineDirectoryForBaseName(String theBaseName) {
        if (this.neoDatisConfig.getBaseDirectory() != null) {
            return this.neoDatisConfig.getBaseDirectory() + "/";
        }
        return "";
    }

    public String getStorageEngineName() {
        return "IDFPlugin";
    }

    public void open(String host, int port, String baseName, NeoDatisConfig config) {
    }

    public void rollback() {
        Iterator<IOManager> iterator = this.ioManagers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().rollback();
        }
    }

    public boolean useDirectory() {
        return true;
    }
}

