/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.list.objects;

import java.util.Collection;
import java.util.Iterator;
import org.neodatis.OrderByConstants;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazySimpleListFromOid<T>
extends OdbArrayList<T>
implements Objects<T> {
    private int currentPosition;
    private SessionEngine engine;
    private boolean returnInstance;
    protected InstanceBuilderContext ibc;

    public LazySimpleListFromOid(int size, SessionEngine engine, boolean returnObjects, int depth) {
        super(size);
        this.engine = engine;
        this.returnInstance = returnObjects;
        this.ibc = new InstanceBuilderContext(depth);
    }

    public LazySimpleListFromOid(SessionEngine engine, boolean returnObjects, Collection<T> oids, int depth) {
        super(oids);
        this.engine = engine;
        this.returnInstance = returnObjects;
        this.ibc = new InstanceBuilderContext(depth);
    }

    @Override
    public boolean addWithKey(Comparable key, T object) {
        throw new NeoDatisRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public boolean addWithKey(int key, T object) {
        throw new NeoDatisRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public T first() {
        try {
            return this.get(0);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(0), (Throwable)e);
        }
    }

    @Override
    public T get(int index) {
        ObjectOid oid = (ObjectOid)super.get(index);
        try {
            if (this.returnInstance) {
                return (T)this.engine.getObjectFromOid(oid, true, this.ibc);
            }
            return (T)this.engine.getMetaObjectFromOid(oid, true, this.ibc);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(index), (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.size();
    }

    @Override
    public Iterator<T> iterator(OrderByConstants orderByType) {
        throw new NeoDatisRuntimeException(NeoDatisError.OPERATION_NOT_IMPLEMENTED);
    }

    @Override
    public T next() {
        try {
            return this.get(this.currentPosition++);
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.ERROR_WHILE_GETTING_OBJECT_FROM_LIST_AT_INDEX.addParameter(0), (Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.currentPosition = 0;
    }
}

