/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer4;

import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.core.layers.layer4.BaseIdentification;
import org.neodatis.tool.IOUtil;
import org.neodatis.tool.wrappers.io.OdbFile;

public class IOFileParameter
implements BaseIdentification {
    private String fileName;
    private boolean canWrite;
    private NeoDatisConfig config;

    public IOFileParameter(String name, boolean write, NeoDatisConfig config) {
        this.fileName = name;
        this.canWrite = write;
        this.config = config;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        return this.fileName;
    }

    public String getDirectory() {
        return new OdbFile(this.fileName).getDirectory();
    }

    public String getCleanFileName() {
        return new OdbFile(this.fileName).getCleanFileName();
    }

    public String getBaseId() {
        return this.getCleanFileName();
    }

    public String getFullIdentification() {
        return this.fileName;
    }

    public boolean isNew() {
        return !IOUtil.existFile(this.fileName);
    }

    public boolean isLocal() {
        return true;
    }

    public String getUserName() {
        return this.config.getUser();
    }

    public String getPassword() {
        return this.config.getPassword();
    }

    public NeoDatisConfig getConfig() {
        return this.config;
    }

    public BaseIdentification copy() {
        IOFileParameter p = new IOFileParameter(this.fileName, this.canWrite, this.config.copy());
        return p;
    }

    public void setConfig(NeoDatisConfig neoDatisConfig) {
        this.config = neoDatisConfig;
    }
}

