/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.CoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeIdentification;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.BytesHelper;
import org.neodatis.odb.core.layers.layer3.BytesImpl;
import org.neodatis.odb.core.layers.layer3.ConversionContext;
import org.neodatis.odb.core.layers.layer3.DataConverter;
import org.neodatis.odb.core.layers.layer3.Layer3Converter;
import org.neodatis.odb.core.layers.layer3.Layer3Writer;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.session.DatabaseInfo;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.trigger.TriggerManager;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer3WriterImpl
extends Layer3Converter
implements Layer3Writer {
    public static final String LOG_ID = "Layer3Writer";
    public static final String LOG_ID_DEBUG = "Layer3Writer.debug";
    protected DataConverter byteArrayConverter;
    protected Session session;
    protected boolean debug;

    public Layer3WriterImpl(Session session) {
        this.session = session;
        CoreProvider provider = session.getConfig().getCoreProvider();
        this.byteArrayConverter = provider.getByteArrayConverter(session.getConfig().debugLayers(), session.getConfig().getDatabaseCharacterEncoding(), session.getConfig());
        NATIVE_HEADER_BLOCK_SIZE_BYTE = new byte[4];
        BytesImpl b = new BytesImpl();
        this.byteArrayConverter.intToByteArray(NATIVE_HEADER_BLOCK_SIZE, b, 0, "init block size");
        NATIVE_HEADER_BLOCK_SIZE_BYTE = b.extract(0, 4);
        this.debug = session.getConfig().debugLayers();
    }

    @Override
    public IOdbList<OidAndBytes> metaToBytes(NonNativeObjectInfo nnoi) {
        ConversionContext context = new ConversionContext();
        this.internalMetaToBytes(nnoi, context);
        return context.getOidAndBytes();
    }

    protected void internalMetaToBytes(NonNativeObjectInfo objectInfo, ConversionContext context) {
        boolean isMainObject = context.isMainObject();
        if (isMainObject) {
            context.setIsMainObject(false);
        }
        if (this.debug) {
            DLogger.debug(String.format("\n** Converting nnoi %s with oid %s to bytes", objectInfo.getClassInfo().getFullClassName(), objectInfo.getOid()));
        }
        if (objectInfo.isNull()) {
            context.setLastOid(null);
            return;
        }
        ObjectOid existingOid = objectInfo.getOid();
        if (context.alreadyConvertedOids.containsKey(objectInfo.getOid())) {
            context.setLastOid(objectInfo.getOid());
            return;
        }
        context.alreadyConvertedOids.put(existingOid, objectInfo);
        Bytes bytesContent = BytesFactory.getBytes();
        BytesHelper bytes = new BytesHelper(bytesContent, this.session.getConfig().debugLayers(), this.session.getConfig());
        OdbArrayList<NonNativeObjectInfo> dependentObjects = new OdbArrayList<NonNativeObjectInfo>();
        ClassInfo ci = objectInfo.getClassInfo();
        String fullClassName = ci.getFullClassName();
        TriggerManager tm = this.session.getEngine().getTriggerManager();
        if (existingOid.isNew() && tm.hasOidTriggersFor(fullClassName)) {
            tm.manageOidTrigger(fullClassName, objectInfo, existingOid);
        }
        int nbAttributes = objectInfo.getClassInfo().getAttributes().size();
        int offset = 0;
        int position = 0;
        int objectSize = 0;
        objectSize += bytes.writeInt(4, offset + objectSize, "object type");
        objectSize += bytes.writeObjectOid(objectInfo.getOid(), offset + objectSize, "oid");
        objectSize += bytes.writeLong(objectInfo.getHeader().getCreationDate(), offset + objectSize, "creation");
        objectInfo.getHeader().setObjectVersion(objectInfo.getHeader().getObjectVersion() + 1L);
        objectInfo.getHeader().setUpdateDate(System.currentTimeMillis());
        objectSize += bytes.writeLong(objectInfo.getHeader().getUpdateDate(), offset + objectSize, "update");
        objectSize += bytes.writeLong(objectInfo.getHeader().getObjectVersion(), offset + objectSize, "version");
        objectSize += bytes.writeBoolean(false, offset + objectSize, "si ext sync");
        objectSize += bytes.writeLong(0L, offset + objectSize, "reserved1");
        objectSize += bytes.writeLong(0L, offset + objectSize, "reserved2");
        objectSize += bytes.writeInt(nbAttributes, offset + objectSize, "nb attributes");
        int headerPositionInfo = objectSize;
        objectSize += bytes.writeInt(0, offset + objectSize, "header position");
        AttributeIdentification[] attributeIdentifications = new AttributeIdentification[nbAttributes];
        int nbNonNativeAttributes = objectInfo.getDirectNonNativeAttributes().size();
        int nbNativeAttributes = nbAttributes - nbNonNativeAttributes;
        ClassAttributeInfo cai = null;
        AbstractObjectInfo attributeValue = null;
        Bytes bytesAttributeValues = bytes.bytes;
        for (int i = 0; i < nbAttributes; ++i) {
            cai = ci.getAttributeInfo(i);
            attributeValue = objectInfo.getAttributeValueFromId(cai.getId());
            if (attributeValue == null) {
                attributeValue = cai.isNative() ? new NullNativeObjectInfo(cai.getAttributeType().getId()) : new NonNativeNullObjectInfo();
            }
            if (attributeValue.isNative()) {
                AttributeIdentification ai = this.nativeObjectInfoToBytes((NativeObjectInfo)attributeValue, bytesAttributeValues, objectSize, context);
                objectSize += ai.size;
                attributeIdentifications[i] = ai;
            } else {
                ObjectOid attributeOid = null;
                if (attributeValue.isObjectReference()) {
                    ObjectReference or = (ObjectReference)attributeValue;
                    attributeOid = or.getOid();
                } else {
                    NonNativeObjectInfo nnoi = (NonNativeObjectInfo)attributeValue;
                    attributeOid = nnoi.getOid();
                    if (!nnoi.isNull()) {
                        dependentObjects.add(nnoi);
                    }
                }
                attributeIdentifications[i] = new AttributeIdentification(attributeOid);
                objectSize += this.byteArrayConverter.objectOidToByteArray(attributeOid, bytesAttributeValues, objectSize, "oid");
            }
            attributeIdentifications[i].id = cai.getId();
        }
        objectInfo.getHeader().setAttributesIdentification(attributeIdentifications);
        if (this.debug) {
            DLogger.debug("  ** end writing attribute at " + objectSize);
        }
        bytes.writeInt(objectSize, headerPositionInfo, "header position");
        int asize = this.headerToBytes(attributeIdentifications, bytes.bytes, objectSize, true);
        objectSize += asize;
        objectSize += bytes.writeInt(objectSize, objectSize, "object size");
        int crc = this.computeCrc(bytes.bytes);
        objectSize += bytes.writeInt(crc, objectSize, "crc");
        if (this.debug) {
            DLogger.debug(String.format("  Object with OID %s has a size of %d - crc=%d", existingOid, objectSize, crc));
            DLogger.debug("  Attributes Identification of object with oid " + existingOid + " are " + DisplayUtility.toString(attributeIdentifications));
            DLogger.debug("**End Writing non native object at " + position + " with oid " + existingOid);
        }
        context.addOidAndBytes(existingOid, bytes.bytes, objectInfo, isMainObject);
        context.setLastOid(existingOid);
        for (NonNativeObjectInfo nnoi : dependentObjects) {
            if (nnoi.isNull()) continue;
            this.internalMetaToBytes(nnoi, context);
        }
        if (this.debug) {
            DLogger.debug(String.format("End od Converting nnoi with oid " + objectInfo.getOid() + " to bytes, %d dependent objects", dependentObjects.size()));
        }
    }

    private int computeCrc(Bytes bytes) {
        return 0;
    }

    protected int headerToBytes(AttributeIdentification[] attributeIdentifications, Bytes bytes, int offset, boolean writeId) {
        int position = offset;
        int size = 0;
        for (AttributeIdentification ai : attributeIdentifications) {
            if (ai.isNative) {
                if (writeId) {
                    size += this.byteArrayConverter.intToByteArray(ai.id, bytes, position + size, "attribute id");
                }
                size += this.byteArrayConverter.byteToByteArray((byte)1, bytes, position + size, "is native");
                size += this.byteArrayConverter.intToByteArray(ai.offset, bytes, position + size, "attribute offset");
                continue;
            }
            if (writeId) {
                size += this.byteArrayConverter.intToByteArray(ai.id, bytes, position + size, "attribute id");
            }
            size += this.byteArrayConverter.byteToByteArray((byte)2, bytes, position + size, "is non native");
            size += this.byteArrayConverter.objectOidToByteArray(ai.oid, bytes, position + size, "oid");
        }
        return size;
    }

    protected int nativeObjectHeaderToBytes(int odbTypeId, boolean isNull, byte blockType, Bytes bytes, int offset) {
        this.byteArrayConverter.intToByteArray(NATIVE_HEADER_BLOCK_SIZE, bytes, offset, "block size");
        this.byteArrayConverter.byteToByteArray(blockType, bytes, offset + 4, "block type");
        this.byteArrayConverter.intToByteArray(odbTypeId, bytes, offset + 5, "odb type id");
        this.byteArrayConverter.booleanToByteArray(isNull, bytes, offset + 9, "is null?");
        return 10;
    }

    public AttributeIdentification atomicNativeObjectToBytes(AtomicNativeObjectInfo anoi, Bytes bytes, int offset) {
        int originalPosition = offset;
        int odbTypeId = anoi.getOdbTypeId();
        int objectSize = this.nativeObjectHeaderToBytes(odbTypeId, anoi.isNull(), (byte)3, bytes, offset);
        if (anoi.isNull()) {
            return new AttributeIdentification(offset, objectSize);
        }
        offset += objectSize;
        Object object = anoi.getObject();
        switch (odbTypeId) {
            case 20: 
            case 90: {
                objectSize += this.byteArrayConverter.byteToByteArray((Byte)object, bytes, offset, "byte value");
                break;
            }
            case 10: 
            case 160: {
                objectSize += this.byteArrayConverter.booleanToByteArray((Boolean)object, bytes, offset, "boolean value");
                break;
            }
            case 150: {
                objectSize += this.byteArrayConverter.charToByteArray(((Character)object).charValue(), bytes, offset, "char value");
                break;
            }
            case 30: {
                objectSize += this.byteArrayConverter.charToByteArray(object.toString().charAt(0), bytes, offset, "char value");
                break;
            }
            case 70: 
            case 130: {
                objectSize += this.byteArrayConverter.floatToByteArray(((Float)object).floatValue(), bytes, offset, "float value");
                break;
            }
            case 80: 
            case 140: {
                objectSize += this.byteArrayConverter.doubleToByteArray((Double)object, bytes, offset, "double value");
                break;
            }
            case 50: 
            case 110: {
                objectSize += this.byteArrayConverter.intToByteArray((int)((Integer)object), bytes, offset, "int value");
                break;
            }
            case 60: 
            case 120: {
                objectSize += this.byteArrayConverter.longToByteArray((long)((Long)object), bytes, offset, "long value");
                break;
            }
            case 40: 
            case 100: {
                objectSize += this.byteArrayConverter.shortToByteArray((Short)object, bytes, offset, "short value");
                break;
            }
            case 200: {
                objectSize += this.byteArrayConverter.bigDecimalToByteArray((BigDecimal)object, bytes, offset, "big decimal value");
                break;
            }
            case 190: {
                objectSize += this.byteArrayConverter.bigIntegerToByteArray((BigInteger)object, bytes, offset, "big integer value");
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                objectSize += this.byteArrayConverter.dateToByteArray((Date)object, bytes, offset, "date value");
                break;
            }
            case 173: 
            case 174: {
                Calendar c = (Calendar)object;
                objectSize += this.byteArrayConverter.dateToByteArray(c.getTime(), bytes, offset, "date value");
                break;
            }
            case 210: {
                objectSize += this.byteArrayConverter.stringToByteArray((String)object, true, bytes, offset, "string value");
                break;
            }
            case 180: 
            case 181: 
            case 182: {
                objectSize += this.byteArrayConverter.objectOidToByteArray((ObjectOid)object, bytes, offset, "oid value");
                break;
            }
            case 185: 
            case 186: 
            case 187: {
                objectSize += this.byteArrayConverter.classOidToByteArray((ClassOid)object, bytes, offset, "oid value");
                break;
            }
            default: {
                throw new RuntimeException("native type with odb type id " + odbTypeId + " (" + ODBType.getNameFromId(odbTypeId) + ") for attribute ? is not suported");
            }
        }
        return new AttributeIdentification(originalPosition, objectSize);
    }

    protected AttributeIdentification nativeObjectInfoToBytes(NativeObjectInfo noi, Bytes bytes, int offset, ConversionContext context) {
        if (this.debug) {
            DLogger.debug("  Start writing native object : Type=" + ODBType.getNameFromId(noi.getOdbTypeId()) + " | Value=" + noi.toString() + " | at " + ((long)offset + bytes.getOffset()));
        }
        try {
            if (noi.isNull()) {
                int objectSize = this.nativeObjectHeaderToBytes(noi.getOdbTypeId(), true, (byte)3, bytes, offset);
                AttributeIdentification attributeIdentification = new AttributeIdentification(offset, objectSize);
                return attributeIdentification;
            }
            if (noi.isAtomicNativeObject()) {
                AttributeIdentification attributeIdentification = this.atomicNativeObjectToBytes((AtomicNativeObjectInfo)noi, bytes, offset);
                return attributeIdentification;
            }
            if (noi.isCollectionObject()) {
                AttributeIdentification attributeIdentification = this.collectionToBytes((CollectionObjectInfo)noi, bytes, offset, context);
                return attributeIdentification;
            }
            if (noi.isMapObject()) {
                AttributeIdentification attributeIdentification = this.mapToBytes((MapObjectInfo)noi, bytes, offset, context);
                return attributeIdentification;
            }
            if (noi.isArrayObject()) {
                AttributeIdentification attributeIdentification = this.arrayToBytes((ArrayObjectInfo)noi, bytes, offset, context);
                return attributeIdentification;
            }
            if (noi.isEnumObject()) {
                AttributeIdentification attributeIdentification = this.enumNativeObjectToBytes((EnumNativeObjectInfo)noi, bytes, offset);
                return attributeIdentification;
            }
            throw new NeoDatisRuntimeException(NeoDatisError.NATIVE_TYPE_NOT_SUPPORTED.addParameter(noi.getOdbTypeId()));
        }
        finally {
            if (this.debug) {
                DLogger.debug("  End writing native object : Type=" + ODBType.getNameFromId(noi.getOdbTypeId()) + " | Value=" + noi.toString() + " | at " + ((long)offset + bytes.getOffset()));
            }
        }
    }

    protected AttributeIdentification internalToBytesWrapper(AbstractObjectInfo aoi, Bytes bytes, int offset, ConversionContext context) {
        if (aoi.isNative()) {
            return this.nativeObjectInfoToBytes((NativeObjectInfo)aoi, bytes, offset, context);
        }
        if (aoi.isNonNativeObject() && aoi.isNull()) {
            return new AttributeIdentification(this.session.getOidGenerator().getNullObjectOid());
        }
        if (aoi.isNonNativeObject() && !aoi.isObjectReference()) {
            this.internalMetaToBytes((NonNativeObjectInfo)aoi, context);
            ObjectOid oid = context.getLastOid();
            return new AttributeIdentification(oid);
        }
        ObjectReference objectReference = (ObjectReference)aoi;
        if (objectReference.getOid() == null) {
            this.internalMetaToBytes((NonNativeObjectInfo)aoi, context);
            ObjectOid oid = context.getLastOid();
            return new AttributeIdentification(oid);
        }
        return new AttributeIdentification(objectReference.getOid());
    }

    protected AttributeIdentification collectionToBytes(CollectionObjectInfo coi, Bytes bytes, int offset, ConversionContext context) {
        if (this.debug) {
            DLogger.debug("  <start writing collection at " + offset + ">");
        }
        int objectSize = this.nativeObjectHeaderToBytes(coi.getOdbTypeId(), coi.isNull(), (byte)8, bytes, offset);
        if (coi.isNull()) {
            return new AttributeIdentification(offset, objectSize);
        }
        Collection<AbstractObjectInfo> collection = coi.getCollection();
        int collectionSize = collection.size();
        Iterator<AbstractObjectInfo> iterator = collection.iterator();
        objectSize += this.byteArrayConverter.stringToByteArray(coi.getRealCollectionClassName(), false, bytes, offset + objectSize, "real collection class");
        objectSize += this.byteArrayConverter.intToByteArray(collectionSize, bytes, offset + objectSize, "collection size");
        AttributeIdentification[] attributeIdentifications = new AttributeIdentification[collectionSize];
        int headerPosition = objectSize + offset;
        objectSize += this.byteArrayConverter.intToByteArray(0, bytes, headerPosition, "header position");
        int currentElement = 0;
        AbstractObjectInfo element = null;
        while (iterator.hasNext()) {
            AttributeIdentification ai;
            element = iterator.next();
            attributeIdentifications[currentElement] = ai = this.internalToBytesWrapper(element, bytes, offset + objectSize, context);
            ++currentElement;
            if (!ai.isNative) continue;
            objectSize += ai.size;
        }
        this.byteArrayConverter.intToByteArray(offset + objectSize, bytes, headerPosition, "header position");
        if (this.debug) {
            DLogger.debug("     <start writing header collection at" + (offset + objectSize) + " >");
        }
        int headerRealSize = this.headerToBytes(attributeIdentifications, bytes, objectSize + offset, false);
        if (this.debug) {
            DLogger.debug("     <end writing header collection at" + (offset + objectSize) + " >");
        }
        if (this.debug) {
            DLogger.debug("  <end writing collection at " + offset + " size=" + (objectSize + headerRealSize) + ">");
        }
        int totalObjectSize = objectSize + headerRealSize;
        return new AttributeIdentification(offset, totalObjectSize);
    }

    protected AttributeIdentification arrayToBytes(ArrayObjectInfo aoi, Bytes bytes, int offset, ConversionContext context) {
        if (this.debug) {
            DLogger.debug("<start writing array at " + ((long)offset + bytes.getOffset()) + ">");
        }
        int objectSize = this.nativeObjectHeaderToBytes(aoi.getOdbTypeId(), aoi.isNull(), (byte)9, bytes, offset);
        if (aoi.isNull()) {
            return new AttributeIdentification(offset, objectSize);
        }
        AbstractObjectInfo[] array = aoi.getArray();
        int arraySize = array.length;
        objectSize += this.byteArrayConverter.stringToByteArray(aoi.getRealArrayComponentClassName(), false, bytes, offset + objectSize, "real array type");
        objectSize += this.byteArrayConverter.intToByteArray(arraySize, bytes, offset + objectSize, "array size");
        AttributeIdentification[] attributeIdentifications = new AttributeIdentification[arraySize];
        int headerPosition = objectSize + offset;
        objectSize += this.byteArrayConverter.intToByteArray(0, bytes, headerPosition, "header position");
        AbstractObjectInfo element = null;
        for (int i = 0; i < arraySize; ++i) {
            AttributeIdentification ai;
            element = array[i];
            if (element == null) {
                throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
            }
            attributeIdentifications[i] = ai = this.internalToBytesWrapper(element, bytes, offset + objectSize, context);
            if (!ai.isNative) continue;
            objectSize += ai.size;
        }
        this.byteArrayConverter.intToByteArray(offset + objectSize, bytes, headerPosition, "header position");
        if (this.debug) {
            DLogger.debug("     <start writing header array at" + (offset + objectSize) + " >");
        }
        int headerRealSize = this.headerToBytes(attributeIdentifications, bytes, objectSize + offset, false);
        if (this.debug) {
            DLogger.debug("     <end writing header array at" + (offset + objectSize) + " >");
        }
        if (this.debug) {
            DLogger.debug("  <end writing array at " + offset + " size=" + (objectSize + headerRealSize) + ">");
        }
        int totalObjectSize = objectSize + headerRealSize;
        return new AttributeIdentification(offset, totalObjectSize);
    }

    protected AttributeIdentification mapToBytes(MapObjectInfo moi, Bytes bytes, int offset, ConversionContext context) {
        int objectSize = this.nativeObjectHeaderToBytes(moi.getOdbTypeId(), moi.isNull(), (byte)10, bytes, offset);
        if (moi.isNull()) {
            return new AttributeIdentification(offset, objectSize);
        }
        Map<AbstractObjectInfo, AbstractObjectInfo> map = moi.getMap();
        int mapSize = map.size();
        Iterator<AbstractObjectInfo> keys = map.keySet().iterator();
        objectSize += this.byteArrayConverter.stringToByteArray(moi.getRealMapClassName(), false, bytes, offset + objectSize, "real map class");
        objectSize += this.byteArrayConverter.intToByteArray(mapSize, bytes, offset + objectSize, "map size");
        AttributeIdentification[] attributeIdentifications = new AttributeIdentification[mapSize * 2];
        int nbNonNativeObjects = moi.getNonNativeObjects().size();
        int nbNativeObjects = mapSize * 2 - nbNonNativeObjects;
        int headerPosition = objectSize + offset;
        objectSize += this.byteArrayConverter.intToByteArray(0, bytes, offset + objectSize, "header pos");
        int currentElement = 0;
        AttributeIdentification ai = null;
        while (keys.hasNext()) {
            AbstractObjectInfo key = keys.next();
            AbstractObjectInfo value = map.get(key);
            ODBType keyType = ODBType.getFromClass(key.getClass());
            ODBType valueType = ODBType.getFromClass(value.getClass());
            ai = this.internalToBytesWrapper(key, bytes, offset + objectSize, context);
            attributeIdentifications[currentElement++] = ai;
            if (ai.isNative) {
                objectSize += ai.size;
            }
            ai = this.internalToBytesWrapper(value, bytes, offset + objectSize, context);
            attributeIdentifications[currentElement++] = ai;
            if (!ai.isNative) continue;
            objectSize += ai.size;
        }
        this.byteArrayConverter.intToByteArray(offset + objectSize, bytes, headerPosition, "header pos");
        int headerRealSize = this.headerToBytes(attributeIdentifications, bytes, offset + objectSize, false);
        objectSize += headerRealSize;
        objectSize += this.byteArrayConverter.intToByteArray(objectSize, bytes, offset + objectSize, "object size");
        int crc = this.computeCrc(bytes);
        objectSize += this.byteArrayConverter.intToByteArray(crc, bytes, offset + objectSize, "crc");
        return new AttributeIdentification(offset, objectSize);
    }

    protected AttributeIdentification enumNativeObjectToBytes(EnumNativeObjectInfo anoi, Bytes bytes, int offset) {
        int odbTypeId = anoi.getOdbTypeId();
        int objectSize = this.nativeObjectHeaderToBytes(odbTypeId, anoi.isNull(), (byte)3, bytes, offset);
        objectSize += this.byteArrayConverter.classOidToByteArray(anoi.getEnumClassInfo().getOid(), bytes, offset + objectSize, "enum class id");
        objectSize += this.byteArrayConverter.stringToByteArray(anoi.getObject().toString(), true, bytes, offset + objectSize, "enum value");
        return new AttributeIdentification(offset, objectSize);
    }

    @Override
    public IOdbList<OidAndBytes> classInfoToBytes(ClassInfo classInfo) {
        if (this.debug) {
            DLogger.debug(String.format("<ci start writing class info with oid %s : %s>", classInfo.getOid(), classInfo.toString()));
        }
        Bytes bytes = BytesFactory.getBytes();
        int objectSize = 0;
        objectSize += this.byteArrayConverter.intToByteArray(0, bytes, objectSize, "ci check sum");
        objectSize += this.byteArrayConverter.intToByteArray(0, bytes, objectSize, "ci object size");
        objectSize += this.byteArrayConverter.byteToByteArray((byte)1, bytes, objectSize, "ci object type");
        objectSize += this.byteArrayConverter.byteToByteArray(classInfo.getClassCategory(), bytes, objectSize, "ci category");
        objectSize += this.byteArrayConverter.classOidToByteArray(classInfo.getOid(), bytes, objectSize, "ci id");
        objectSize += this.byteArrayConverter.classOidToByteArray(classInfo.getSuperClassOid(), bytes, objectSize, "ci super class id");
        objectSize += this.byteArrayConverter.stringToByteArray(classInfo.getFullClassName(), false, bytes, objectSize, "ci name");
        objectSize += this.byteArrayConverter.intToByteArray(classInfo.getMaxAttributeId(), bytes, objectSize, "max attribute id");
        objectSize += this.byteArrayConverter.intToByteArray(classInfo.getAttributes().size(), bytes, objectSize, "ci nb attributes");
        ClassAttributeInfo cai = null;
        for (int i = 0; i < classInfo.getAttributes().size(); ++i) {
            cai = classInfo.getAttributes().get(i);
            objectSize += this.classAttributeInfoToBytes(cai, bytes, objectSize);
        }
        this.byteArrayConverter.intToByteArray(objectSize, bytes, 4, "ci object size");
        OidAndBytes oidAndBytes = new OidAndBytes(classInfo.getOid(), bytes);
        OdbArrayList<OidAndBytes> l = new OdbArrayList<OidAndBytes>();
        l.add(oidAndBytes);
        if (this.debug) {
            DLogger.debug(String.format("<ci end writing class info with oid %s >", classInfo.getOid()));
        }
        return l;
    }

    private int classAttributeInfoToBytes(ClassAttributeInfo cai, Bytes bytes, int position) {
        int originalPosition = position;
        position += this.byteArrayConverter.intToByteArray(cai.getId(), bytes, position, "attribute id");
        position += this.byteArrayConverter.booleanToByteArray(cai.isNative(), bytes, position, "is native?");
        if (cai.isNative()) {
            position += this.byteArrayConverter.intToByteArray(cai.getAttributeType().getId(), bytes, position, "att odb type id");
            if (cai.getAttributeType().isArray()) {
                ODBType subType = cai.getAttributeType().getSubType();
                position += this.byteArrayConverter.intToByteArray(subType.getId(), bytes, position, "att array sub type");
                if (subType.isNonNative()) {
                    ClassInfo ci = this.session.getClassInfo(subType.getName());
                    position += this.byteArrayConverter.classOidToByteArray(ci.getOid(), bytes, position, "class info id of array subtype");
                }
            } else if (cai.getAttributeType().isEnum()) {
                ClassInfo enumCi = this.session.getClassInfo(cai.getClassName());
                position += this.byteArrayConverter.classOidToByteArray(enumCi.getOid(), bytes, position, "class info id of array subtype");
            }
        } else {
            position += this.byteArrayConverter.classOidToByteArray(cai.getAttributeClassOid(), bytes, position, "attribute class info id");
        }
        position += this.byteArrayConverter.stringToByteArray(cai.getName(), false, bytes, position, "attribute name");
        return position - originalPosition;
    }

    @Override
    public void writeDatabaseHeader(DatabaseInfo di) {
    }
}

