/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.config;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.neodatis.odb.DatabaseStartupManager;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisGlobalConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.CoreProvider;
import org.neodatis.odb.core.CoreProviderImpl;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.config.ConfigFileReader;
import org.neodatis.odb.core.config.Server;
import org.neodatis.odb.core.layers.layer3.DataConverterImpl;
import org.neodatis.odb.core.layers.layer4.plugin.jdbm.NeoDatisJdbmPlugin;
import org.neodatis.odb.core.oid.uuid.UniqueOidGeneratorImpl;
import org.neodatis.odb.core.query.IQueryExecutorCallback;
import org.neodatis.odb.core.server.MessageStreamerImpl;
import org.neodatis.tool.wrappers.NeoDatisClassLoader;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoDatisConfigImpl
implements NeoDatisConfig {
    protected boolean coreProviderInit = false;
    protected boolean debugEnabled = false;
    protected boolean logAll = false;
    protected int debugLevel = 100;
    protected Map<String, String> logIds = null;
    protected boolean infoEnabled = false;
    protected long maxNumberOfObjectInCache = 3000000L;
    protected boolean automaticCloseFileOnExit = false;
    protected String defaultDatabaseCharacterEncoding;
    protected String databaseCharacterEncoding = this.defaultDatabaseCharacterEncoding = "ISO8859-1";
    protected boolean throwExceptionWhenInconsistencyFound = true;
    protected boolean checkMetaModelCompatibility = true;
    protected boolean logSchemaEvolutionAnalysis = false;
    protected boolean monitorMemory = false;
    protected boolean debugLayers = false;
    protected boolean debugMessageStreamer = false;
    protected boolean debugStorageEngine = false;
    protected long timeoutToAcquireMutex = 1000L;
    protected int socketTimeoutForClientServer = 60000;
    protected String baseName;
    protected boolean enableEmptyConstructorCreation = true;
    protected boolean retryIfFileIsLocked = true;
    protected int numberOfRetryToOpenFile = 5;
    protected long retryTimeout = 100L;
    protected boolean automaticallyIncreaseCacheSize = false;
    protected boolean useCache = true;
    protected boolean logServerStartupAndShutdown = true;
    protected boolean logServerConnections = false;
    protected int defaultIndexBTreeDegree = 20;
    protected int defaultCollectionBTreeDegree = 20;
    protected boolean useLazyCache = false;
    protected boolean displayWarnings = true;
    protected IQueryExecutorCallback queryExecutorCallback = null;
    protected int scaleForAverageDivision = 2;
    protected int roundTypeForAverageDivision = 5;
    protected String encryptionPassword;
    protected CoreProvider coreProvider;
    protected boolean checkRuntimeVersion = true;
    protected boolean reconnectObjectsToSession = false;
    protected ClassLoader classLoader = NeoDatisClassLoader.getCurrent();
    protected Class messageStreamerClass = MessageStreamerImpl.class;
    protected boolean useIndex = true;
    protected boolean shareSameVmConnectionMultiThread = true;
    protected boolean lockObjectsOnSelect = false;
    protected String baseDirectory = ".";
    protected boolean useLazyInstantiationInServerMode = true;
    protected DatabaseStartupManager databaseStartupManager = null;
    protected boolean sessionAutoCommit = true;
    protected Class storageEngineClass = NeoDatisJdbmPlugin.class;
    protected boolean transactional = true;
    protected String user;
    protected String password;
    protected String homeDirectory;
    protected String host;
    protected int port;
    protected boolean isLocal = true;
    protected boolean allowDirtyReads;
    protected boolean commitNoSync;
    protected boolean useNativeConfig;
    protected List<Server> servers = new ArrayList<Server>();
    protected String inboxDirectory = "inbox";
    protected boolean ssl;
    protected Class oidGeneratorClass = UniqueOidGeneratorImpl.class;
    protected boolean useStorageEngineCache = true;
    protected boolean oidGeneratorUseCache = true;
    protected String userInfo;

    public NeoDatisConfigImpl(boolean override) {
        this.coreProvider = new CoreProviderImpl(this);
        if (override) {
            this.checkMetaModelCompatibility = NeoDatisGlobalConfig.get().checkMetaModelCompatibility();
            this.scaleForAverageDivision = NeoDatisGlobalConfig.get().getScaleForAverageDivision();
            this.roundTypeForAverageDivision = NeoDatisGlobalConfig.get().getRoundTypeForAverageDivision();
            this.storageEngineClass = NeoDatisGlobalConfig.get().getStorageEngineClass();
            this.messageStreamerClass = NeoDatisGlobalConfig.get().getMessageStreamerClass();
            this.inboxDirectory = NeoDatisGlobalConfig.get().getInboxDirectory();
            this.debugLayers = NeoDatisGlobalConfig.get().debugLayers();
        }
    }

    public NeoDatisConfig updateFromFile(String fileName) throws ClassNotFoundException {
        String autocommit;
        Properties properties = new Properties();
        try {
            properties = ConfigFileReader.read(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String storageEngineClassName = properties.getProperty("storage.engine");
        if (storageEngineClassName != null) {
            this.setStorageEngineClass(Class.forName(storageEngineClassName));
        }
        if ((autocommit = properties.getProperty("session.autocommit")) != null) {
            this.setSessionAutoCommit(autocommit.equals("true"));
        } else {
            this.setSessionAutoCommit(false);
        }
        String serverInboxDirectory = properties.getProperty("inbox.directory");
        if (serverInboxDirectory != null) {
            this.setInboxDirectory(serverInboxDirectory);
        }
        return this;
    }

    @Override
    public boolean isSessionAutoCommit() {
        return this.sessionAutoCommit;
    }

    @Override
    public NeoDatisConfig setSessionAutoCommit(boolean sessionAutoCommit) {
        this.sessionAutoCommit = sessionAutoCommit;
        return this;
    }

    @Override
    public Class getStorageEngineClass() {
        return this.storageEngineClass;
    }

    @Override
    public NeoDatisConfig setStorageEngineClass(Class storageEngineClass) {
        this.storageEngineClass = storageEngineClass;
        return this;
    }

    @Override
    public boolean reconnectObjectsToSession() {
        return this.reconnectObjectsToSession;
    }

    @Override
    public NeoDatisConfig setReconnectObjectsToSession(boolean reconnectObjectsToSession) {
        this.reconnectObjectsToSession = reconnectObjectsToSession;
        return this;
    }

    @Override
    public NeoDatisConfig addLogId(String logId) {
        if (this.logIds == null) {
            this.logIds = new OdbHashMap<String, String>();
        }
        this.logIds.put(logId, logId);
        return this;
    }

    @Override
    public NeoDatisConfig removeLogId(String logId) {
        if (this.logIds == null) {
            this.logIds = new OdbHashMap<String, String>();
        }
        this.logIds.remove(logId);
        return this;
    }

    @Override
    public boolean isDebugEnabled(String logId) {
        if (!this.debugEnabled) {
            return false;
        }
        if (this.logAll) {
            return true;
        }
        if (this.logIds == null || this.logIds.size() == 0) {
            return false;
        }
        return this.logIds.containsKey(logId);
    }

    @Override
    public NeoDatisConfig setDebugEnabled(int level, boolean debug) {
        this.debugEnabled = debug;
        this.debugLevel = level;
        return this;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    @Override
    public boolean isInfoEnabled(String logId) {
        if (this.logAll) {
            return true;
        }
        if (this.logIds == null || this.logIds.size() == 0) {
            return false;
        }
        return this.logIds.containsKey(logId);
    }

    @Override
    public NeoDatisConfig setInfoEnabled(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
        return this;
    }

    @Override
    public long getMaxNumberOfObjectInCache() {
        return this.maxNumberOfObjectInCache;
    }

    @Override
    public NeoDatisConfig setMaxNumberOfObjectInCache(long maxNumberOfObjectInCache) {
        this.maxNumberOfObjectInCache = maxNumberOfObjectInCache;
        return this;
    }

    @Override
    public int getNumberOfRetryToOpenFile() {
        return this.numberOfRetryToOpenFile;
    }

    @Override
    public NeoDatisConfig setNumberOfRetryToOpenFile(int numberOfRetryToOpenFile) {
        this.numberOfRetryToOpenFile = numberOfRetryToOpenFile;
        return this;
    }

    @Override
    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    @Override
    public NeoDatisConfig setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    @Override
    public boolean retryIfFileIsLocked() {
        return this.retryIfFileIsLocked;
    }

    @Override
    public NeoDatisConfig setRetryIfFileIsLocked(boolean retryIfFileIsLocked) {
        this.retryIfFileIsLocked = retryIfFileIsLocked;
        return this;
    }

    @Override
    public boolean isMultiThread() {
        return this.retryIfFileIsLocked;
    }

    @Override
    public NeoDatisConfig useMultiThread(boolean yes) {
        this.useMultiThread(yes, this.numberOfRetryToOpenFile);
        return this;
    }

    @Override
    public NeoDatisConfig useMultiThread(boolean yes, int numberOfThreads) {
        this.setRetryIfFileIsLocked(yes);
        if (yes) {
            this.setNumberOfRetryToOpenFile(numberOfThreads * 10);
            this.setRetryTimeout(50L);
        }
        return this;
    }

    @Override
    public boolean throwExceptionWhenInconsistencyFound() {
        return this.throwExceptionWhenInconsistencyFound;
    }

    @Override
    public NeoDatisConfig setThrowExceptionWhenInconsistencyFound(boolean throwExceptionWhenInconsistencyFound) {
        this.throwExceptionWhenInconsistencyFound = throwExceptionWhenInconsistencyFound;
        return this;
    }

    @Override
    public boolean automaticallyIncreaseCacheSize() {
        return this.automaticallyIncreaseCacheSize;
    }

    @Override
    public NeoDatisConfig setAutomaticallyIncreaseCacheSize(boolean automaticallyIncreaseCache) {
        this.automaticallyIncreaseCacheSize = automaticallyIncreaseCache;
        return this;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public NeoDatisConfig setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
        return this;
    }

    @Override
    public boolean checkMetaModelCompatibility() {
        return this.checkMetaModelCompatibility;
    }

    @Override
    public NeoDatisConfig setCheckMetaModelCompatibility(boolean checkModelCompatibility) {
        this.checkMetaModelCompatibility = checkModelCompatibility;
        return this;
    }

    @Override
    public boolean automaticCloseFileOnExit() {
        return this.automaticCloseFileOnExit;
    }

    @Override
    public NeoDatisConfig setAutomaticCloseFileOnExit(boolean automaticFileClose) {
        this.automaticCloseFileOnExit = automaticFileClose;
        return this;
    }

    @Override
    public boolean isLogAll() {
        return this.logAll;
    }

    @Override
    public NeoDatisConfig setLogAll(boolean logAll) {
        this.logAll = logAll;
        return this;
    }

    @Override
    public boolean logServerConnections() {
        return this.logServerConnections;
    }

    @Override
    public NeoDatisConfig setLogServerConnections(boolean logServerConnections) {
        this.logServerConnections = logServerConnections;
        return this;
    }

    @Override
    public int getDefaultIndexBTreeDegree() {
        return this.defaultIndexBTreeDegree;
    }

    @Override
    public NeoDatisConfig setDefaultIndexBTreeDegree(int defaultIndexBTreeSize) {
        this.defaultIndexBTreeDegree = defaultIndexBTreeSize;
        return this;
    }

    @Override
    public int getDefaultCollectionBTreeDegree() {
        return this.defaultCollectionBTreeDegree;
    }

    @Override
    public NeoDatisConfig setDefaultCollectionBTreeDegree(int defaultIndexBTreeSize) {
        this.defaultCollectionBTreeDegree = defaultIndexBTreeSize;
        return this;
    }

    @Override
    public boolean useLazyCache() {
        return this.useLazyCache;
    }

    @Override
    public NeoDatisConfig setUseLazyCache(boolean useLazyCache) {
        this.useLazyCache = useLazyCache;
        return this;
    }

    @Override
    public IQueryExecutorCallback getQueryExecutorCallback() {
        return this.queryExecutorCallback;
    }

    @Override
    public NeoDatisConfig setQueryExecutorCallback(IQueryExecutorCallback queryExecutorCallback) {
        this.queryExecutorCallback = queryExecutorCallback;
        return this;
    }

    @Override
    public boolean useCache() {
        return this.useCache;
    }

    @Override
    public NeoDatisConfig setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    @Override
    public boolean monitoringMemory() {
        return this.monitorMemory;
    }

    @Override
    public NeoDatisConfig setMonitorMemory(boolean yes) {
        this.monitorMemory = yes;
        return this;
    }

    @Override
    public boolean displayWarnings() {
        return this.displayWarnings;
    }

    @Override
    public NeoDatisConfig setDisplayWarnings(boolean yesOrNo) {
        this.displayWarnings = yesOrNo;
        return this;
    }

    @Override
    public int getScaleForAverageDivision() {
        return this.scaleForAverageDivision;
    }

    @Override
    public NeoDatisConfig setScaleForAverageDivision(int scaleForAverageDivision) {
        this.scaleForAverageDivision = scaleForAverageDivision;
        return this;
    }

    @Override
    public int getRoundTypeForAverageDivision() {
        return this.roundTypeForAverageDivision;
    }

    @Override
    public NeoDatisConfig setRoundTypeForAverageDivision(int roundTypeForAverageDivision) {
        this.roundTypeForAverageDivision = roundTypeForAverageDivision;
        return this;
    }

    @Override
    public boolean enableEmptyConstructorCreation() {
        return this.enableEmptyConstructorCreation;
    }

    @Override
    public NeoDatisConfig setEnableEmptyConstructorCreation(boolean enableEmptyConstructorCreation) {
        this.enableEmptyConstructorCreation = enableEmptyConstructorCreation;
        return this;
    }

    @Override
    public String getEncryptionPassword() {
        return this.encryptionPassword;
    }

    @Override
    public CoreProvider getCoreProvider() {
        if (!this.coreProviderInit) {
            this.coreProviderInit = true;
            try {
                this.coreProvider.init2();
            }
            catch (Exception e) {
                throw new NeoDatisRuntimeException(NeoDatisError.ERROR_IN_CORE_PROVIDER_INITIALIZATION.addParameter("Core Provider"), (Throwable)e);
            }
        }
        return this.coreProvider;
    }

    @Override
    public NeoDatisConfig setCoreProvider(CoreProvider coreProvider) {
        this.coreProvider = coreProvider;
        return this;
    }

    @Override
    public String getDatabaseCharacterEncoding() {
        return this.databaseCharacterEncoding;
    }

    @Override
    public NeoDatisConfig setDatabaseCharacterEncoding(String dbCharacterEncoding) throws UnsupportedEncodingException {
        if (dbCharacterEncoding != null) {
            new DataConverterImpl(false, dbCharacterEncoding, this).testEncoding(dbCharacterEncoding);
            this.databaseCharacterEncoding = dbCharacterEncoding;
        } else {
            this.databaseCharacterEncoding = null;
        }
        return this;
    }

    @Override
    public NeoDatisConfig setLatinDatabaseCharacterEncoding() throws UnsupportedEncodingException {
        this.databaseCharacterEncoding = this.defaultDatabaseCharacterEncoding;
        return this;
    }

    @Override
    public boolean hasEncoding() {
        return this.databaseCharacterEncoding != null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public NeoDatisConfig setClassLoader(ClassLoader cl) {
        if (cl == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Class loader is null!"));
        }
        this.classLoader = cl;
        return this;
    }

    @Override
    public boolean checkRuntimeVersion() {
        return this.checkRuntimeVersion;
    }

    @Override
    public NeoDatisConfig setCheckRuntimeVersion(boolean checkJavaRuntimeVersion) {
        this.checkRuntimeVersion = checkJavaRuntimeVersion;
        return this;
    }

    @Override
    public Class getMessageStreamerClass() {
        return this.messageStreamerClass;
    }

    @Override
    public NeoDatisConfig setMessageStreamerClass(Class messageStreamerClass) {
        this.messageStreamerClass = messageStreamerClass;
        return this;
    }

    @Override
    public boolean logServerStartupAndShutdown() {
        return this.logServerStartupAndShutdown;
    }

    @Override
    public NeoDatisConfig setLogServerStartupAndShutdown(boolean logServerStartup) {
        this.logServerStartupAndShutdown = logServerStartup;
        return this;
    }

    @Override
    public boolean useIndex() {
        return this.useIndex;
    }

    @Override
    public NeoDatisConfig setUseIndex(boolean useIndex) {
        this.useIndex = useIndex;
        return this;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public NeoDatisConfig setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    @Override
    public boolean shareSameVmConnectionMultiThread() {
        return this.shareSameVmConnectionMultiThread;
    }

    @Override
    public NeoDatisConfig setShareSameVmConnectionMultiThread(boolean shareSameVmConnectionMultiThread) {
        this.shareSameVmConnectionMultiThread = shareSameVmConnectionMultiThread;
        return this;
    }

    @Override
    public NeoDatisConfig lockObjectsOnSelect(boolean yesNo) {
        this.lockObjectsOnSelect = yesNo;
        return this;
    }

    @Override
    public boolean lockObjectsOnSelect() {
        return this.lockObjectsOnSelect;
    }

    @Override
    public boolean debugLayers() {
        return this.debugLayers;
    }

    @Override
    public NeoDatisConfig setDebugLayers(boolean yesNo) {
        this.debugLayers = yesNo;
        return this;
    }

    @Override
    public boolean debugMessageStreamer() {
        return this.debugMessageStreamer;
    }

    public NeoDatisConfig setDebugMessageStreamer(boolean yesNo) {
        this.debugMessageStreamer = yesNo;
        return this;
    }

    @Override
    public boolean debugStorageEngine() {
        return this.debugStorageEngine;
    }

    @Override
    public NeoDatisConfig setDebugStorageEngine(boolean yesNo) {
        this.debugStorageEngine = yesNo;
        return this;
    }

    @Override
    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public NeoDatisConfig setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    @Override
    public boolean useLazyInstantiationInServerMode() {
        return this.useLazyInstantiationInServerMode;
    }

    @Override
    public NeoDatisConfig setUseLazyInstantiationInServerMode(boolean useLazyInstantiationInServerMode) {
        this.useLazyInstantiationInServerMode = useLazyInstantiationInServerMode;
        return this;
    }

    @Override
    public long getTimeoutToAcquireMutex() {
        return this.timeoutToAcquireMutex;
    }

    @Override
    public NeoDatisConfig registerDatabaseStartupManager(DatabaseStartupManager manager) {
        this.databaseStartupManager = manager;
        return this;
    }

    @Override
    public NeoDatisConfig removeDatabaseStartupManager() {
        this.databaseStartupManager = null;
        return this;
    }

    @Override
    public DatabaseStartupManager getDatabaseStartupManager() {
        return this.databaseStartupManager;
    }

    @Override
    public boolean logSchemaEvolutionAnalysis() {
        return this.logSchemaEvolutionAnalysis;
    }

    @Override
    public NeoDatisConfig setLogSchemaEvolutionAnalysis(boolean log) {
        this.logSchemaEvolutionAnalysis = log;
        return this;
    }

    @Override
    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public NeoDatisConfig setTransactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public NeoDatisConfig setUser(String user) {
        this.user = user;
        return this;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public NeoDatisConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public NeoDatisConfig setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
        return this;
    }

    @Override
    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public NeoDatisConfig setHostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
        this.servers.add(new Server(host, port));
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public NeoDatisConfig setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public NeoDatisConfig setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
        return this;
    }

    @Override
    public NeoDatisConfig copy() {
        NeoDatisConfigImpl p = new NeoDatisConfigImpl(false);
        p.setHomeDirectory(this.getHomeDirectory());
        p.setHostAndPort(this.getHost(), this.getPort());
        p.setIsLocal(this.isLocal());
        p.setPassword(this.getPassword());
        p.setPort(this.getPort());
        p.setTransactional(this.isTransactional());
        p.setUser(this.getUser());
        p.servers.clear();
        p.servers.addAll(this.servers);
        return p;
    }

    @Override
    public NeoDatisConfig addServer(String host, int port) {
        this.servers.add(new Server(host, port));
        return this;
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }

    @Override
    public boolean useNativeConfig() {
        return this.useNativeConfig;
    }

    @Override
    public NeoDatisConfig setUseNativeConfig(boolean useNativeConfig) {
        this.useNativeConfig = useNativeConfig;
        return this;
    }

    @Override
    public int getNumberOfServers() {
        return this.servers.size();
    }

    @Override
    public NeoDatisConfig setUserAndPassword(String user, String password) {
        this.setUser(user);
        this.setPassword(password);
        return this;
    }

    @Override
    public String getInboxDirectory() {
        return this.inboxDirectory;
    }

    @Override
    public NeoDatisConfig setInboxDirectory(String dir) {
        this.inboxDirectory = dir;
        return this;
    }

    @Override
    public boolean isSSL() {
        return this.ssl;
    }

    @Override
    public NeoDatisConfig setSSL(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    @Override
    public Class getOidGeneratorClass() {
        return this.oidGeneratorClass;
    }

    @Override
    public NeoDatisConfig setOidGeneratorClass(Class oidGeneratorClass) {
        this.oidGeneratorClass = oidGeneratorClass;
        return this;
    }

    @Override
    public NeoDatisConfig setUseStorageEngineCache(boolean yesOrNo) {
        this.useStorageEngineCache = yesOrNo;
        return this;
    }

    @Override
    public boolean useStorageEngineCache() {
        return this.useStorageEngineCache;
    }

    @Override
    public NeoDatisConfig setOidGeneratorUseCache(boolean yesOrNo) {
        this.oidGeneratorUseCache = yesOrNo;
        return this;
    }

    @Override
    public boolean oidGeneratorUseCache() {
        return this.oidGeneratorUseCache;
    }

    @Override
    public int getSocketTimeoutForClientSever() {
        return this.socketTimeoutForClientServer;
    }

    @Override
    public NeoDatisConfig setClientServerSocketTimeout(int t) {
        this.socketTimeoutForClientServer = t;
        return this;
    }

    @Override
    public String getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public NeoDatisConfig setBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }
}

